/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.UserAccountWrapper;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateFolderRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.CreateRoomRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.EnumSet;

public class SDSDirectoryFeature
implements Directory<VersionId> {
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSDirectoryFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path mkdir(Path folder, String region, TransferStatus status) throws BackgroundException {
        try {
            if (this.containerService.isContainer(folder)) {
                CreateRoomRequest roomRequest = new CreateRoomRequest();
                UserAccountWrapper user = this.session.userAccount();
                roomRequest.addAdminIdsItem(user.getId());
                roomRequest.setAdminGroupIds(null);
                if (!folder.getParent().isRoot()) {
                    roomRequest.setParentId(Long.parseLong(this.nodeid.getFileid(folder.getParent(), (ListProgressListener)new DisabledListProgressListener())));
                }
                roomRequest.setName(folder.getName());
                Node r = new NodesApi((ApiClient)this.session.getClient()).createRoom(roomRequest, "", null);
                return new Path(folder.getParent(), folder.getName(), EnumSet.of(AbstractPath.Type.directory, AbstractPath.Type.volume), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(r));
            }
            CreateFolderRequest folderRequest = new CreateFolderRequest();
            folderRequest.setParentId(Long.parseLong(this.nodeid.getFileid(folder.getParent(), (ListProgressListener)new DisabledListProgressListener())));
            folderRequest.setName(folder.getName());
            Node f = new NodesApi((ApiClient)this.session.getClient()).createFolder(folderRequest, "", null);
            return new Path(folder.getParent(), folder.getName(), folder.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(f));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Cannot create folder {0}", e, folder);
        }
    }

    public boolean isSupported(Path workdir, String name) {
        return true;
    }

    public Directory<VersionId> withWriter(Write<VersionId> writer) {
        return this;
    }
}

