/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.googledrive.DriveExceptionMappingService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import com.google.api.services.drive.Drive;
import com.google.api.services.drive.model.File;
import java.io.IOException;
import java.util.Collections;

public class DriveCopyFeature
implements Copy {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveCopyFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            File copy = (File)((Drive)this.session.getClient()).files().copy(this.fileid.getFileid(source, (ListProgressListener)new DisabledListProgressListener()), new File().setParents(Collections.singletonList(this.fileid.getFileid(target.getParent(), (ListProgressListener)new DisabledListProgressListener()))).setName(target.getName())).setSupportsTeamDrives(Boolean.valueOf(PreferencesFactory.get().getBoolean("googledrive.teamdrive.enable"))).execute();
            return new Path(target.getParent(), target.getName(), target.getType(), new PathAttributes(target.attributes()).withVersionId(copy.getId()));
        }
        catch (IOException e) {
            throw new DriveExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (target.isRoot()) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.placeholder);
    }

    public Copy withTarget(Session<?> session) {
        return this;
    }
}

