/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.googledrive.AbstractDriveListService;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.webloc.UrlFileWriterFactory;
import com.google.api.services.drive.model.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class DriveAttributesFinderFeature
implements AttributesFinder {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveAttributesFinderFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        AttributedList<Path> list = new FileidDriveListService(this.session, this.fileid, file).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
        Path found = (Path)list.find((Predicate)new SimplePathPredicate(file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return found.attributes();
    }

    protected PathAttributes toAttributes(File f) {
        PathAttributes attributes = new PathAttributes();
        if (null != f.getExplicitlyTrashed() && f.getExplicitlyTrashed().booleanValue()) {
            attributes.setDuplicate(true);
        }
        if (null != f.getSize() && !AbstractDriveListService.DRIVE_FOLDER.equals(f.getMimeType()) && !StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)"application/vnd.google-apps")) {
            attributes.setSize(f.getSize().longValue());
        }
        attributes.setVersionId(f.getId());
        if (f.getModifiedTime() != null) {
            attributes.setModificationDate(f.getModifiedTime().getValue());
        }
        if (f.getCreatedTime() != null) {
            attributes.setCreationDate(f.getCreatedTime().getValue());
        }
        attributes.setChecksum(Checksum.parse((String)f.getMd5Checksum()));
        if (StringUtils.isNotBlank((CharSequence)f.getWebViewLink())) {
            attributes.setLink(new DescriptiveUrl(URI.create(f.getWebViewLink()), DescriptiveUrl.Type.http, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), "HTTP")));
            if (!AbstractDriveListService.DRIVE_FOLDER.equals(f.getMimeType()) && StringUtils.startsWith((CharSequence)f.getMimeType(), (CharSequence)"application/vnd.google-apps")) {
                attributes.setSize((long)UrlFileWriterFactory.get().write(new DescriptiveUrl(URI.create(f.getWebViewLink()))).getBytes(Charset.defaultCharset()).length);
            }
        }
        return attributes;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

