/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Worker<T> {
    private final AtomicBoolean canceled = new AtomicBoolean();
    protected final PathContainerService containerService = new PathContainerService();

    protected String toString(List<Path> files) {
        if (files.isEmpty()) {
            return LocaleFactory.localizedString("None");
        }
        String name = files.get(0).getName();
        if (files.size() > 1) {
            return String.format("%s\u2026 (%s) (%d)", name, LocaleFactory.localizedString("Multiple files"), files.size());
        }
        return String.format("%s\u2026", name);
    }

    protected Set<Path> getContainers(List<Path> files) {
        HashSet<Path> containers = new HashSet<Path>();
        for (Path file : files) {
            containers.add(this.containerService.getContainer(file));
        }
        return containers;
    }

    public T run(Session<?> session) throws BackgroundException {
        throw new ConnectionCanceledException();
    }

    public void cleanup(T result) {
    }

    public String getActivity() {
        return LocaleFactory.localizedString("Unknown");
    }

    public void cancel() {
        this.canceled.set(true);
    }

    public boolean isCanceled() {
        return this.canceled.get();
    }

    public T initialize() {
        return null;
    }

    public static <T> Worker<T> empty() {
        return new Worker<T>(){

            @Override
            public T run(Session<?> session) throws BackgroundException {
                return null;
            }
        };
    }

    public void reset() throws BackgroundException {
    }

    public static interface RecursiveCallback<T> {
        public boolean recurse(Path var1, T var2);
    }
}

