/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.upload;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.transfer.symlink.SymlinkResolver;
import ch.cyberduck.core.transfer.upload.AbstractUploadFilter;
import ch.cyberduck.core.transfer.upload.UploadFilterOptions;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class RenameFilter
extends AbstractUploadFilter {
    private static final Logger log = Logger.getLogger(RenameFilter.class);

    public RenameFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session) {
        this(symlinkResolver, session, new UploadFilterOptions());
    }

    public RenameFilter(SymlinkResolver<Local> symlinkResolver, Session<?> session, UploadFilterOptions options) {
        super(symlinkResolver, session, options);
    }

    @Override
    public TransferStatus prepare(Path file, Local local, TransferStatus parent, ProgressListener progress) throws BackgroundException {
        TransferStatus status = super.prepare(file, local, parent, progress);
        if (status.isExists()) {
            String filename = file.getName();
            int no = 0;
            do {
                String proposal = String.format("%s-%d", FilenameUtils.getBaseName((String)filename), ++no);
                if (StringUtils.isNotBlank((CharSequence)FilenameUtils.getExtension((String)filename))) {
                    proposal = proposal + String.format(".%s", FilenameUtils.getExtension((String)filename));
                }
                if (parent.getRename().remote != null) {
                    status.rename(new Path(parent.getRename().remote, proposal, file.getType()));
                    continue;
                }
                status.rename(new Path(file.getParent(), proposal, file.getType()));
            } while (this.find.find(status.getRename().remote));
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Changed upload target from %s to %s", file, status.getRename().remote));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Clear exist flag for file %s", file));
            }
            status.setExists(false);
        } else {
            if (parent.getRename().remote != null) {
                status.rename(new Path(parent.getRename().remote, file.getName(), file.getType()));
            }
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Changed upload target from %s to %s", file, status.getRename().remote));
            }
        }
        return status;
    }
}

