/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.transfer.Transfer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TransferAction {
    private static final Map<String, TransferAction> registry = new HashMap<String, TransferAction>();
    private final String name;
    public static final TransferAction overwrite = new TransferAction("overwrite"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Overwrite", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Overwrite all files", "Transfer");
        }
    };
    public static final TransferAction resume = new TransferAction("resume"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Resume", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Append existing files", "Transfer");
        }
    };
    public static final TransferAction rename = new TransferAction("similar"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Rename", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Rename transferred files with a timestamp appended to the filename", "Transfer");
        }
    };
    public static final TransferAction renameexisting = new TransferAction("rename"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Rename existing", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Rename existing files with timestamp appended to filename", "Transfer");
        }
    };
    public static final TransferAction skip = new TransferAction("skip"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Skip", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Skip transfer of files that already exist", "Transfer");
        }
    };
    public static final TransferAction trash = new TransferAction("trash"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Trash", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Move files that already exist to the Trash", "Transfer");
        }
    };
    public static final TransferAction callback = new TransferAction("ask"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Prompt", "Localizable");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Prompt for action on every file", "Transfer");
        }
    };
    public static final TransferAction comparison = new TransferAction("compare"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Compare", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Skip files that match size, modification date or checksum", "Transfer");
        }
    };
    public static final TransferAction cancel = new TransferAction("cancel"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Cancel");
        }

        @Override
        public String getDescription() {
            return "";
        }
    };
    public static final TransferAction download = new TransferAction("download"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Download", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Download changed and missing files", "Transfer");
        }
    };
    public static final TransferAction upload = new TransferAction("upload"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Upload", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Upload changed and missing files", "Transfer");
        }
    };
    public static final TransferAction mirror = new TransferAction("mirror"){

        @Override
        public String getTitle() {
            return LocaleFactory.localizedString("Mirror", "Transfer");
        }

        @Override
        public String getDescription() {
            return LocaleFactory.localizedString("Download and Upload", "Transfer");
        }
    };

    public static TransferAction forName(String name) {
        return registry.get(name);
    }

    public static List<TransferAction> forTransfer(Transfer.Type t) {
        switch (t) {
            case sync: {
                return Arrays.asList(download, upload, mirror);
            }
            case copy: {
                return Arrays.asList(overwrite, comparison);
            }
        }
        return Arrays.asList(resume, overwrite, rename, renameexisting, skip, comparison);
    }

    public TransferAction(String name) {
        registry.put(name, this);
        this.name = name;
    }

    public abstract String getTitle();

    public abstract String getDescription();

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferAction that = (TransferAction)o;
        return !(this.name != null ? !this.name.equals(that.name) : that.name != null);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

