/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.local;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import ch.cyberduck.core.io.watchservice.WatchServiceFactory;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.threading.DefaultThreadPool;
import ch.cyberduck.core.threading.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class FileWatcher {
    private static final Logger log = Logger.getLogger(FileWatcher.class);
    private final RegisterWatchService monitor;
    private final ThreadPool pool;

    public FileWatcher() {
        this(WatchServiceFactory.get());
    }

    public FileWatcher(RegisterWatchService monitor) {
        this.monitor = monitor;
        this.pool = new DefaultThreadPool("watcher", 1);
    }

    public CountDownLatch register(final Local file, final FileWatcherListener listener) throws IOException {
        WatchKey key;
        final Path folder = new File(file.getParent().getAbsolute()).getCanonicalFile().toPath();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Register folder %s watching for file %s", folder, file));
        }
        if (!(key = this.monitor.register(folder, new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY}, new WatchEvent.Modifier[0])).isValid()) {
            throw new IOException(String.format("Failure registering for events in %s", file));
        }
        final CountDownLatch lock = new CountDownLatch(1);
        this.pool.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws IOException {
                WatchKey key;
                boolean valid;
                block3: do {
                    try {
                        lock.countDown();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Wait for key from watch service %s", FileWatcher.this.monitor));
                        }
                        key = FileWatcher.this.monitor.take();
                    }
                    catch (ClosedWatchServiceException e) {
                        return true;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Retrieved key %s from watch service %s", key, FileWatcher.this.monitor));
                    }
                    for (WatchEvent<?> event : key.pollEvents()) {
                        WatchEvent.Kind<?> kind = event.kind();
                        if (log.isInfoEnabled()) {
                            log.info((Object)String.format("Detected file system event %s", kind.name()));
                        }
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            log.error((Object)String.format("Overflow event for %s", folder));
                            continue block3;
                        }
                        if (FileWatcher.this.matches(FileWatcher.this.normalize(LocalFactory.get(folder.toString()), event.context().toString()), LocalFactory.get(folder.toString(), file.getName()))) {
                            FileWatcher.this.callback(LocalFactory.get(folder.toString()), event, listener);
                            continue;
                        }
                        log.warn((Object)String.format("Ignored file system event for unknown file %s", event.context()));
                    }
                } while (valid = key.reset());
                return true;
            }
        });
        return lock;
    }

    protected Local normalize(Local parent, String name) {
        if (StringUtils.startsWith((CharSequence)name, (CharSequence)String.valueOf(parent.getDelimiter()))) {
            return this.normalize(LocalFactory.get(name));
        }
        return this.normalize(LocalFactory.get(parent, name));
    }

    protected Local normalize(Local file) {
        try {
            return LocalFactory.get(new File(file.getAbsolute()).getCanonicalPath());
        }
        catch (IOException e) {
            log.warn((Object)String.format("Failure getting real path for file %s", file));
            return file;
        }
    }

    protected boolean matches(Local context, Local file) {
        if (!new File(context.getAbsolute()).isAbsolute()) {
            return context.getName().equals(file.getName());
        }
        return this.normalize(context).equals(this.normalize(file));
    }

    private void callback(Local folder, WatchEvent<?> event, FileWatcherListener l) {
        WatchEvent.Kind<?> kind = event.kind();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Process file system event %s for %s", kind.name(), event.context()));
        }
        if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
            l.fileWritten(this.normalize(folder, event.context().toString()));
        } else if (StandardWatchEventKinds.ENTRY_DELETE == kind) {
            l.fileDeleted(this.normalize(folder, event.context().toString()));
        } else if (StandardWatchEventKinds.ENTRY_CREATE == kind) {
            l.fileCreated(this.normalize(folder, event.context().toString()));
        } else {
            log.debug((Object)String.format("Ignored file system event %s for %s", kind.name(), event.context()));
        }
    }

    public void close() {
        try {
            this.monitor.close();
            this.pool.shutdown(false);
        }
        catch (IOException e) {
            log.error((Object)"Failure closing file watcher monitor", (Throwable)e);
        }
    }
}

