/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.spectralogic.ds3client.models.bulk.Ds3ObjectList;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.io.IOException;
import java.io.InputStream;

public final class XmlOutput {
    private static final JacksonXmlModule module = new JacksonXmlModule();
    private static final XmlMapper mapper;

    public static String toXml(Object object) {
        return XmlOutput.toXml(object, null);
    }

    private static String toXml(Object object, FilterProvider filterProvider) {
        try {
            if (filterProvider == null) {
                return mapper.writeValueAsString(object);
            }
            return mapper.writer(filterProvider).writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new XmlProcessingException((Exception)((Object)e));
        }
    }

    public static String toXml(Ds3ObjectList objects, boolean isBulkPut) {
        if (isBulkPut) {
            return XmlOutput.toXml(objects);
        }
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("sizeFilter", SimpleBeanPropertyFilter.serializeAllExcept((String[])new String[]{"Size"}));
        return XmlOutput.toXml((Object)objects, (FilterProvider)filters);
    }

    public static <T> T fromXml(String xmlString, Class<T> type) throws IOException {
        return (T)mapper.readValue(xmlString, type);
    }

    public static <T> T fromXml(InputStream stream, Class<T> type) throws IOException {
        return (T)mapper.readValue(stream, type);
    }

    static {
        module.setDefaultUseWrapper(false);
        mapper = new XmlMapper(module);
        mapper.registerModule((Module)new Jdk8Module());
        SimpleFilterProvider filterProvider = new SimpleFilterProvider().setFailOnUnknownId(false);
        mapper.setFilterProvider((FilterProvider)filterProvider);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

