/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobImpl;
import com.spectralogic.ds3client.helpers.MetadataAccess;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategyBuilder;
import java.io.IOException;

public class WriteJobImpl
extends JobImpl {
    private MetadataAccess metadataAccess = null;
    private ChecksumFunction checksumFunction = null;
    private TransferStrategy transferStrategy;

    public WriteJobImpl(TransferStrategy transferStrategy) {
        this.transferStrategy = transferStrategy;
    }

    public WriteJobImpl(TransferStrategyBuilder transferStrategyBuilder) {
        super(transferStrategyBuilder);
    }

    @Override
    public void attachMetadataReceivedListener(MetadataReceivedListener listener) {
        throw new IllegalStateException("Metadata listeners are not used with Write jobs");
    }

    @Override
    public void removeMetadataReceivedListener(MetadataReceivedListener listener) {
        throw new IllegalStateException("Metadata listeners are not used with Write jobs");
    }

    @Override
    public Ds3ClientHelpers.Job withMetadata(MetadataAccess access) {
        this.checkRunning();
        this.metadataAccess = access;
        return this;
    }

    @Override
    public Ds3ClientHelpers.Job withChecksum(ChecksumFunction checksumFunction) {
        this.checksumFunction = checksumFunction;
        return this;
    }

    @Override
    public void transfer(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder) throws IOException {
        if (this.transferStrategy != null) {
            this.transfer();
            return;
        }
        super.transfer(channelBuilder);
        this.transferStrategyBuilder().withChecksumFunction(this.checksumFunction);
        this.transferStrategyBuilder().withMetadataAccess(this.metadataAccess);
        this.transferStrategy = this.transferStrategyBuilder().makePutTransferStrategy();
        this.transfer();
    }

    @Override
    public void transfer() throws IOException {
        Preconditions.checkNotNull((Object)this.transferStrategy, (Object)"transferStrategy may not be null.");
        this.running = true;
        this.transferStrategy.transfer();
    }
}

