/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.VersioningLevel;
import com.spectralogic.ds3client.networking.HttpVerb;

public class PutDataPolicySpectraS3Request
extends AbstractRequest {
    private final String name;
    private boolean alwaysForcePutJobCreation;
    private boolean alwaysMinimizeSpanningAcrossMedia;
    private boolean blobbingEnabled;
    private ChecksumType.Type checksumType;
    private Long defaultBlobSize;
    private Priority defaultGetJobPriority;
    private Priority defaultPutJobPriority;
    private boolean defaultVerifyAfterWrite;
    private Priority defaultVerifyJobPriority;
    private boolean endToEndCrcRequired;
    private Priority rebuildPriority;
    private VersioningLevel versioning;

    public PutDataPolicySpectraS3Request(String name) {
        this.name = name;
        this.updateQueryParam("name", name);
    }

    public PutDataPolicySpectraS3Request withAlwaysForcePutJobCreation(boolean alwaysForcePutJobCreation) {
        this.alwaysForcePutJobCreation = alwaysForcePutJobCreation;
        this.updateQueryParam("always_force_put_job_creation", alwaysForcePutJobCreation);
        return this;
    }

    public PutDataPolicySpectraS3Request withAlwaysMinimizeSpanningAcrossMedia(boolean alwaysMinimizeSpanningAcrossMedia) {
        this.alwaysMinimizeSpanningAcrossMedia = alwaysMinimizeSpanningAcrossMedia;
        this.updateQueryParam("always_minimize_spanning_across_media", alwaysMinimizeSpanningAcrossMedia);
        return this;
    }

    public PutDataPolicySpectraS3Request withBlobbingEnabled(boolean blobbingEnabled) {
        this.blobbingEnabled = blobbingEnabled;
        this.updateQueryParam("blobbing_enabled", blobbingEnabled);
        return this;
    }

    public PutDataPolicySpectraS3Request withChecksumType(ChecksumType.Type checksumType) {
        this.checksumType = checksumType;
        this.updateQueryParam("checksum_type", checksumType);
        return this;
    }

    public PutDataPolicySpectraS3Request withDefaultBlobSize(Long defaultBlobSize) {
        this.defaultBlobSize = defaultBlobSize;
        this.updateQueryParam("default_blob_size", defaultBlobSize);
        return this;
    }

    public PutDataPolicySpectraS3Request withDefaultGetJobPriority(Priority defaultGetJobPriority) {
        this.defaultGetJobPriority = defaultGetJobPriority;
        this.updateQueryParam("default_get_job_priority", defaultGetJobPriority);
        return this;
    }

    public PutDataPolicySpectraS3Request withDefaultPutJobPriority(Priority defaultPutJobPriority) {
        this.defaultPutJobPriority = defaultPutJobPriority;
        this.updateQueryParam("default_put_job_priority", defaultPutJobPriority);
        return this;
    }

    public PutDataPolicySpectraS3Request withDefaultVerifyAfterWrite(boolean defaultVerifyAfterWrite) {
        this.defaultVerifyAfterWrite = defaultVerifyAfterWrite;
        this.updateQueryParam("default_verify_after_write", defaultVerifyAfterWrite);
        return this;
    }

    public PutDataPolicySpectraS3Request withDefaultVerifyJobPriority(Priority defaultVerifyJobPriority) {
        this.defaultVerifyJobPriority = defaultVerifyJobPriority;
        this.updateQueryParam("default_verify_job_priority", defaultVerifyJobPriority);
        return this;
    }

    public PutDataPolicySpectraS3Request withEndToEndCrcRequired(boolean endToEndCrcRequired) {
        this.endToEndCrcRequired = endToEndCrcRequired;
        this.updateQueryParam("end_to_end_crc_required", endToEndCrcRequired);
        return this;
    }

    public PutDataPolicySpectraS3Request withRebuildPriority(Priority rebuildPriority) {
        this.rebuildPriority = rebuildPriority;
        this.updateQueryParam("rebuild_priority", rebuildPriority);
        return this;
    }

    public PutDataPolicySpectraS3Request withVersioning(VersioningLevel versioning) {
        this.versioning = versioning;
        this.updateQueryParam("versioning", versioning);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/data_policy";
    }

    public String getName() {
        return this.name;
    }

    public boolean getAlwaysForcePutJobCreation() {
        return this.alwaysForcePutJobCreation;
    }

    public boolean getAlwaysMinimizeSpanningAcrossMedia() {
        return this.alwaysMinimizeSpanningAcrossMedia;
    }

    public boolean getBlobbingEnabled() {
        return this.blobbingEnabled;
    }

    @Override
    public ChecksumType.Type getChecksumType() {
        return this.checksumType;
    }

    public Long getDefaultBlobSize() {
        return this.defaultBlobSize;
    }

    public Priority getDefaultGetJobPriority() {
        return this.defaultGetJobPriority;
    }

    public Priority getDefaultPutJobPriority() {
        return this.defaultPutJobPriority;
    }

    public boolean getDefaultVerifyAfterWrite() {
        return this.defaultVerifyAfterWrite;
    }

    public Priority getDefaultVerifyJobPriority() {
        return this.defaultVerifyJobPriority;
    }

    public boolean getEndToEndCrcRequired() {
        return this.endToEndCrcRequired;
    }

    public Priority getRebuildPriority() {
        return this.rebuildPriority;
    }

    public VersioningLevel getVersioning() {
        return this.versioning;
    }
}

