/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.Priority;
import com.spectralogic.ds3client.models.TapeState;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.Date;
import java.util.UUID;

public class GetTapesSpectraS3Request
extends AbstractPaginationRequest {
    private boolean assignedToStorageDomain;
    private Long availableRawCapacity;
    private String barCode;
    private String bucketId;
    private String ejectLabel;
    private String ejectLocation;
    private boolean fullOfData;
    private boolean lastPage;
    private Date lastVerified;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private Date partiallyVerifiedEndOfTape;
    private String partitionId;
    private TapeState previousState;
    private String serialNumber;
    private String sortBy;
    private TapeState state;
    private String storageDomainId;
    private String type;
    private Priority verifyPending;
    private boolean writeProtected;

    public GetTapesSpectraS3Request withAssignedToStorageDomain(boolean assignedToStorageDomain) {
        this.assignedToStorageDomain = assignedToStorageDomain;
        this.updateQueryParam("assigned_to_storage_domain", assignedToStorageDomain);
        return this;
    }

    public GetTapesSpectraS3Request withAvailableRawCapacity(Long availableRawCapacity) {
        this.availableRawCapacity = availableRawCapacity;
        this.updateQueryParam("available_raw_capacity", availableRawCapacity);
        return this;
    }

    public GetTapesSpectraS3Request withBarCode(String barCode) {
        this.barCode = barCode;
        this.updateQueryParam("bar_code", barCode);
        return this;
    }

    public GetTapesSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetTapesSpectraS3Request withEjectLabel(String ejectLabel) {
        this.ejectLabel = ejectLabel;
        this.updateQueryParam("eject_label", ejectLabel);
        return this;
    }

    public GetTapesSpectraS3Request withEjectLocation(String ejectLocation) {
        this.ejectLocation = ejectLocation;
        this.updateQueryParam("eject_location", ejectLocation);
        return this;
    }

    public GetTapesSpectraS3Request withFullOfData(boolean fullOfData) {
        this.fullOfData = fullOfData;
        this.updateQueryParam("full_of_data", fullOfData);
        return this;
    }

    public GetTapesSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetTapesSpectraS3Request withLastVerified(Date lastVerified) {
        this.lastVerified = lastVerified;
        this.updateQueryParam("last_verified", lastVerified);
        return this;
    }

    public GetTapesSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetTapesSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetTapesSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapesSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapesSpectraS3Request withPartiallyVerifiedEndOfTape(Date partiallyVerifiedEndOfTape) {
        this.partiallyVerifiedEndOfTape = partiallyVerifiedEndOfTape;
        this.updateQueryParam("partially_verified_end_of_tape", partiallyVerifiedEndOfTape);
        return this;
    }

    public GetTapesSpectraS3Request withPartitionId(UUID partitionId) {
        this.partitionId = partitionId.toString();
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetTapesSpectraS3Request withPartitionId(String partitionId) {
        this.partitionId = partitionId;
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetTapesSpectraS3Request withPreviousState(TapeState previousState) {
        this.previousState = previousState;
        this.updateQueryParam("previous_state", previousState);
        return this;
    }

    public GetTapesSpectraS3Request withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        this.updateQueryParam("serial_number", serialNumber);
        return this;
    }

    public GetTapesSpectraS3Request withSortBy(String sortBy) {
        this.sortBy = sortBy;
        this.updateQueryParam("sort_by", sortBy);
        return this;
    }

    public GetTapesSpectraS3Request withState(TapeState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public GetTapesSpectraS3Request withStorageDomainId(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetTapesSpectraS3Request withStorageDomainId(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.updateQueryParam("storage_domain_id", storageDomainId);
        return this;
    }

    public GetTapesSpectraS3Request withType(String type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    public GetTapesSpectraS3Request withVerifyPending(Priority verifyPending) {
        this.verifyPending = verifyPending;
        this.updateQueryParam("verify_pending", verifyPending);
        return this;
    }

    public GetTapesSpectraS3Request withWriteProtected(boolean writeProtected) {
        this.writeProtected = writeProtected;
        this.updateQueryParam("write_protected", writeProtected);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape";
    }

    public boolean getAssignedToStorageDomain() {
        return this.assignedToStorageDomain;
    }

    public Long getAvailableRawCapacity() {
        return this.availableRawCapacity;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getEjectLabel() {
        return this.ejectLabel;
    }

    public String getEjectLocation() {
        return this.ejectLocation;
    }

    public boolean getFullOfData() {
        return this.fullOfData;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public Date getLastVerified() {
        return this.lastVerified;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public Date getPartiallyVerifiedEndOfTape() {
        return this.partiallyVerifiedEndOfTape;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public TapeState getPreviousState() {
        return this.previousState;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    public TapeState getState() {
        return this.state;
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getType() {
        return this.type;
    }

    public Priority getVerifyPending() {
        return this.verifyPending;
    }

    public boolean getWriteProtected() {
        return this.writeProtected;
    }
}

