/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.TapeDriveState;
import com.spectralogic.ds3client.models.TapeDriveType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetTapeDrivesSpectraS3Request
extends AbstractPaginationRequest {
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private String partitionId;
    private String serialNumber;
    private TapeDriveState state;
    private TapeDriveType type;

    public GetTapeDrivesSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPartitionId(UUID partitionId) {
        this.partitionId = partitionId.toString();
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withPartitionId(String partitionId) {
        this.partitionId = partitionId;
        this.updateQueryParam("partition_id", partitionId);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
        this.updateQueryParam("serial_number", serialNumber);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withState(TapeDriveState state) {
        this.state = state;
        this.updateQueryParam("state", state);
        return this;
    }

    public GetTapeDrivesSpectraS3Request withType(TapeDriveType type) {
        this.type = type;
        this.updateQueryParam("type", type);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape_drive";
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public String getPartitionId() {
        return this.partitionId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public TapeDriveState getState() {
        return this.state;
    }

    public TapeDriveType getType() {
        return this.type;
    }
}

