/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class EjectStorageDomainSpectraS3Request
extends AbstractRequest {
    private final String storageDomainId;
    private String bucketId;
    private String ejectLabel;
    private String ejectLocation;

    public EjectStorageDomainSpectraS3Request(UUID storageDomainId) {
        this.storageDomainId = storageDomainId.toString();
        this.getQueryParams().put("operation", "eject");
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public EjectStorageDomainSpectraS3Request(String storageDomainId) {
        this.storageDomainId = storageDomainId;
        this.getQueryParams().put("operation", "eject");
        this.updateQueryParam("storage_domain_id", storageDomainId);
    }

    public EjectStorageDomainSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public EjectStorageDomainSpectraS3Request withEjectLabel(String ejectLabel) {
        this.ejectLabel = ejectLabel;
        this.updateQueryParam("eject_label", ejectLabel);
        return this;
    }

    public EjectStorageDomainSpectraS3Request withEjectLocation(String ejectLocation) {
        this.ejectLocation = ejectLocation;
        this.updateQueryParam("eject_location", ejectLocation);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.PUT;
    }

    @Override
    public String getPath() {
        return "/_rest_/tape";
    }

    public String getStorageDomainId() {
        return this.storageDomainId;
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getEjectLabel() {
        return this.ejectLabel;
    }

    public String getEjectLocation() {
        return this.ejectLocation;
    }
}

