/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.spectralogic.ds3client.models.ChecksumType;
import com.spectralogic.ds3client.models.Error;
import com.spectralogic.ds3client.networking.FailedRequestException;
import com.spectralogic.ds3client.networking.FailedRequestUsingMgmtPortException;
import com.spectralogic.ds3client.networking.Headers;
import com.spectralogic.ds3client.networking.WebResponse;
import com.spectralogic.ds3client.serializer.XmlOutput;
import com.spectralogic.ds3client.utils.Guard;
import com.spectralogic.ds3client.utils.ResponseUtils;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResponseParserUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseParserUtils.class);
    public static final String UTF8 = "UTF-8";

    private ResponseParserUtils() {
    }

    public static boolean validateStatusCode(int statusCode, int ... expectedStatuses) {
        Preconditions.checkElementIndex((int)0, (int)1);
        ImmutableSet<Integer> expectedSet = ResponseParserUtils.createExpectedSet(expectedStatuses);
        return expectedSet.contains((Object)statusCode);
    }

    public static ChecksumType.Type determineChecksumType(Headers headers) {
        for (ChecksumType.Type type : ChecksumType.Type.values()) {
            if (ResponseParserUtils.getFirstHeaderValue(headers, "content-" + type.toString().replace("_", "").toLowerCase()) == null) continue;
            return type;
        }
        LOG.debug("Did not find a content checksum header");
        return null;
    }

    protected static String getRequestId(Headers headers) {
        String requestId = ResponseParserUtils.getFirstHeaderValue(headers, "x-amz-request-id");
        if (Guard.isStringNullOrEmpty((String)requestId)) {
            LOG.error("Response headers does not contain x-amz-request-id");
            return null;
        }
        return requestId;
    }

    public static String getFirstHeaderValue(Headers headers, String key) {
        List valueList = headers.get(key);
        if (Guard.isNullOrEmpty((Collection)valueList)) {
            return null;
        }
        return (String)valueList.get(0);
    }

    public static long getSizeFromHeaders(Headers headers) {
        if (headers == null) {
            LOG.debug("Could not get the headers to determine the content-length");
            return -1L;
        }
        List contentLength = headers.get("Content-Length");
        if (Guard.isNullOrEmpty((Collection)contentLength) || contentLength.get(0) == null) {
            LOG.debug("Could not find the content-length header to determine the size of the request");
            return -1L;
        }
        return Long.parseLong((String)contentLength.get(0));
    }

    public static boolean checkForManagementPortException(int statusCode, Headers headers) {
        return statusCode == 404 && ResponseParserUtils.getFirstHeaderValue(headers, "Spectra-Data-Path-Request-Made-On-Management-Path") != null;
    }

    public static Error parseErrorResponse(String responseString) {
        if (Strings.isNullOrEmpty((String)responseString)) {
            return null;
        }
        try {
            return XmlOutput.fromXml(responseString, Error.class);
        }
        catch (IOException e) {
            LOG.error("Failed to parse error response: {}", (Throwable)e);
            return null;
        }
    }

    public static ImmutableSet<Integer> createExpectedSet(int[] expectedStatuses) {
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (int status : expectedStatuses) {
            setBuilder.add((Object)status);
        }
        return setBuilder.build();
    }

    public static FailedRequestException createFailedRequest(WebResponse response, int[] expectedStatusCodes) throws IOException {
        if (ResponseParserUtils.checkForManagementPortException(response.getStatusCode(), response.getHeaders())) {
            return new FailedRequestUsingMgmtPortException(ResponseUtils.toImmutableIntList(expectedStatusCodes), ResponseParserUtils.getRequestId(response.getHeaders()));
        }
        String responseString = ResponseParserUtils.readResponseString(response);
        return new FailedRequestException(ResponseUtils.toImmutableIntList(expectedStatusCodes), response.getStatusCode(), ResponseParserUtils.parseErrorResponse(responseString), responseString, ResponseParserUtils.getRequestId(response.getHeaders()));
    }

    /*
     * Exception decompiling
     */
    private static String readResponseString(WebResponse response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

