/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;

public class GetBucketRequest
extends AbstractRequest {
    private final String bucketName;
    private String delimiter;
    private String marker;
    private int maxKeys;
    private String prefix;

    public GetBucketRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public GetBucketRequest withDelimiter(String delimiter) {
        this.delimiter = delimiter;
        this.updateQueryParam("delimiter", delimiter);
        return this;
    }

    public GetBucketRequest withMarker(String marker) {
        this.marker = marker;
        this.updateQueryParam("marker", marker);
        return this;
    }

    public GetBucketRequest withMaxKeys(int maxKeys) {
        this.maxKeys = maxKeys;
        this.updateQueryParam("max_keys", maxKeys);
        return this;
    }

    public GetBucketRequest withPrefix(String prefix) {
        this.prefix = prefix;
        this.updateQueryParam("prefix", prefix);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String getMarker() {
        return this.marker;
    }

    public int getMaxKeys() {
        return this.maxKeys;
    }

    public String getPrefix() {
        return this.prefix;
    }
}

