/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.AbstractExceptionMappingService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionRefusedException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.exception.QuotaException;
import ch.cyberduck.core.exception.RetriableAccessDeniedException;
import com.dropbox.core.DbxException;
import com.dropbox.core.InvalidAccessTokenException;
import com.dropbox.core.RetryException;
import com.dropbox.core.ServerException;
import com.dropbox.core.v2.files.CreateFolderErrorException;
import com.dropbox.core.v2.files.DeleteErrorException;
import com.dropbox.core.v2.files.DownloadErrorException;
import com.dropbox.core.v2.files.GetMetadataError;
import com.dropbox.core.v2.files.GetMetadataErrorException;
import com.dropbox.core.v2.files.GetTemporaryLinkErrorException;
import com.dropbox.core.v2.files.ListFolderContinueErrorException;
import com.dropbox.core.v2.files.ListFolderErrorException;
import com.dropbox.core.v2.files.LookupError;
import com.dropbox.core.v2.files.SearchErrorException;
import com.dropbox.core.v2.files.UploadErrorException;
import com.dropbox.core.v2.files.UploadSessionFinishErrorException;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import org.apache.commons.lang3.StringUtils;

public class DropboxExceptionMappingService
extends AbstractExceptionMappingService<DbxException> {
    public BackgroundException map(DbxException failure) {
        LookupError lookup;
        GetMetadataError error;
        StringBuilder buffer = new StringBuilder();
        this.parse(buffer, failure.getMessage());
        if (failure instanceof InvalidAccessTokenException) {
            return new LoginFailureException(buffer.toString(), (Throwable)failure);
        }
        if (failure instanceof RetryException) {
            Duration delay = Duration.ofMillis(((RetryException)failure).getBackoffMillis());
            return new RetriableAccessDeniedException(buffer.toString(), delay);
        }
        if (failure instanceof ServerException) {
            return new ConnectionRefusedException(buffer.toString(), (Throwable)failure);
        }
        if (failure instanceof GetMetadataErrorException) {
            error = ((GetMetadataErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof DeleteErrorException) {
            error = ((DeleteErrorException)failure).errorValue;
            lookup = error.getPathLookupValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof ListFolderErrorException) {
            error = ((ListFolderErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof CreateFolderErrorException) {
            error = ((CreateFolderErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case DISALLOWED_NAME: 
                case NO_WRITE_PERMISSION: 
                case CONFLICT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
                case INSUFFICIENT_SPACE: {
                    return new QuotaException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof SearchErrorException) {
            error = ((SearchErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof DownloadErrorException) {
            error = ((DownloadErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof UploadErrorException) {
            error = ((UploadErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.getReason().tag()) {
                case DISALLOWED_NAME: 
                case NO_WRITE_PERMISSION: 
                case CONFLICT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
                case INSUFFICIENT_SPACE: {
                    return new QuotaException(buffer.toString(), (Throwable)failure);
                }
                case OTHER: 
                case MALFORMED_PATH: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof UploadSessionFinishErrorException) {
            error = ((UploadSessionFinishErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case DISALLOWED_NAME: 
                case NO_WRITE_PERMISSION: 
                case CONFLICT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
                case INSUFFICIENT_SPACE: {
                    return new QuotaException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof GetTemporaryLinkErrorException) {
            error = ((GetTemporaryLinkErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        if (failure instanceof ListFolderContinueErrorException) {
            error = ((ListFolderContinueErrorException)failure).errorValue;
            lookup = error.getPathValue();
            this.parse(buffer, lookup.toString());
            switch (lookup.tag()) {
                case NOT_FOUND: 
                case NOT_FILE: 
                case NOT_FOLDER: {
                    return new NotfoundException(buffer.toString(), (Throwable)failure);
                }
                case MALFORMED_PATH: 
                case RESTRICTED_CONTENT: {
                    return new AccessDeniedException(buffer.toString(), (Throwable)failure);
                }
                case OTHER: {
                    return new InteroperabilityException(buffer.toString(), (Throwable)failure);
                }
            }
        }
        return new InteroperabilityException(buffer.toString(), (Throwable)failure);
    }

    private void parse(StringBuilder buffer, String message) {
        JsonParser parser = new JsonParser();
        try {
            JsonElement element = parser.parse((Reader)new StringReader(message));
            if (element.isJsonObject()) {
                JsonObject json = element.getAsJsonObject();
                JsonObject error = json.getAsJsonObject("error");
                if (null == error) {
                    this.append(buffer, message);
                } else {
                    JsonPrimitive tag = error.getAsJsonPrimitive(".tag");
                    if (null == tag) {
                        this.append(buffer, message);
                    } else {
                        this.append(buffer, StringUtils.replace((String)tag.getAsString(), (String)"_", (String)" "));
                    }
                }
            }
            if (element.isJsonPrimitive()) {
                this.append(buffer, element.getAsString());
            }
        }
        catch (JsonParseException jsonParseException) {
            // empty catch block
        }
    }
}

