/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.util.regex.Pattern;
import sun.nio.fs.BsdFileSystem;
import sun.nio.fs.MacOSXNativeDispatcher;
import sun.nio.fs.UnixFileSystemProvider;

class MacOSXFileSystem
extends BsdFileSystem {
    MacOSXFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
    }

    @Override
    Pattern compilePathMatchPattern(String string) {
        return Pattern.compile(string, 128);
    }

    @Override
    char[] normalizeNativePath(char[] cArray) {
        for (char c : cArray) {
            if (c <= '\u0080') continue;
            return MacOSXNativeDispatcher.normalizepath(cArray, 0);
        }
        return cArray;
    }

    @Override
    String normalizeJavaPath(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) <= '\u0080') continue;
            return new String(MacOSXNativeDispatcher.normalizepath(string.toCharArray(), 2));
        }
        return string;
    }
}

