/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.binding.Proxy;
import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.DefaultHostPasswordStore;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.library.Native;
import ch.cyberduck.core.ssl.CertificateStoreX509KeyManager;
import ch.cyberduck.core.ssl.DEREncoder;
import ch.cyberduck.core.ssl.KeychainX509KeyManager;
import ch.cyberduck.core.threading.DefaultMainAction;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.Principal;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.log4j.Logger;

public final class Keychain
extends DefaultHostPasswordStore
implements PasswordStore,
CertificateStore {
    private static final Logger log = Logger.getLogger(Keychain.class);
    private final Proxy proxy;

    public Keychain() {
        this(new Proxy());
    }

    public Keychain(Proxy proxy) {
        this.proxy = proxy;
    }

    public synchronized native String getInternetPasswordFromKeychain(String var1, int var2, String var3, String var4);

    public synchronized native String getPasswordFromKeychain(String var1, String var2);

    public synchronized native void addPasswordToKeychain(String var1, String var2, String var3);

    public synchronized native void addInternetPasswordToKeychain(String var1, int var2, String var3, String var4, String var5);

    public String getPassword(Scheme scheme, int port, String hostname, String user) {
        return this.getInternetPasswordFromKeychain(scheme.name(), port, hostname, user);
    }

    public void addPassword(Scheme scheme, int port, String hostname, String user, String password) {
        this.addInternetPasswordToKeychain(scheme.name(), port, hostname, user, password);
    }

    public String getPassword(String serviceName, String accountName) {
        return this.getPasswordFromKeychain(serviceName, accountName);
    }

    public void addPassword(String serviceName, String accountName, String password) {
        this.addPasswordToKeychain(serviceName, accountName, password);
    }

    public boolean isTrusted(final String hostname, List<X509Certificate> certificates) throws CertificateException {
        if (certificates.isEmpty()) {
            return false;
        }
        final Object[] encoded = new DEREncoder().encode(certificates);
        final AtomicBoolean trusted = new AtomicBoolean(false);
        DefaultMainAction action = new DefaultMainAction(){

            public void run() {
                trusted.set(Keychain.this.isTrustedNative(hostname, encoded));
            }
        };
        this.proxy.invoke((Runnable)action, action.lock(), true);
        return trusted.get();
    }

    private synchronized native boolean isTrustedNative(String var1, Object[] var2);

    public boolean display(List<X509Certificate> certificates) throws CertificateException {
        if (certificates.isEmpty()) {
            return false;
        }
        final Object[] encoded = new DEREncoder().encode(certificates);
        final AtomicBoolean accepted = new AtomicBoolean(false);
        DefaultMainAction action = new DefaultMainAction(){

            public void run() {
                accepted.set(Keychain.this.displayCertificatesNative(encoded));
            }
        };
        this.proxy.invoke((Runnable)action, action.lock(), true);
        return accepted.get();
    }

    private native boolean displayCertificatesNative(Object[] var1);

    public X509Certificate choose(String[] keyTypes, Principal[] issuers, final Host bookmark, final String prompt) throws ConnectionCanceledException {
        CertificateStoreX509KeyManager manager;
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        try {
            manager = new KeychainX509KeyManager(bookmark).init();
        }
        catch (IOException e) {
            throw new ConnectionCanceledException((Throwable)e);
        }
        String[] aliases = manager.getClientAliases(keyTypes, issuers);
        if (null == aliases) {
            throw new ConnectionCanceledException(String.format("No certificate matching issuer %s found", Arrays.toString(issuers)));
        }
        for (String alias : aliases) {
            certificates.add(manager.getCertificate(alias, keyTypes, issuers));
        }
        try {
            final Object[] encoded = new DEREncoder().encode(certificates);
            final AtomicReference select = new AtomicReference();
            DefaultMainAction action = new DefaultMainAction(){

                public void run() {
                    select.set(Keychain.this.chooseCertificateNative(encoded, bookmark.getHostname(), prompt));
                }
            };
            this.proxy.invoke((Runnable)action, action.lock(), true);
            if (null == select.get()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"No certificate selected");
                }
                throw new ConnectionCanceledException();
            }
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            X509Certificate selected = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream((byte[])select.get()));
            if (log.isDebugEnabled()) {
                log.info((Object)String.format("Selected certificate %s", selected));
            }
            return selected;
        }
        catch (CertificateException e) {
            throw new ConnectionCanceledException((Throwable)e);
        }
    }

    private native byte[] chooseCertificateNative(Object[] var1, String var2, String var3);

    static {
        Native.load((String)"core");
    }
}

