/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ftp;

import ch.cyberduck.core.ftp.parser.CompositeFileEntryParser;
import ch.cyberduck.core.ftp.parser.EPLFFTPEntryParser;
import ch.cyberduck.core.ftp.parser.LaxUnixFTPEntryParser;
import ch.cyberduck.core.ftp.parser.RumpusFTPEntryParser;
import ch.cyberduck.core.ftp.parser.TrellixFTPEntryParser;
import ch.cyberduck.core.ftp.parser.UnitreeFTPEntryParser;
import java.util.Arrays;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFileEntryParserImpl;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.apache.commons.net.ftp.parser.MVSFTPEntryParser;
import org.apache.commons.net.ftp.parser.NTFTPEntryParser;
import org.apache.commons.net.ftp.parser.NetwareFTPEntryParser;
import org.apache.commons.net.ftp.parser.OS2FTPEntryParser;
import org.apache.commons.net.ftp.parser.OS400FTPEntryParser;
import org.apache.commons.net.ftp.parser.ParserInitializationException;

public class FTPParserFactory
implements FTPFileEntryParserFactory {
    public CompositeFileEntryParser createFileEntryParser(FTPClientConfig config) throws ParserInitializationException {
        return this.createFileEntryParser(config.getServerSystemKey(), TimeZone.getTimeZone(config.getServerTimeZoneId()));
    }

    public CompositeFileEntryParser createFileEntryParser(String system) throws ParserInitializationException {
        return this.createFileEntryParser(system, TimeZone.getDefault());
    }

    public CompositeFileEntryParser createFileEntryParser(String system, TimeZone timezone) throws ParserInitializationException {
        if (null != system) {
            String ukey = system.toUpperCase(Locale.ROOT);
            if (ukey.contains("UNIX")) {
                return this.createUnixFTPEntryParser(timezone);
            }
            if (ukey.contains("VMS")) {
                throw new ParserInitializationException(String.format("\"%s\" is not currently a supported system.", system));
            }
            if (ukey.contains("NETWARE")) {
                return this.createNetwareFTPEntryParser(timezone);
            }
            if (ukey.contains("WINDOWS")) {
                return this.createNTFTPEntryParser(timezone);
            }
            if (ukey.contains("OS/2")) {
                return this.createOS2FTPEntryParser(timezone);
            }
            if (ukey.contains("OS/400")) {
                return this.createOS400FTPEntryParser(timezone);
            }
            if (ukey.contains("MVS")) {
                return this.createUnixFTPEntryParser(timezone);
            }
        }
        return this.createUnixFTPEntryParser(timezone);
    }

    private CompositeFileEntryParser createUnixFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new FTPFileEntryParserImpl[]{new LaxUnixFTPEntryParser(){

            @Override
            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, new EPLFFTPEntryParser(), new RumpusFTPEntryParser(){

            @Override
            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, new TrellixFTPEntryParser(){

            @Override
            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, new UnitreeFTPEntryParser(){

            @Override
            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }}));
    }

    private CompositeFileEntryParser createNetwareFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new FTPFileEntryParserImpl[]{new NetwareFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)}));
    }

    private CompositeFileEntryParser createNTFTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new FTPFileEntryParserImpl[]{new NTFTPEntryParser(){

            public FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)}));
    }

    private CompositeFileEntryParser createOS2FTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new OS2FTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }));
    }

    private CompositeFileEntryParser createOS400FTPEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new FTPFileEntryParserImpl[]{new OS400FTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }, this.createUnixFTPEntryParser(timezone)}));
    }

    private CompositeFileEntryParser createMVSEntryParser(final TimeZone timezone) {
        return new CompositeFileEntryParser(Arrays.asList(new MVSFTPEntryParser(){

            protected FTPClientConfig getDefaultConfiguration() {
                FTPClientConfig config = super.getDefaultConfiguration();
                config.setServerTimeZoneId(timezone.getID());
                return config;
            }
        }));
    }
}

