/**
* DO NOT EDIT THIS FILE.
* See the following change record for more information,
* https://www.drupal.org/node/2815083
* @preserve
**/

(function ($, Drupal, drupalSettings) {
  Drupal.AjaxCommands.prototype.viewsHighlight = function (ajax, response, status) {
    $('.hilited').removeClass('hilited');
    $(response.selector).addClass('hilited');
  };

  Drupal.AjaxCommands.prototype.viewsSetForm = function (ajax, response, status) {
    var $form = $('.js-views-ui-dialog form');

    var $submit_buttons = $form.find('input[type=submit].js-form-submit, button.js-form-submit').once('views-ajax-submit');
    $submit_buttons.on('click mousedown', function () {
      this.form.clk = this;
    });
    $form.once('views-ajax-submit').each(function () {
      var $form = $(this);
      var element_settings = {
        url: response.url,
        event: 'submit',
        base: $form.attr('id'),
        element: this
      };
      var ajaxForm = Drupal.ajax(element_settings);
      ajaxForm.$form = $form;
    });
  };

  Drupal.AjaxCommands.prototype.viewsShowButtons = function (ajax, response, status) {
    $('div.views-edit-view div.form-actions').removeClass('js-hide');
    if (response.changed) {
      $('div.views-edit-view div.view-changed.messages').removeClass('js-hide');
    }
  };

  Drupal.AjaxCommands.prototype.viewsTriggerPreview = function (ajax, response, status) {
    if ($('input#edit-displays-live-preview').is(':checked')) {
      $('#preview-submit').trigger('click');
    }
  };

  Drupal.AjaxCommands.prototype.viewsReplaceTitle = function (ajax, response, status) {
    var doc = document;

    var oldTitle = doc.title;

    var escapedSiteName = response.siteName.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, '\\$&');
    var re = new RegExp('.+ (.) ' + escapedSiteName);
    doc.title = oldTitle.replace(re, response.title + ' $1 ' + response.siteName);

    $('h1.page-title').text(response.title);
  };

  Drupal.theme.tableDragChangedWarning = function () {
    return [];
  };

  Drupal.behaviors.livePreview = {
    attach: function attach(context) {
      $('input#edit-displays-live-preview', context).once('views-ajax').on('click', function () {
        if ($(this).is(':checked')) {
          $('#preview-submit').trigger('click');
        }
      });
    }
  };

  Drupal.behaviors.syncPreviewDisplay = {
    attach: function attach(context) {
      $('#views-tabset a').once('views-ajax').on('click', function () {
        var href = $(this).attr('href');

        var display_id = href.substr(11);

        $('#views-live-preview #preview-display-id').val(display_id);
      });
    }
  };

  Drupal.behaviors.viewsAjax = {
    collapseReplaced: false,
    attach: function attach(context, settings) {
      var base_element_settings = {
        event: 'click',
        progress: { type: 'fullscreen' }
      };

      $('a.views-ajax-link', context).once('views-ajax').each(function () {
        var element_settings = base_element_settings;
        element_settings.base = $(this).attr('id');
        element_settings.element = this;

        if ($(this).attr('href')) {
          element_settings.url = $(this).attr('href');
        }
        Drupal.ajax(element_settings);
      });

      $('div#views-live-preview a').once('views-ajax').each(function () {
        if (!$(this).attr('href')) {
          return true;
        }

        var element_settings = base_element_settings;

        element_settings.url = $(this).attr('href');
        if (Drupal.Views.getPath(element_settings.url).substring(0, 21) !== 'admin/structure/views') {
          return true;
        }

        element_settings.wrapper = 'views-preview-wrapper';
        element_settings.method = 'replaceWith';
        element_settings.base = $(this).attr('id');
        element_settings.element = this;
        Drupal.ajax(element_settings);
      });

      $('div#views-live-preview input[type=submit]').once('views-ajax').each(function (event) {
        $(this).on('click', function () {
          this.form.clk = this;
          return true;
        });
        var element_settings = base_element_settings;

        element_settings.url = $(this.form).attr('action');
        if (Drupal.Views.getPath(element_settings.url).substring(0, 21) !== 'admin/structure/views') {
          return true;
        }

        element_settings.wrapper = 'views-preview-wrapper';
        element_settings.method = 'replaceWith';
        element_settings.event = 'click';
        element_settings.base = $(this).attr('id');
        element_settings.element = this;

        Drupal.ajax(element_settings);
      });
    }
  };
})(jQuery, Drupal, drupalSettings);