/*
 * Audio / Video rendering functions.
 *
 * Copyright (c) 2011 W. Michael Petullo <new@flyn.org>
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _AV_RENDER_H
#define _AV_RENDER_H

#include <libdmapsharing/dmap.h>

G_BEGIN_DECLS

#define TYPE_AV_RENDER          (av_render_get_type ())
#define AV_RENDER(o)            (G_TYPE_CHECK_INSTANCE_CAST ((o), \
                                      TYPE_AV_RENDER, AvRender))
#define AV_RENDER_CLASS(k)      (G_TYPE_CHECK_CLASS_CAST ((k), \
                                      TYPE_AV_RENDER, AvRenderClass))
#define IS_AV_RENDER(o)         (G_TYPE_CHECK_INSTANCE_TYPE ((o), \
                                      TYPE_AV_RENDER))
#define IS_AV_RENDER_CLASS(k)   (G_TYPE_CHECK_INSTANCE_TYPE ((k), \
                                      TYPE_AV_RENDER))
#define AV_RENDER_GET_CLASS(k)  (G_TYPE_INSTANCE_GET_CLASS ((k), \
                                      TYPE_AV_RENDER, AvRenderClass))

typedef struct _AvRender AvRender;
typedef struct _AvRenderClass AvRenderClass;

struct _AvRender {
	GObject parent;
};

struct _AvRenderClass {
        GObjectClass parent;

	DmapAvRecord *(*now_playing_record) (DmapControlPlayer * player);
	gchar *(*now_playing_artwork) (DmapControlPlayer * player,
					      guint width, guint height);
	void (*play_pause) (DmapControlPlayer * player);
	void (*pause) (DmapControlPlayer * player);
	void (*next_item) (DmapControlPlayer * player);
	void (*prev_item) (DmapControlPlayer * player);
	void (*cue_clear) (DmapControlPlayer * player);
	void (*cue_play) (DmapControlPlayer * player, GList * records, guint index);
	GOptionGroup *(*get_option_group) (AvRender *render);
};

GType       av_render_get_type      (void);

DmapAvRecord *av_render_now_playing_record (DmapControlPlayer * player);
gchar *av_render_now_playing_artwork (DmapControlPlayer * player,
					       guint width, guint height);
void av_render_play_pause (DmapControlPlayer * player);
void av_render_pause (DmapControlPlayer * player);
void av_render_next_item (DmapControlPlayer * player);
void av_render_prev_item (DmapControlPlayer * player);
void av_render_cue_clear (DmapControlPlayer * player);
void av_render_cue_play (DmapControlPlayer * player, GList * records, guint index);
GOptionGroup *av_render_get_option_group (AvRender *render);

#endif /* __AV_RENDER */

G_END_DECLS
