Changes in DMAKE
================

Version 4.13.0
--------------

More updates to support macOS 10.15 (and above)
Pull in various fixes

Version 4.12.4
--------------

macOS upgrades for 10.15 (and higher)

Version 4.12.3
--------------

The `dbug` library has been restored to the distribution.

Version 4.12.2
--------------

Includes minimal changes to add support for OS/2, DragonFly and NetBSD.
Also includes some small enhancements taken from LibreOffice.

The `dbug` library has been removed from the distribution,
it's still available in SVN and a more up to date version
at sourceforge.

News information for the dmake version that was hosted on the OpenOffice.org
cvs. #i<number># denote issues tracked by the OpenOffice.org issue tracking
system, see <http://qa.openoffice.org/issue_handling/project_issues.html>.

Version 4.12
------------

Volker Quetschke (vq@openoffice.org)
#i83540# Add parallel building mode, see the MULTI PROCESSING section in
the dmake man page, for native W32 dmake (MSVC 6, and newer and MinGW)
versions.

Version 4.11
------------

Yuri Dario (ydario@openoffice.org)
#i81855, CWS os2port01# Port dmake to OS/2.

Volker Quetschke (vq@openoffice.org)
#i81252# Add a new control macro SHELLCMDQUOTE that can be used to add
additional characters before and after the command string if the recipe is
executed using a shell. This macro is used to avoid problems with quoting
when using cmd.exe or command.com.

Volker Quetschke (vq@openoffice.org)
#i81296, i64572# Improve dependency handling of prerequisites.

Volker Quetschke (vq@openoffice.org)
#i80687, i66751# Allow the use of .PHONY for %-targets.

Volker Quetschke (vq@openoffice.org)
#i80010, i80009# Fix handling of quoted filenames for :1 :b :d :e :f
and :i macro expansions.

Volker Quetschke (vq@openoffice.org)
#i78776# Add a new function macro $(normpath[,para] data) and a new macro
extension to normalise the given data or macro content. The normalization
is done element-wise (whitespace separated) on the given data. Quotes can
be used to normalize filenames that contain whitespace characters.
On cygwin the result honors the setting of .WINPATH to determine the output
format. If the optional parameter para is given for the function macro its
expanded value is used to override the .WINPATH setting for the output.

Version 4.10 (skipped)
----------------------

This number was skipped to avoid confusion with Version 4.1, patch level 0
which identified itself as "Version 4.10, PL 0".

Version 4.9
-----------

Volker Quetschke (vq@openoffice.org)
#i74700#  Add a new special macro OOODMAKEMODE that is used to toggle
OOo build specific behavior. If OOODMAKEMODE is set (i.e. it begins with y)
a possible leading ./ of a path will no longer be removed during target
normalization.


Version 4.8
-----------

Volker Quetschke (vq@openoffice.org)
#i73499#  Add new .WINPATH attribute to generate Windows style paths (with
regular slashes) instead of the default cygwin style (POSIX) paths for
dmake's dynamic macros.

This attribute is specific for cygwin dmake executables and non-cygwin
environments ignore this attribute. This feature can be used to create DOS
style path parameters for native W32 programs from dynamic macros.

The windows style paths use regular slashes ('/') instead of the usual
windows backslash ('\') as directory separator to avoid quoting problems
(It still is a cygwin dmake feature!) and cygwin as well as native windows
programs should have no problems using this (c:/foo/bar) path
representation.

The affected macros are $@, $*, $>, $?, $<, $&, $^ and $(PWD), $(MAKEDIR)
and $(TMD).

Examples:
  Content of $(PWD) without .WINPATH (default):  /cygdrive/c/temp

  Content of $(PWD) with .WINPATH set:           c:/temp


Version 4.7
-----------

Volker Quetschke (vq@openoffice.org)
#i71422# Add @@ as a new recipe line property. This new property is a
stronger version of the already existing @ recipe property.  The recipe
line and the output (stdout and stderr) of the executed recipe are suppressed
and *NOT* shown on the terminal.
Note: Previously the second @ sign was ignored, that means that using this
new feature doesn't break backwards compatibility but the command output
is naturally not suppressed in older versions.

Volker Quetschke (vq@openoffice.org)
#i70210# Dmake now works correctly with empty dynamic prerequisites.

Volker Quetschke (vq@openoffice.org)
#i70168# Improve dmakes handling of literal $ characters in target and
prerequisite filenames. This was not working before and is working now
but the use of literal $ characters in filenames is still strongly
discouraged. See the man page for details.

Volker Quetschke (vq@openoffice.org)
#i69742# Normalize the pathnames of targets and prerequisites to the shortest
(or most natural, see below for the cygwin case) representation.
Now "./foo", "bar/../foo" and foo are recognized as the same file.

For cygwin this allows the use of target and prerequisite names with DOS
like pathnames with drive letters (with / and \ as possible path seperators)
and cygwin POSIX pathnames. As the internal format uses cygwin's natural
POSIX representation runtime macros will result in POSIX paths.

Version 4.6
-----------

Volker Quetschke (vq@openoffice.org)
#i67589# Implement the internal dmake commands noop and echo. These commands
were already existing for the native Windows version but only partially
documented.

Volker Quetschke (vq@openoffice.org)
#i67166# Issue a warning when a previously unset macro (i.e. assumed to be
empty) is used and later set to a different value.

Volker Quetschke (vq@openoffice.org)
#i66567# Issue a warning when .SUFFIXES is used. This special target had no
special meaning (anymore?) and was always (at least since version 4.2)
ignored.

Volker Quetschke (vq@openoffice.org)
#i67025# Fix a bug that was introduced in dmake 4.5 and led dmake to falsely
issue an error if a %-target was defined with the .SILENT attribute and dmake
was started with the -vr (included in -v) verbose flag.

Version 4.5
--------------

Volker Quetschke (vq@openoffice.org)
#i66385# Fix the handling of .<suffix> targets. Always treat these targets
as meta targets regardless of the AUGMAKE (-A) status. Previously this was
enabled when the AUGMAKE was *not* set to 'yes' or the -A switch was given.

#i66083# We now stop with an error if AUGMAKE meta targets and regular
targets are used in one rule definition. As the syntax of these target
definitions is slightly different this hints to an error in the makefile,
most probably a misspelled attribute or special target.

#i48087#, #i64869# The parsing of %-target definitions was fixed and
enhanced. Prior to dmake 4.5 only one %-target per target-definition worked
reliably, now this works well, but to help projects that still use older
versions a warning was added.

It's not very nice to issue a warning for something that works now but
didn't before. This was only done to aid development and will probably
be removed in future versions.

There was, and still is, that for a bug in dmake for %-targets with more
than one (not indirect) prerequisite only the first prerequisite is used.
This will be fixed in future versions but until this happens we issue a
warning that prerequisites are ignored.

#i65122# The :| rule operator was handled differently from what the man
page said. The man page was adapted to reflect reality. Changing dmakes
behavior to match the man page would have introduced a lot of compatibility
issues.

Version 4.4
-----------

2006/02/03 Volker Quetschke (vq@openoffice.org)
#i61170# Fix the TMD macro. Up to now the TMD macro appended a directory
separator if it ended in "..", but most of the time it was not set correctly
at all and/or without a trailing slash.
Note: If your application relies on TMD please check the dmake manual page
for its definition and fix your makefiles if needed.

2006/02/01 Volker Quetschke (vq@openoffice.org)
#i60948# Add -m option family to generate timing information for targets
and/or recipes.

2005/09/19 Volker Quetschke (vq@openoffice.org)
#i53148# Fix $(shell ...) macro picking up the output of earlier
recipe lines in parallel builds.
#i54766# Ensure that all previous recipe lines to a recipe
line containing a $(shell ...) macro have finished before executing
the macro in parallel builds.

2005/06/01 Volker Quetschke (vq@openoffice.org)
#i39248# Add a testsuite to test some dmake features (only for autotools
builds). Start the tests with "make check".

2005/04/21 Volker Quetschke (vq@openoffice.org)
#i47851# Increase the version number to 4.4-cvs and slightly rearrange the
output of "dmake -V".
Remove the hard-coded (in autotools builds) OS macro. It had the wrong value
to be usable with the startup/*.mk and is not mentioned in the man page.
Clean up configure.in and friends.

2005/04/20 Volker Quetschke (vq@openoffice.org)
#i43310# Fix percent (%) rules to recognize prerequisites that are defined
with the multiple target rule operator (::). 
This implicitly fixes the similar problem for .<suffix>.<suffix> targets.

2005/04/16 Volker Quetschke (vq@openoffice.org)
#i46987# Fix the documentation of the $(mktmp ...) function macro. This is
not necessarily a new feature as the macro works this way since dmake was
imported into the OpenOffice.org cvs but mentioning it here might help users
of dmake upgrading from very old versions.

Add the "map escape codes" $(...:m) macro expansion that allows to expand
escape codes in macros.  It can also be used to reproduce the former (pre
OpenOffice.org cvs) $(mktmp ...) behavior.

2005/04/10 Volker Quetschke (vq@openoffice.org)
#i43252# Introduce the macro ABSMAKECMD that's value for a native Windows
dmake executable (compiled with MS Visual C++ or MinGW) is the absolute
filename and NULL for other operating systems or dmake build with other
compilers.
If DMAKEROOT is not changed and only for native Windows dmake versions the
value of DMAKEROOT now defaults to "$(ABSMAKECMD:d)startup".
This allows to use the startup files from the startup directory from the
same location where the dmake.exe is located.

2005/04/08 Steve Hay (shay@openoffice.org)
#i43241# Fix build problems with VC++ (in non-OOo environment) and fix
the dmake makefiles so that dmake can rebuild itself (VC++ only).

2005/03/14 Volker Quetschke (vq@openoffice.org)
#i44959# Fix problems when a continued line is followed by an empty
or comment line.

2005/03/13 Volker Quetschke (vq@openoffice.org)
#i37053# Fix function macro problems with continued lines.

2004/11/23 Volker Quetschke (vq@openoffice.org)
#i37491# Predefine dmake macro containing one space (SPACECHAR).

2004/11/21 Volker Quetschke (vq@openoffice.org)
#i36027# Improve function macro parameter parsing.

Version 4.3
-----------

2004/10/07 Volker Quetschke (vq@openoffice.org)
#i34746# Fix timestamp of phony targets with prerequisites.

2004/07/11 Volker Quetschke (vq@openoffice.org)
#i31255# Add verbose recipe echoing option (-vr).

2004/07/06 Volker Quetschke (vq@openoffice.org)
#i30779# Fix to allow dmake to echo recipe lines when inference is used
to create files that are to be read by .INCLUDE.

2004/04/01 Michael Meeks (mmeeks@openoffice.org)
#i27319#, #i27981# Don't handle environment variables that begin with a
'!', they are used by Cygwin internally and confuse dmake.

2004/01/09 Dan Williams (fa@openoffice.org)
#i17992# Allows the nesting of expressions and a much more complex syntax
for dmake. It is now possible to nest expressions with () and any
combination of || and &&.
Example:
.IF (("$(OS)"=="MACOSX"&&"$(COM)"=="GCC")||"$(OS)"=="LINUX") && "$(GUIBASE)"=="unx"
...
.ENDIF

2003/10/19 Ken Foskey (waratah@openoffice.org)
#i20504# Correct processing of .LIBRARY targets.

2003/10/08 Chris Halls (haggai@openoffice.org)
#i7800# Fix tempnam security problem.

2003/03/08 Volker Quetschke (vq@openoffice.org)
#i10910# Use the build-in tempnam function for MS VC6.

2003/03/05 Volker Quetschke (vq@openoffice.org)
#i11861# Switch to newer autotools autoconf 2.5x and automake 1.5 and
add MinGW and MSVC to the configure buildable targets.

2002/10/11 Ken Foskey (waratah@openoffice.org)
Fix the "lost a child" problem. (Part II)

2002/10/04 Ken Foskey (waratah@openoffice.org)
Rework the configure process.

2002/04/10 Hans-Joachim Lankenau (hjs@openoffice.org)
Don't search INCLUDEDIRS if the filename to be included starts at fs-root.

2001/05/29 Patrick Luby (pluby@openoffice.org)
Added forceful exit to avoid infinite loop that sometimes occurs when
there is a fatal error. Lost a child problem. (Part I)

Version 4.2
-----------
(Note, the dmake -V output was not changed and still said
"Version 4.10, PL 0". This probably should have been 4.1)

2001/04/20 Martin Hollmichel (mh@openoffice.org)
First autoconfiscation of dmake.

2001/02/13 Hans-Joachim Lankenau (hjs@openoffice.org)
Fix for leaving tmpfiles when building group targets.

2000/09/22 Jens-Heiner Rechtien (hr@openoffice.org)
Initial import of dmake into OpenOffice.org cvs

before 2000/09/22 ?
Add smaller/greater arithmetic for .IF conditions.

1999/03/18 Hans-Joachim Lankenau (hjs@openoffice.org)
Implement boolean expression "or".
