/*
 * DisTractRun.js
 *     - utils for running the DisTract binaries
 *
 * Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)
 *
 * DisTract is freely distributable under the terms of a 3-Clause
 * BSD-style license. For details, see the DisTract web site:
 *   http://distract.wellquite.org/
 *
 */

function writeToTempFile (text, continuationFunc) {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        var file = Components.classes["@mozilla.org/file/directory_service;1"]
                             .getService(Components.interfaces.nsIProperties)
                             .get("TmpD", Components.interfaces.nsIFile);
        file.append("DisTractTemp.tmp");
        file.createUnique(Components.interfaces.nsIFile.NORMAL_FILE_TYPE, 0600);
        var foStream = Components.classes["@mozilla.org/network/file-output-stream;1"]
                                 .createInstance(Components.interfaces.nsIFileOutputStream);
        foStream.init(file, 0x02 | 0x08 | 0x20, 0664, 0); // write, create, truncate
        foStream.write(text, text.length);
        foStream.close();
        var result = continuationFunc(file);
        file.remove(false); // not recursive
        if (result !== undefined) {
            return result;
        }
        return true;
    } catch (e) {
        alert(e);
        return false;
    }
}

function runProcess (execFilePath, args) {
    try {
        netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
        // create an nsILocalFile for the executable
        var exeFile = Components.classes["@mozilla.org/file/local;1"]
                                .createInstance(Components.interfaces.nsILocalFile);
        exeFile.initWithPath(execFilePath);

        // create an nsIProcess
        var process = Components.classes["@mozilla.org/process/util;1"]
                                .createInstance(Components.interfaces.nsIProcess);
        process.init(exeFile);

        // Run the process.
        // If first param is true, calling thread will be blocked until
        // called process terminates.
        // Second and third params are used to pass command-line arguments
        // to the process.
        process.run(true, args, args.length);
        return true;
    } catch (e) {
        alert(e);
        return false;
    }
}

function runModifyBugFunc (basePath) {
    var func = function (tempFile) {
                   var args = [basePath, tempFile.path];
                   var exePath = basePath + "/bin/DisTractModifyBug";
                   runProcess(exePath, args);
                   rebuildBugList(basePath);
                   return true;
               }
    return func;
}

function runRebuildBugFunc (basePath) {
    var func = function (bugId, update) {
                   var args = [basePath, bugId, update];
                   var exePath = basePath + "/bin/DisTractUpdateFormatBug";
                   runProcess(exePath, args);
                   rebuildBugList(basePath);
                   return true;
               }
    return func;
}

function runRebuildAllFunc (basePath) {
    var func = function () {
                   var args = [basePath];
                   var exePath = basePath + "/bin/DisTractUpdateFormatAllBugs";
                   runProcess(exePath, args);
                   rebuildBugList(basePath);
                   return true;
               }
    return func;
}

function rebuildBugList (basePath) {
    var args = [basePath];
    var exePath = basePath + "/bin/DisTractSortBugs";
    runProcess(exePath, args);
    return true;
}

function runNewBugFunc (basePath) {
    var func = function (tempFile) {
                   var args = [basePath, tempFile.path];
                   var exePath = basePath + "/bin/DisTractNewBug";
                   runProcess(exePath, args);
                   var bugId = null;
                   var istream = Components.classes["@mozilla.org/network/file-input-stream;1"]
                                           .createInstance(Components.interfaces.nsIFileInputStream);
                   istream.init(tempFile, 0x01, 0400, 0);
                   istream.QueryInterface(Components.interfaces.nsILineInputStream);

                   var line = {};
                   istream.readLine(line);
                   if (null != line.value) {
                       bugId = line.value;
                   }
                   istream.close();

                   rebuildBugList(basePath);

                   return bugId;
               }
    return func;
}

