 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

module Main
    (main)
    where

import DisTract.BugFileInputLoader
import DisTract.Config
import DisTract.Types
import DisTract.Bug

main :: IO ()
main = do { config <- buildConfig
          ; case args config of
              [] -> return ()
              (fp:_) -> do { bugDetails <- parseForBugUpdate fp
                           ; case bugDetails of
                               Nothing -> return ()
                               (Just (bid, comment, fields)) ->
                                   updateBug config bid comment fields >>=
                                   log . show
                                   where
                                     log = logStr . logger $ config
                           }
          }
