 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

{-# LANGUAGE TemplateHaskell #-}

module DisTract.Version
    (getNameVersionFromCabal)
where

import Data.Version
import Distribution.PackageDescription
import Distribution.Package
import Language.Haskell.TH.Syntax

getNameVersionFromCabal :: FilePath -> Q [Dec]
getNameVersionFromCabal path
    = do { desc <- runIO (readPackageDescription path)
         ; makeNameVersionDeclarations desc
         }

makeNameVersionDeclarations :: PackageDescription -> Q [Dec]
makeNameVersionDeclarations desc
    = do { versionD <- [d| package_version :: String; package_version = $(lift versionStr) |]
         ; nameD <- [d| package_name :: String; package_name = $(lift name) |]
         ; return $ nameD ++ versionD
         }
    where
      pkgId = package desc
      name = pkgName pkgId
      version = pkgVersion pkgId
      versionStr = showVersion version
