 {- DisTract ------------------------------------------------------\
 |                                                                 |
 | Copyright (c) 2007, Matthew Sackman (matthew@wellquite.org)     |
 |                                                                 |
 | DisTract is freely distributable under the terms of a 3-Clause  |
 | BSD-style license. For details, see the DisTract web site:      |
 |   http://distract.wellquite.org/                                |
 |                                                                 |
 \-----------------------------------------------------------------}

module DisTract.Layout
where

import System.FilePath
import DisTract.Types

prefs :: FilePath
prefs = "prefs"

prefsDir :: FilePath -> FilePath
prefsDir base = combine base prefs

bugs :: FilePath
bugs = "bugs"

bugsDir :: FilePath -> FilePath
bugsDir base = combine base bugs

bin :: FilePath
bin = "bin"

binDir :: FilePath -> FilePath
binDir base = combine base bin

html :: FilePath
html = "html"

htmlDir :: FilePath -> FilePath
htmlDir base = combine base html

bugIdToPath :: Config -> BugId -> String
bugIdToPath config bid
    = combine (bugsDir . baseDir $ config) (show bid)

