/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.model;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.yworks.util.graph.Edge;
import com.yworks.util.graph.Node;
import com.yworks.yshrink.core.ClassResolver;
import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.EdgeType;
import com.yworks.yshrink.model.FieldDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.NewNodeDescriptor;
import com.yworks.yshrink.model.NodeType;
import com.yworks.yshrink.util.Logger;
import com.yworks.yshrink.util.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.Type;

public class Model {
    Map<String, ClassDescriptor> model;
    protected MutableNetwork<Node, Edge> network;
    private Map<Object, Object> dependencyTypes;
    protected Map<Object, Object> node2Descriptor;
    protected Map<Object, Object> node2Type;
    private Node entryPointNode;
    private boolean simpleModelSet = false;
    private ClassResolver resolver;
    private boolean allResolved = true;
    public static String VOID_DESC = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
    public static final String CONSTRUCTOR_NAME = "<init>";

    public void setClassResolver(ClassResolver res) {
        this.resolver = res != null ? res : new DefaultClassResolver();
    }

    public void setSimpleModelSet() {
        this.simpleModelSet = true;
    }

    public List<MethodDescriptor> getAllConstructors(ClassDescriptor cd) {
        ArrayList<MethodDescriptor> constructors = new ArrayList<MethodDescriptor>();
        for (MethodDescriptor md : cd.getMethods()) {
            if (!CONSTRUCTOR_NAME.equals(md.getName())) continue;
            constructors.add(md);
        }
        return constructors;
    }

    public boolean isSimpleModelSet() {
        return this.simpleModelSet;
    }

    public Model() {
        this(null);
    }

    public Model(MutableNetwork<Node, Edge> network) {
        this.network = network != null ? network : NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        this.setClassResolver(null);
        this.node2Descriptor = new HashMap<Object, Object>();
        this.node2Type = new HashMap<Object, Object>();
        this.dependencyTypes = new HashMap<Object, Object>();
        this.model = new HashMap<String, ClassDescriptor>();
        this.entryPointNode = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)this.entryPointNode);
        this.node2Type.put(this.entryPointNode, 64);
    }

    public Node getEntryPointNode() {
        return this.entryPointNode;
    }

    public boolean isClassModeled(String className) {
        return this.model.containsKey(className);
    }

    public Edge createDependencyEdge(AbstractDescriptor source, AbstractDescriptor target, EdgeType type) {
        if (!source.equals(target)) {
            return this.createDependencyEdge(source.getNode(), target.getNode(), type);
        }
        return null;
    }

    public Edge createDependencyEdge(Node sourceNode, Node targetNode, EdgeType edgeType) {
        Edge existing = sourceNode.getEdgeTo(targetNode);
        if (existing == null || !this.dependencyTypes.get(existing).equals((Object)edgeType)) {
            Edge e = new Edge((Network<Node, Edge>)this.network);
            this.network.addEdge((Object)sourceNode, (Object)targetNode, (Object)e);
            this.dependencyTypes.put(e, (Object)edgeType);
            return e;
        }
        return null;
    }

    public ClassDescriptor newClassDescriptor(String name, int access, File sourceJar) {
        Node newNode = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)newNode);
        NewNodeDescriptor newNodeDescriptor = new NewNodeDescriptor(1, sourceJar);
        this.node2Descriptor.put(newNode, newNodeDescriptor);
        this.node2Type.put(newNode, 32);
        newNodeDescriptor.setNode(newNode);
        ClassDescriptor cd = new ClassDescriptor(name, access, newNode, sourceJar);
        Node classNode = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)classNode);
        this.node2Descriptor.put(classNode, cd);
        this.node2Type.put(classNode, 4);
        cd.setNode(classNode);
        this.model.put(name, cd);
        return cd;
    }

    public ClassDescriptor newClassDescriptor(String name, String superName, String[] interfaces, int access, File sourceJar) {
        Node newNode = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)newNode);
        NewNodeDescriptor newNodeDescriptor = new NewNodeDescriptor(1, sourceJar);
        this.node2Descriptor.put(newNode, newNodeDescriptor);
        this.node2Type.put(newNode, 32);
        newNodeDescriptor.setNode(newNode);
        ClassDescriptor cd = new ClassDescriptor(name, superName, interfaces, access, newNode, sourceJar);
        Node classNode = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)classNode);
        this.node2Descriptor.put(classNode, cd);
        this.node2Type.put(classNode, 4);
        cd.setNode(classNode);
        this.model.put(name, cd);
        return cd;
    }

    public MethodDescriptor newMethodDescriptor(ClassDescriptor cd, int access, String name, String desc, String[] exceptions, File sourceJar) {
        MethodDescriptor md = new MethodDescriptor(name, access, desc, exceptions, sourceJar);
        cd.addMethod(md);
        Node n = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)n);
        this.node2Descriptor.put(n, md);
        this.node2Type.put(n, 1);
        md.setNode(n);
        return md;
    }

    public FieldDescriptor newFieldDescriptor(ClassDescriptor cd, String desc, String name, int access, File sourceJar) {
        FieldDescriptor fd = new FieldDescriptor(desc, name, access, sourceJar);
        cd.addField(fd);
        Node n = new Node((Network<Node, Edge>)this.network);
        this.network.addNode((Object)n);
        this.node2Descriptor.put(n, fd);
        this.node2Type.put(n, 2);
        fd.setNode(n);
        return fd;
    }

    public Collection<ClassDescriptor> getAllClassDescriptors() {
        return this.model.values();
    }

    public Collection<String> getAllClassNames() {
        return this.model.keySet();
    }

    public ClassDescriptor getClassDescriptor(String className) {
        if (this.isClassModeled(className)) {
            return this.model.get(className);
        }
        return null;
    }

    public AbstractDescriptor getDescriptor(Node n) {
        return (AbstractDescriptor)this.node2Descriptor.get(n);
    }

    public Node getClassNode(Node memberNode) {
        if (this.getDescriptor(memberNode) instanceof ClassDescriptor) {
            throw new IllegalArgumentException("Node " + memberNode + " is a classNode ");
        }
        for (Edge e : memberNode.outEdges()) {
            if (!this.getDependencyType(e).equals((Object)EdgeType.MEMBER_OF)) continue;
            return e.target();
        }
        throw new RuntimeException("Node " + memberNode + " is homeless.");
    }

    public EdgeType getDependencyType(Edge e) {
        return (EdgeType)((Object)this.dependencyTypes.get(e));
    }

    public Set<ClassDescriptor> getAllImplementingClasses(ClassDescriptor cd) {
        HashSet<ClassDescriptor> ret = null;
        for (Edge e : cd.getNode().inEdges()) {
            if (!this.dependencyTypes.get(e).equals((Object)EdgeType.IMPLEMENTS)) continue;
            if (ret == null) {
                ret = new HashSet<ClassDescriptor>();
            }
            ClassDescriptor subClass = (ClassDescriptor)this.node2Descriptor.get(e.source());
            ret.add(subClass);
        }
        return ret;
    }

    public void getAllImplementedInterfaces(String className, Set<String> interfaces) {
        if ("java/lang/Object".equals(className)) {
            return;
        }
        if (this.isClassModeled(className)) {
            ClassDescriptor cd = this.getClassDescriptor(className);
            String[] cInterfaces = cd.getInterfaces();
            interfaces.addAll(Arrays.asList(cInterfaces));
            for (String interfc : cInterfaces) {
                this.getAllImplementedInterfaces(interfc, interfaces);
            }
            this.getAllImplementedInterfaces(cd.getSuperName(), interfaces);
        } else {
            Class clazz = this.resolve(className);
            if (null != clazz) {
                Class<?>[] cInterfaces;
                for (Class<?> cInterface : cInterfaces = clazz.getInterfaces()) {
                    String internalClassName = Util.toInternalClass(cInterface.getName());
                    interfaces.add(internalClassName);
                    this.getAllImplementedInterfaces(internalClassName, interfaces);
                }
                Class superclass = clazz.getSuperclass();
                if (superclass != null) {
                    this.getAllImplementedInterfaces(Util.toInternalClass(superclass.getName()), interfaces);
                }
            }
        }
    }

    public void getAllAncestorClasses(String className, Set<String> parents) {
        if ("java/lang/Object".equals(className)) {
            return;
        }
        if (this.isClassModeled(className)) {
            String superName = this.getClassDescriptor(className).getSuperName();
            parents.add(superName);
            this.getAllAncestorClasses(superName, parents);
        } else {
            Class superclass;
            Class clazz = this.resolve(className);
            if (null != clazz && null != (superclass = clazz.getSuperclass())) {
                String superName = Util.toInternalClass(superclass.getName());
                parents.add(superName);
                this.getAllAncestorClasses(superName, parents);
            }
        }
    }

    public void getAllInternalAncestorEntrypointMethods(String className, List<MethodDescriptor> methods) {
        String[] interfaces;
        if (null == className || !this.isClassModeled(className)) {
            return;
        }
        ClassDescriptor cd = this.getClassDescriptor(className);
        Collection<MethodDescriptor> classMethods = cd.getMethods();
        for (MethodDescriptor md : classMethods) {
            if (!md.isEntryPoint()) continue;
            methods.add(md);
        }
        if (!cd.isInterface() || !"java/lang/Object".equals(cd.getSuperName())) {
            this.getAllInternalAncestorEntrypointMethods(cd.getSuperName(), methods);
        }
        for (String interfc : interfaces = cd.getInterfaces()) {
            this.getAllInternalAncestorEntrypointMethods(interfc, methods);
        }
    }

    public boolean getAllExternalAncestorMethods(String className, List<Method> methods) {
        boolean r = true;
        if (null == className) {
            return true;
        }
        if (this.isClassModeled(className)) {
            String[] interfaces;
            ClassDescriptor cd = this.getClassDescriptor(className);
            if (!cd.isInterface() || !"java/lang/Object".equals(cd.getSuperName())) {
                r &= this.getAllExternalAncestorMethods(cd.getSuperName(), methods);
            }
            for (String interfc : interfaces = cd.getInterfaces()) {
                r &= this.getAllExternalAncestorMethods(interfc, methods);
            }
        } else {
            Class clazz = this.resolve(className);
            if (null != clazz) {
                Class<?>[] interfaces;
                Method[] clazzMethods;
                for (Method method : clazzMethods = clazz.getDeclaredMethods()) {
                    methods.add(method);
                }
                Class superClass = clazz.getSuperclass();
                if (null != superClass) {
                    r &= this.getAllExternalAncestorMethods(superClass.getName(), methods);
                }
                for (Class<?> interfc : interfaces = clazz.getInterfaces()) {
                    r &= this.getAllExternalAncestorMethods(interfc.getName(), methods);
                }
            } else {
                return false;
            }
        }
        return r;
    }

    public boolean getAllInternalAncestorMethods(String className, List<MethodDescriptor> methods) {
        boolean r = true;
        if (null == className) {
            return true;
        }
        if (this.isClassModeled(className)) {
            String[] interfaces;
            ClassDescriptor cd = this.getClassDescriptor(className);
            for (MethodDescriptor methodDescriptor : cd.getMethods()) {
                methods.add(methodDescriptor);
            }
            if (!cd.isInterface() || !"java/lang/Object".equals(cd.getSuperName())) {
                r &= this.getAllInternalAncestorMethods(cd.getSuperName(), methods);
            }
            for (String interfc : interfaces = cd.getInterfaces()) {
                r &= this.getAllInternalAncestorMethods(interfc, methods);
            }
        } else {
            Class clazz = this.resolve(className);
            if (null != clazz) {
                Class<?>[] interfaces;
                Method[] clazzMethods = clazz.getDeclaredMethods();
                Class clazz2 = clazz.getSuperclass();
                if (null != clazz2) {
                    r &= this.getAllInternalAncestorMethods(clazz2.getName(), methods);
                }
                for (Class<?> interfc : interfaces = clazz.getInterfaces()) {
                    r &= this.getAllInternalAncestorMethods(interfc.getName(), methods);
                }
            } else {
                return false;
            }
        }
        return r;
    }

    public void getInternalDescendants(ClassDescriptor cd, List<ClassDescriptor> descendants) {
        for (Edge e : cd.getNode().inEdges()) {
            if (!this.dependencyTypes.get(e).equals((Object)EdgeType.EXTENDS)) continue;
            ClassDescriptor subClass = (ClassDescriptor)this.node2Descriptor.get(e.source());
            descendants.add(subClass);
            this.getInternalDescendants(subClass, descendants);
        }
    }

    public boolean hasUnresolvableAncestors(String className) {
        boolean r = false;
        if (this.isClassModeled(className)) {
            ClassDescriptor cd = this.getClassDescriptor(className);
            r = r || this.hasUnresolvableAncestors(cd.getSuperName());
            for (String interfc : cd.getInterfaces()) {
                r = r || this.hasUnresolvableAncestors(interfc);
            }
        } else {
            this.resolve(className);
        }
        return r;
    }

    private boolean isMethodDefinedInExternalInterface(ClassDescriptor origClass, MethodDescriptor md) {
        String[] interfaces;
        boolean found = false;
        for (String interfc : interfaces = origClass.getInterfaces()) {
            Class clazz;
            if (this.isClassModeled(interfc) || null == (clazz = this.resolve(interfc))) continue;
            found = found || this.containsNonPrivateMethod(clazz, md);
            for (Class<?> clazzz : clazz.getInterfaces()) {
                found = found || this.isMethodDefinedInExternalInterfaceRec(clazzz, md);
            }
        }
        return found;
    }

    private boolean isMethodDefinedInExternalInterfaceRec(Class clazz, MethodDescriptor md) {
        boolean found = false;
        if (this.containsNonPrivateMethod(clazz, md)) {
            return true;
        }
        for (Class<?> clazzz : clazz.getInterfaces()) {
            found = found || this.isMethodDefinedInExternalInterfaceRec(clazzz, md);
        }
        return found;
    }

    public boolean isMethodExternallyDefined(ClassDescriptor origClass, MethodDescriptor md) {
        boolean found = false;
        found = found || this.isMethodExternallyDefinedRec(origClass.getSuperName(), md);
        for (String interfc : origClass.getInterfaces()) {
            found = found || this.isMethodExternallyDefinedRec(interfc, md);
        }
        ArrayList<ClassDescriptor> descendants = new ArrayList<ClassDescriptor>();
        this.getInternalDescendants(origClass, descendants);
        for (ClassDescriptor cd : descendants) {
            found = found || this.isMethodDefinedInExternalInterface(cd, md);
        }
        return found;
    }

    private boolean isMethodExternallyDefinedRec(String className, MethodDescriptor md) {
        boolean found;
        block6: {
            block5: {
                found = false;
                if (!this.isClassModeled(className)) break block5;
                ClassDescriptor cd = this.getClassDescriptor(className);
                boolean internallyDefined = false;
                if (internallyDefined) break block6;
                String[] interfaces = cd.getInterfaces();
                String superClass = cd.getSuperName();
                if (interfaces.length > 0) {
                    for (int i = 0; i < interfaces.length; ++i) {
                        found = found || this.isMethodExternallyDefinedRec(interfaces[i], md);
                    }
                }
                if (className == "java/lang/Object") break block6;
                found = found || this.isMethodExternallyDefinedRec(superClass, md);
                break block6;
            }
            Class clazz = this.resolve(className);
            if (clazz != null && !(found = this.containsNonPrivateMethod(clazz, md)) && !"java/lang/Object".equals(clazz.getName())) {
                Class<?>[] interfaces;
                Class superClass = clazz.getSuperclass();
                if (superClass != null) {
                    found = found || this.isMethodExternallyDefinedRec(superClass.getName(), md);
                }
                for (Class<?> interfc : interfaces = clazz.getInterfaces()) {
                    found = found || this.isMethodExternallyDefinedRec(interfc.getName(), md);
                }
            }
        }
        return found;
    }

    private boolean containsNonPrivateMethod(Class clazz, MethodDescriptor md) {
        boolean found = false;
        Method[] methods = clazz.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (Modifier.isPrivate(methods[i].getModifiers()) || !md.overrides(methods[i])) continue;
            found = true;
        }
        return found;
    }

    public void createEntryPointEdges(List<AbstractDescriptor> entryPoints) {
        Node entryPointNode = this.getEntryPointNode();
        for (AbstractDescriptor descriptor : entryPoints) {
            if (descriptor instanceof MethodDescriptor) {
                MethodDescriptor md = (MethodDescriptor)descriptor;
                this.createDependencyEdge(entryPointNode, md.getNode(), EdgeType.INVOKES);
                this.createDependencyEdge(entryPointNode, md.getNode(), EdgeType.RESOLVE);
                continue;
            }
            this.createDependencyEdge(entryPointNode, descriptor.getNode(), EdgeType.ENTRYPOINT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class resolve(String className) {
        Class clazz = null;
        try {
            clazz = this.resolver.resolve(Util.toJavaClass(className));
            return clazz;
        }
        catch (ClassNotFoundException e) {
            Logger.warnToLog("Unresolved external dependency: " + Util.toJavaClass(className) + " not found!");
            this.allResolved = false;
            return this.allResolved;
        }
        catch (RuntimeException e) {
            Logger.warnToLog("error resolving class " + className);
            this.allResolved = false;
            return this.allResolved;
        }
        finally {
            return clazz;
        }
    }

    public boolean isAllResolved() {
        return this.allResolved;
    }

    private MethodDescriptor method2Descriptor(Method m, File sourceJar) {
        int access = m.getModifiers();
        String desc = Type.getMethodDescriptor((Method)m);
        Class<?>[] exceptionClasses = m.getExceptionTypes();
        String[] exceptions = new String[exceptionClasses.length];
        for (int i = 0; i < exceptionClasses.length; ++i) {
            exceptions[i] = exceptionClasses[i].getName();
        }
        return new MethodDescriptor(m.getName(), access, desc, exceptions, sourceJar);
    }

    public int getNodeType(AbstractDescriptor ad) {
        return (Integer)this.node2Type.get(ad.getNode());
    }

    public int getNodeType(Node n) {
        return (Integer)this.node2Type.get(n);
    }

    public void markObsolete(Node n) {
        int type = this.getNodeType(n);
        if (!NodeType.isObsolete(type)) {
            this.node2Type.put(n, type += 8192);
        }
    }

    public void markNotObsolete(Node n) {
        int type = this.getNodeType(n);
        if (NodeType.isObsolete(type)) {
            this.node2Type.put(n, type -= 8192);
        }
    }

    public void markStubNeeded(Node n) {
        int type = this.getNodeType(n);
        if (!NodeType.isStubNeeded(type)) {
            this.node2Type.put(n, type += 16384);
        }
    }

    public boolean isObsolete(Node n) {
        return NodeType.isObsolete((Integer)this.node2Type.get(n));
    }

    public boolean isStubNeeded(Node n) {
        return NodeType.isStubNeeded((Integer)this.node2Type.get(n));
    }

    public Network<Node, Edge> getNetwork() {
        return this.network;
    }

    private static class DefaultClassResolver
    implements ClassResolver {
        private DefaultClassResolver() {
        }

        @Override
        public Class resolve(String className) throws ClassNotFoundException {
            return Class.forName(className, false, this.getClass().getClassLoader());
        }

        @Override
        public void close() throws Exception {
        }
    }
}

