/*
 * Decompiled with CFR 0.152.
 */
package com.ejt.internal.util;

import org.jetbrains.annotations.NotNull;

public class JavaVersionUtil {
    public static final boolean JETBRAINS_JRE = System.getProperty("java.vendor").toLowerCase().contains("jetbrains");
    public static final int JAVA_MAJOR_VERSION = JavaVersionUtil.getJavaMajorVersion(System.getProperty("java.version"));
    public static final String LEGACY_PREFIX = "1.";
    public static final boolean IS_32_BIT = "32".equals(System.getProperty("sun.arch.data.model"));

    public static int getJavaMajorVersion(@NotNull String versionText) {
        int dotIndex;
        if (versionText.startsWith(LEGACY_PREFIX)) {
            versionText = versionText.substring(LEGACY_PREFIX.length());
        }
        if ((dotIndex = versionText.indexOf(46)) > -1) {
            versionText = versionText.substring(0, dotIndex);
        }
        for (int i = 0; i < versionText.length(); ++i) {
            if (Character.isDigit(versionText.charAt(i))) continue;
            versionText = versionText.substring(0, i);
            break;
        }
        return Integer.parseInt(versionText);
    }

    public static boolean isJava9Plus() {
        return JAVA_MAJOR_VERSION >= 9;
    }

    public static boolean isJava11Plus() {
        return JAVA_MAJOR_VERSION >= 11;
    }
}

