/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder.print;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.LengthKey;
import org.apache.batik.transcoder.keys.StringKey;
import org.w3c.dom.Document;

public class PrintTranscoder
extends SVGAbstractTranscoder
implements Printable {
    public static final String KEY_AOI_STR = "aoi";
    public static final String KEY_HEIGHT_STR = "height";
    public static final String KEY_LANGUAGE_STR = "language";
    public static final String KEY_MARGIN_BOTTOM_STR = "marginBottom";
    public static final String KEY_MARGIN_LEFT_STR = "marginLeft";
    public static final String KEY_MARGIN_RIGHT_STR = "marginRight";
    public static final String KEY_MARGIN_TOP_STR = "marginTop";
    public static final String KEY_PAGE_HEIGHT_STR = "pageHeight";
    public static final String KEY_PAGE_ORIENTATION_STR = "pageOrientation";
    public static final String KEY_PAGE_WIDTH_STR = "pageWidth";
    public static final String KEY_PIXEL_TO_MM_STR = "pixelToMm";
    public static final String KEY_SCALE_TO_PAGE_STR = "scaleToPage";
    public static final String KEY_SHOW_PAGE_DIALOG_STR = "showPageDialog";
    public static final String KEY_SHOW_PRINTER_DIALOG_STR = "showPrinterDialog";
    public static final String KEY_USER_STYLESHEET_URI_STR = "userStylesheet";
    public static final String KEY_WIDTH_STR = "width";
    public static final String KEY_XML_PARSER_CLASSNAME_STR = "xmlParserClassName";
    public static final String VALUE_MEDIA_PRINT = "print";
    public static final String VALUE_PAGE_ORIENTATION_LANDSCAPE = "landscape";
    public static final String VALUE_PAGE_ORIENTATION_PORTRAIT = "portrait";
    public static final String VALUE_PAGE_ORIENTATION_REVERSE_LANDSCAPE = "reverseLandscape";
    private List inputs = new ArrayList();
    private List printedInputs = null;
    private int curIndex = -1;
    private BridgeContext theCtx;
    public static final TranscodingHints.Key KEY_SHOW_PAGE_DIALOG = new BooleanKey();
    public static final TranscodingHints.Key KEY_SHOW_PRINTER_DIALOG = new BooleanKey();
    public static final TranscodingHints.Key KEY_PAGE_WIDTH = new LengthKey();
    public static final TranscodingHints.Key KEY_PAGE_HEIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_MARGIN_TOP = new LengthKey();
    public static final TranscodingHints.Key KEY_MARGIN_RIGHT = new LengthKey();
    public static final TranscodingHints.Key KEY_MARGIN_BOTTOM = new LengthKey();
    public static final TranscodingHints.Key KEY_MARGIN_LEFT = new LengthKey();
    public static final TranscodingHints.Key KEY_PAGE_ORIENTATION = new StringKey();
    public static final TranscodingHints.Key KEY_SCALE_TO_PAGE = new BooleanKey();
    public static final String USAGE = "java org.apache.batik.transcoder.print.PrintTranscoder <svgFileToPrint>";

    public PrintTranscoder() {
        this.hints.put(KEY_MEDIA, VALUE_MEDIA_PRINT);
    }

    @Override
    public void transcode(TranscoderInput transcoderInput, TranscoderOutput transcoderOutput) {
        if (transcoderInput != null) {
            this.inputs.add(transcoderInput);
        }
    }

    @Override
    protected void transcode(Document document, String string, TranscoderOutput transcoderOutput) throws TranscoderException {
        super.transcode(document, string, transcoderOutput);
        this.theCtx = this.ctx;
        this.ctx = null;
    }

    public void print() throws PrinterException {
        Object object;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Object object2 = printerJob.defaultPage();
        Paper paper = ((PageFormat)object2).getPaper();
        Float f = (Float)this.hints.get(KEY_PAGE_WIDTH);
        Float f2 = (Float)this.hints.get(KEY_PAGE_HEIGHT);
        if (f != null) {
            paper.setSize(f.floatValue(), paper.getHeight());
        }
        if (f2 != null) {
            paper.setSize(paper.getWidth(), f2.floatValue());
        }
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = (float)paper.getWidth();
        float f6 = (float)paper.getHeight();
        Float f7 = (Float)this.hints.get(KEY_MARGIN_LEFT);
        Float f8 = (Float)this.hints.get(KEY_MARGIN_TOP);
        Float f9 = (Float)this.hints.get(KEY_MARGIN_RIGHT);
        Float f10 = (Float)this.hints.get(KEY_MARGIN_BOTTOM);
        if (f7 != null) {
            f3 = f7.floatValue();
            f5 -= f7.floatValue();
        }
        if (f8 != null) {
            f4 = f8.floatValue();
            f6 -= f8.floatValue();
        }
        if (f9 != null) {
            f5 -= f9.floatValue();
        }
        if (f10 != null) {
            f6 -= f10.floatValue();
        }
        paper.setImageableArea(f3, f4, f5, f6);
        String string = (String)this.hints.get(KEY_PAGE_ORIENTATION);
        if (VALUE_PAGE_ORIENTATION_PORTRAIT.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(1);
        } else if (VALUE_PAGE_ORIENTATION_LANDSCAPE.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(0);
        } else if (VALUE_PAGE_ORIENTATION_REVERSE_LANDSCAPE.equalsIgnoreCase(string)) {
            ((PageFormat)object2).setOrientation(2);
        }
        ((PageFormat)object2).setPaper(paper);
        object2 = printerJob.validatePage((PageFormat)object2);
        Boolean bl = (Boolean)this.hints.get(KEY_SHOW_PAGE_DIALOG);
        if (bl != null && bl.booleanValue()) {
            object = printerJob.pageDialog((PageFormat)object2);
            if (object == object2) {
                return;
            }
            object2 = object;
        }
        printerJob.setPrintable(this, (PageFormat)object2);
        object = (Boolean)this.hints.get(KEY_SHOW_PRINTER_DIALOG);
        if (object != null && ((Boolean)object).booleanValue() && !printerJob.printDialog()) {
            return;
        }
        printerJob.print();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (this.printedInputs == null) {
            this.printedInputs = new ArrayList(this.inputs);
        }
        if (n >= this.printedInputs.size()) {
            this.curIndex = -1;
            if (this.theCtx != null) {
                this.theCtx.dispose();
            }
            this.userAgent.displayMessage("Done");
            return 1;
        }
        if (this.curIndex != n) {
            if (this.theCtx != null) {
                this.theCtx.dispose();
            }
            try {
                this.width = (int)pageFormat.getImageableWidth();
                this.height = (int)pageFormat.getImageableHeight();
                super.transcode((TranscoderInput)this.printedInputs.get(n), null);
                this.curIndex = n;
            }
            catch (TranscoderException transcoderException) {
                this.drawError(graphics, transcoderException);
                return 0;
            }
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        graphics2D.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, "Printing");
        AffineTransform affineTransform = graphics2D.getTransform();
        Shape shape = graphics2D.getClip();
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.transform(this.curTxf);
        try {
            this.root.paint(graphics2D);
        }
        catch (Exception exception) {
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(shape);
            this.drawError(graphics, exception);
        }
        graphics2D.setTransform(affineTransform);
        graphics2D.setClip(shape);
        return 0;
    }

    @Override
    protected void setImageSize(float f, float f2) {
        Boolean bl = (Boolean)this.hints.get(KEY_SCALE_TO_PAGE);
        if (bl != null && !bl.booleanValue()) {
            float f3 = f;
            float f4 = f2;
            if (this.hints.containsKey(KEY_AOI)) {
                Rectangle2D rectangle2D = (Rectangle2D)this.hints.get(KEY_AOI);
                f3 = (float)rectangle2D.getWidth();
                f4 = (float)rectangle2D.getHeight();
            }
            super.setImageSize(f3, f4);
        }
    }

    private void drawError(Graphics graphics, Exception exception) {
        this.userAgent.displayError(exception);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println(USAGE);
            System.exit(0);
        }
        PrintTranscoder printTranscoder = new PrintTranscoder();
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_LANGUAGE_STR, KEY_LANGUAGE);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_USER_STYLESHEET_URI_STR, KEY_USER_STYLESHEET_URI);
        PrintTranscoder.setTranscoderStringHint(printTranscoder, KEY_XML_PARSER_CLASSNAME_STR, KEY_XML_PARSER_CLASSNAME);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SCALE_TO_PAGE_STR, KEY_SCALE_TO_PAGE);
        PrintTranscoder.setTranscoderRectangleHint(printTranscoder, KEY_AOI_STR, KEY_AOI);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_WIDTH_STR, KEY_WIDTH);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_HEIGHT_STR, KEY_HEIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PIXEL_TO_MM_STR, KEY_PIXEL_UNIT_TO_MILLIMETER);
        PrintTranscoder.setTranscoderStringHint(printTranscoder, KEY_PAGE_ORIENTATION_STR, KEY_PAGE_ORIENTATION);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PAGE_WIDTH_STR, KEY_PAGE_WIDTH);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_PAGE_HEIGHT_STR, KEY_PAGE_HEIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_TOP_STR, KEY_MARGIN_TOP);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_RIGHT_STR, KEY_MARGIN_RIGHT);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_BOTTOM_STR, KEY_MARGIN_BOTTOM);
        PrintTranscoder.setTranscoderFloatHint(printTranscoder, KEY_MARGIN_LEFT_STR, KEY_MARGIN_LEFT);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SHOW_PAGE_DIALOG_STR, KEY_SHOW_PAGE_DIALOG);
        PrintTranscoder.setTranscoderBooleanHint(printTranscoder, KEY_SHOW_PRINTER_DIALOG_STR, KEY_SHOW_PRINTER_DIALOG);
        for (int i = 0; i < stringArray.length; ++i) {
            printTranscoder.transcode(new TranscoderInput(new File(stringArray[i]).toURI().toURL().toString()), null);
        }
        printTranscoder.print();
        System.exit(0);
    }

    public static void setTranscoderFloatHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                Float f = new Float(Float.parseFloat(string2));
                transcoder.addTranscodingHint(key, f);
            }
            catch (NumberFormatException numberFormatException) {
                PrintTranscoder.handleValueError(string, string2);
            }
        }
    }

    public static void setTranscoderRectangleHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,");
            if (stringTokenizer.countTokens() != 4) {
                PrintTranscoder.handleValueError(string, string2);
            }
            try {
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                Rectangle2D.Float float_ = new Rectangle2D.Float(Float.parseFloat(string3), Float.parseFloat(string4), Float.parseFloat(string5), Float.parseFloat(string6));
                transcoder.addTranscodingHint(key, float_);
            }
            catch (NumberFormatException numberFormatException) {
                PrintTranscoder.handleValueError(string, string2);
            }
        }
    }

    public static void setTranscoderBooleanHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            Boolean bl = "true".equalsIgnoreCase(string2) ? Boolean.TRUE : Boolean.FALSE;
            transcoder.addTranscodingHint(key, bl);
        }
    }

    public static void setTranscoderStringHint(Transcoder transcoder, String string, TranscodingHints.Key key) {
        String string2 = System.getProperty(string);
        if (string2 != null) {
            transcoder.addTranscodingHint(key, string2);
        }
    }

    public static void handleValueError(String string, String string2) {
        System.err.println("Invalid " + string + " value : " + string2);
        System.exit(1);
    }
}

