/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ElementValuePairInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AnnotationInfo {
    protected int u2typeIndex;
    private int u2elementCount;
    private ElementValuePairInfo[] elementValuePairs;

    public static AnnotationInfo create(DataInput din) throws IOException {
        if (din == null) {
            throw new NullPointerException("DataInput cannot be null!");
        }
        AnnotationInfo an = new AnnotationInfo();
        an.read(din);
        return an;
    }

    public ElementValuePairInfo[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    private AnnotationInfo() {
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) {
        pool.getCpEntry(this.u2typeIndex).incRefCount();
        for (int i = 0; i < this.u2elementCount; ++i) {
            this.elementValuePairs[i].markUtf8RefsInInfo(pool);
        }
    }

    private void read(DataInput din) throws IOException {
        this.u2typeIndex = din.readUnsignedShort();
        this.u2elementCount = din.readUnsignedShort();
        this.elementValuePairs = new ElementValuePairInfo[this.u2elementCount];
        for (int i = 0; i < this.u2elementCount; ++i) {
            this.elementValuePairs[i] = ElementValuePairInfo.create(din);
        }
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2typeIndex);
        dout.writeShort(this.u2elementCount);
        for (int i = 0; i < this.u2elementCount; ++i) {
            this.elementValuePairs[i].write(dout);
        }
    }
}

