/*
 * Decompiled with CFR 0.152.
 */
package com.onseven.dbvis.util;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public final class j {
    public static synchronized StringBuilder b() {
        try {
            ThreadInfo[] threadInfoArray;
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            StringBuilder stringBuilder = new StringBuilder(4096);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Properties properties = System.getProperties();
            stringBuilder.append(simpleDateFormat.format(new Date())).append("\n");
            stringBuilder.append("Full thread dump ").append(properties.getProperty("java.vm.name")).append(" (").append(properties.getProperty("java.vm.version")).append(" ").append(properties.getProperty("java.vm.info")).append("):\n");
            for (ThreadInfo threadInfo : threadInfoArray = threadMXBean.dumpAllThreads(true, true)) {
                if (threadInfo == null) continue;
                j.b(stringBuilder, threadMXBean, threadInfo);
            }
            return stringBuilder;
        }
        catch (RuntimeException runtimeException) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Failed to dump threads: ").append(runtimeException.toString());
            return stringBuilder;
        }
    }

    private static void b(StringBuilder stringBuilder, ThreadMXBean threadMXBean, ThreadInfo threadInfo) {
        MonitorInfo[] monitorInfoArray = null;
        if (threadMXBean.isObjectMonitorUsageSupported()) {
            monitorInfoArray = threadInfo.getLockedMonitors();
        }
        stringBuilder.append("\n\"").append(threadInfo.getThreadName()).append("\" - Thread t@").append(threadInfo.getThreadId()).append("\n");
        stringBuilder.append("   java.lang.Thread.State: ").append((Object)threadInfo.getThreadState());
        stringBuilder.append("\n");
        int n2 = 0;
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            LockInfo lockInfo = threadInfo.getLockInfo();
            String object = threadInfo.getLockOwnerName();
            stringBuilder.append("\tat ").append(stackTraceElement.toString()).append("\n");
            if (n2 == 0) {
                if ("java.lang.Object".equals(stackTraceElement.getClassName()) && "wait".equals(stackTraceElement.getMethodName())) {
                    if (lockInfo != null) {
                        stringBuilder.append("\t- waiting on ");
                        j.b(stringBuilder, lockInfo);
                        stringBuilder.append("\n");
                    }
                } else if (lockInfo != null) {
                    if (object == null) {
                        stringBuilder.append("\t- parking to wait for ");
                        j.b(stringBuilder, lockInfo);
                        stringBuilder.append("\n");
                    } else {
                        stringBuilder.append("\t- waiting to lock ");
                        j.b(stringBuilder, lockInfo);
                        stringBuilder.append(" owned by \"").append(object).append("\" t@").append(threadInfo.getLockOwnerId()).append("\n");
                    }
                }
            }
            j.b(stringBuilder, monitorInfoArray, n2);
            ++n2;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        j.b(stringBuilder2, monitorInfoArray, -1);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("   JNI locked monitors:\n");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if (threadMXBean.isSynchronizerUsageSupported()) {
            stringBuilder.append("\n   Locked ownable synchronizers:");
            LockInfo[] lockInfoArray = threadInfo.getLockedSynchronizers();
            if (lockInfoArray == null || lockInfoArray.length == 0) {
                stringBuilder.append("\n\t- None\n");
            } else {
                for (LockInfo lockInfo : lockInfoArray) {
                    stringBuilder.append("\n\t- locked ");
                    j.b(stringBuilder, lockInfo);
                    stringBuilder.append("\n");
                }
            }
        }
    }

    private static void b(StringBuilder stringBuilder, LockInfo lockInfo) {
        String string = Integer.toHexString(lockInfo.getIdentityHashCode());
        String string2 = lockInfo.getClassName();
        stringBuilder.append("<").append(string).append("> (a ").append(string2).append(")");
    }

    private static void b(StringBuilder stringBuilder, MonitorInfo[] monitorInfoArray, int n2) {
        if (monitorInfoArray != null) {
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != n2) continue;
                stringBuilder.append("\t- locked ");
                j.b(stringBuilder, monitorInfo);
                stringBuilder.append("\n");
            }
        }
    }
}

