/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import org.freehep.graphicsio.emf.EMFRenderer;
import org.freehep.graphicsio.emf.EMFTag;

public abstract class AbstractPolyPolygon
extends EMFTag {
    private Rectangle bounds;
    private int[] numberOfPoints;
    private Point[][] points;

    protected AbstractPolyPolygon(int id, int version, Rectangle bounds, int[] numberOfPoints, Point[][] points) {
        super(id, version);
        this.bounds = bounds;
        this.numberOfPoints = numberOfPoints;
        this.points = points;
    }

    public String toString() {
        return super.toString() + "\n  bounds: " + this.bounds + "\n  #polys: " + this.numberOfPoints.length;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected int[] getNumberOfPoints() {
        return this.numberOfPoints;
    }

    protected Point[][] getPoints() {
        return this.points;
    }

    public void render(EMFRenderer renderer) {
        this.render(renderer, true);
    }

    protected void render(EMFRenderer renderer, boolean closePath) {
        GeneralPath path = new GeneralPath(renderer.getWindingRule());
        for (int polygon = 0; polygon < this.numberOfPoints.length; ++polygon) {
            GeneralPath gp = new GeneralPath(renderer.getWindingRule());
            for (int point = 0; point < this.numberOfPoints[polygon]; ++point) {
                Point p = this.points[polygon][point];
                if (point > 0) {
                    gp.lineTo((float)p.getX(), (float)p.getY());
                    continue;
                }
                gp.moveTo((float)p.getX(), (float)p.getY());
            }
            if (closePath) {
                gp.closePath();
            }
            path.append(gp, false);
        }
        if (closePath) {
            renderer.fillAndDrawOrAppend(path);
        } else {
            renderer.drawOrAppend(path);
        }
    }
}

