/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper;

import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.platform.unix.Execution;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppleScriptHelper {
    private static final String RECORD_PREFIX = "__i4j_rec_";
    private static final int RECORD_PREFIX_LENGTH = "__i4j_rec_".length();
    private static final String RECORD_START = "__i4j_rec_start";

    private AppleScriptHelper() {
    }

    public static String getRecordScript(String ... identifiersToValues) {
        StringBuilder builder = new StringBuilder("    \tset output to output & \"\\n__i4j_rec_start\"\n");
        for (int i = 0; i < identifiersToValues.length; i += 2) {
            if (identifiersToValues[i].contains(":")) {
                throw new IllegalArgumentException("identifier must not contain a ':'");
            }
            builder.append("    \tset output to output & \"\\n__i4j_rec_").append(identifiersToValues[i]).append(": \" & ").append(identifiersToValues[i + 1]).append("\n");
        }
        return builder.toString();
    }

    public static List<Map<String, String>> getRecords(String script) {
        StringBuffer output = new StringBuffer();
        StringBuffer error = new StringBuffer();
        if (AppleScriptHelper.executeScript(script, output, error)) {
            ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>();
            HashMap<String, String> currentEntry = null;
            String lastIdentifier = null;
            for (String line : output.toString().split("[\\r\\n]+")) {
                try {
                    if (line.equals(RECORD_START)) {
                        if (currentEntry != null) {
                            ret.add(currentEntry);
                        }
                        currentEntry = new HashMap<String, String>();
                        lastIdentifier = null;
                        continue;
                    }
                    if (line.startsWith(RECORD_PREFIX)) {
                        if (currentEntry == null) {
                            Logger.getInstance().error(null, "start missing before: " + line);
                            continue;
                        }
                        int colonPos = line.indexOf(58, RECORD_PREFIX_LENGTH);
                        if (colonPos == -1) {
                            Logger.getInstance().error(null, "invalid line: " + line);
                            continue;
                        }
                        lastIdentifier = line.substring(RECORD_PREFIX_LENGTH, colonPos);
                        String value = "";
                        if (line.length() >= colonPos + 2) {
                            value = line.substring(colonPos + 2);
                        }
                        currentEntry.put(lastIdentifier, value);
                        continue;
                    }
                    if (lastIdentifier == null) continue;
                    currentEntry.put(lastIdentifier, (String)currentEntry.get(lastIdentifier) + "\n" + line);
                }
                catch (Exception e) {
                    Logger.getInstance().log(e);
                }
            }
            if (currentEntry != null) {
                ret.add(currentEntry);
            }
            return ret;
        }
        Logger.getInstance().error(null, "error executing AppleScript: " + error.toString());
        return null;
    }

    public static boolean executeScript(String script) {
        StringBuffer output = new StringBuffer();
        Logger.getInstance().info(null, script);
        boolean ret = AppleScriptHelper.executeScript(script, output, output);
        Logger.getInstance().info(null, output.toString());
        return ret;
    }

    private static boolean executeScript(String script, StringBuffer output, StringBuffer error) {
        try {
            File tempFile = File.createTempFile("i4j", ".script");
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tempFile)), StandardCharsets.UTF_8));
            pw.println(script);
            pw.close();
            boolean ret = Execution.executeWithReturnCode(new String[]{"/usr/bin/osascript", tempFile.getAbsolutePath()}, output, error, true) == 0;
            tempFile.delete();
            return ret;
        }
        catch (IOException e) {
            Logger.getInstance().log(e);
            return false;
        }
    }
}

