/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.utilities.conversion;

import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.dsi.dataengine.utilities.DSIMonthSpan;
import com.vertica.dsi.dataengine.utilities.DSITimeSpan;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.TimeTz;
import com.vertica.dsi.dataengine.utilities.TimestampTz;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.dataengine.utilities.TypeUtilities;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import com.vertica.dsi.utilities.CalendarSetter;
import com.vertica.dsi.utilities.StringConverter;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.support.IWarningListener;
import com.vertica.support.Pair;
import com.vertica.support.Warning;
import com.vertica.support.WarningCode;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.TypeNames;
import com.vertica.utilities.conversion.IntervalConverter;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public class TypeConverter {
    private static final int TWO_TO_8 = 256;
    private static final int TWO_TO_16 = 65536;
    private static final long TWO_TO_32 = 0x100000000L;
    private static final BigInteger TWO_TO_64;
    private static Map<Class<?>, Integer> CLASS_TO_TYPE_MAP;
    private static final Map<Integer, List<Integer>> TYPE_CONVERSION_MAP;
    private static final Map<String, String> NORMALIZE_DOUBLE_OR_FLOAT_MAP;
    private static final Map<Integer, List<Integer>> STREAM_FROM_CONVERSION_MAP;
    private static final Map<Integer, List<Integer>> STREAM_TO_CONVERSION_MAP;

    public static boolean canConvert(int fromType, int toType) {
        return TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, fromType, toType);
    }

    public static boolean canConvertStreamFrom(int fromType, int toStreamType) {
        return TypeConverter.canConvertFrom(STREAM_FROM_CONVERSION_MAP, fromType, toStreamType);
    }

    public static boolean canConvertStreamTo(int fromStreamType, int toType) {
        return TypeConverter.canConvertFrom(STREAM_TO_CONVERSION_MAP, fromStreamType, toType);
    }

    public static int getSqlType(Object value) {
        int sqlType = 0;
        sqlType = value instanceof DSIMonthSpan ? ((DSIMonthSpan)value).getIntervalType() : (value instanceof DSITimeSpan ? ((DSITimeSpan)value).getIntervalType() : (value instanceof Calendar ? CLASS_TO_TYPE_MAP.get(Calendar.class) : (value instanceof Struct ? 2002 : (CLASS_TO_TYPE_MAP.containsKey(value.getClass()) ? CLASS_TO_TYPE_MAP.get(value.getClass()) : 2000))));
        return sqlType;
    }

    public static BigDecimal toBigDecimal(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (TypeUtilities.isExactNumericType(type)) {
            if (data.isNull()) {
                return null;
            }
            return (BigDecimal)data.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 3)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            if (TypeUtilities.isBooleanType(type)) {
                return new BigDecimal(TypeConverter.toInt(data, warningListener));
            }
            if (1 == type) {
                return new BigDecimal(TypeConverter.toString(data, null).trim());
            }
            return new BigDecimal(TypeConverter.toString(data, null));
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(2));
        }
    }

    public static BigDecimal toBigDecimal(DataWrapper data, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (TypeUtilities.isExactNumericType(type)) {
            if (data.isNull()) {
                return null;
            }
            return TypeConverter.rescaleBigDecimal((BigDecimal)data.getObject(), meta.getScale(), warningListener);
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 3)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            BigDecimal bigDec = null;
            bigDec = TypeUtilities.isBooleanType(type) ? new BigDecimal(TypeConverter.toInt(data, warningListener)) : (TypeUtilities.isCharacterType(type) ? (1 == type ? new BigDecimal(((String)data.getObject()).trim()) : new BigDecimal((String)data.getObject())) : new BigDecimal(TypeConverter.toString(data, meta)));
            return TypeConverter.rescaleBigDecimal(bigDec, meta.getScale(), warningListener);
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(2));
        }
    }

    public static boolean toBoolean(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (-7 == type) {
            if (data.isNull()) {
                return false;
            }
            return data.getBit();
        }
        if (16 == type) {
            if (data.isNull()) {
                return false;
            }
            return data.getBoolean();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, -7)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return false;
        }
        try {
            if (TypeUtilities.isCharacterType(type)) {
                String boolString = (String)data.getObject();
                if (1 == type) {
                    boolString = boolString.trim();
                }
                return !boolString.equalsIgnoreCase("false") && !boolString.equals("0") && !boolString.equals("0.0") && !boolString.equalsIgnoreCase("f");
            }
            return 0.0f != TypeConverter.toFloat(data, warningListener);
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(16));
        }
    }

    public static byte toByte(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (-6 == type) {
            if (data.isNull()) {
                return 0;
            }
            return data.getTinyInt().byteValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, -6)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (byte)Long.parseLong(((String)value).trim());
                    }
                    catch (Exception e) {
                        return (byte)Double.parseDouble(((String)value).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (byte)Long.parseLong((String)value);
                    }
                    catch (Exception e) {
                        return (byte)Double.parseDouble((String)value);
                    }
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).byteValue();
                }
            }
            return ((Number)value).byteValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(-6));
        }
    }

    public static byte[] toBytes(DataWrapper data) throws IncorrectTypeException {
        int type = data.getType();
        if (TypeUtilities.isBinaryType(type)) {
            if (data.isNull()) {
                return null;
            }
            switch (type) {
                case -2: {
                    return data.getBinary();
                }
                case -3: {
                    return data.getVarBinary();
                }
                case -4: {
                    return data.getLongVarBinary();
                }
            }
        }
        throw new IncorrectTypeException();
    }

    public static Date toDate(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.toDate(data, null, warningListener);
    }

    public static Date toDate(DataWrapper data, Calendar cal, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        Object value;
        Date date = TypeConverter.convertToDate(data, cal, warningListener);
        if (!(null == date || (value = data.getObject()) instanceof TimeTz || value instanceof TimestampTz || value instanceof String)) {
            date = CalendarSetter.getDate(date, cal);
        }
        return date;
    }

    public static UUID toGUID(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (-11 == type) {
            return data.getGuid();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, -11)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        Object value = data.getObject();
        try {
            return UUID.fromString((String)value);
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(-11));
        }
    }

    public static double toDouble(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (8 == type) {
            if (data.isNull()) {
                return 0.0;
            }
            return data.getDouble();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 8)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0.0;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1.0;
                    }
                    return 0.0;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return Double.parseDouble(TypeConverter.normalizeInfinityOrNaN((String)value));
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).doubleValue();
                }
            }
            return ((Number)value).doubleValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(8));
        }
    }

    public static float toFloat(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (7 == type) {
            if (data.isNull()) {
                return 0.0f;
            }
            return data.getReal().floatValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 7)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0.0f;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1.0f;
                    }
                    return 0.0f;
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return Float.parseFloat(TypeConverter.normalizeInfinityOrNaN((String)value));
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).floatValue();
                }
            }
            return ((Number)value).floatValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(7));
        }
    }

    public static int toInt(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (4 == type) {
            if (data.isNull()) {
                return 0;
            }
            return data.getInteger().intValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 4)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (int)Long.parseLong(((String)value).trim());
                    }
                    catch (Exception e) {
                        return (int)Double.parseDouble(((String)value).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (int)Long.parseLong((String)value);
                    }
                    catch (Exception e) {
                        return (int)Double.parseDouble((String)value);
                    }
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).intValue();
                }
            }
            return ((Number)value).intValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(4));
        }
    }

    public static Object toInterval(DataWrapper data, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int fromType = data.getType();
        short toType = meta.getType();
        if (TypeUtilities.isIntervalType(fromType) && fromType == toType) {
            if (data.isNull()) {
                return null;
            }
            return data.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, (int)toType)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        Object value = data.getObject();
        try {
            switch (fromType) {
                case -1: 
                case 1: 
                case 12: {
                    return IntervalConverter.convertStringToInterval((String)value, meta, warningListener);
                }
            }
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(4));
        }
        return null;
    }

    public static long toLong(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (-5 == type) {
            if (data.isNull()) {
                return 0L;
            }
            return data.getBigIntAsLong();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, -5)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0L;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1L;
                    }
                    return 0L;
                }
                case -8: 
                case 1: {
                    return new BigDecimal(((String)value).trim()).longValue();
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    return new BigDecimal((String)value).longValue();
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).longValue();
                }
            }
            return ((Number)value).longValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(-5));
        }
    }

    public static BigInteger toBigInteger(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (-5 == type) {
            if (data.isNull()) {
                return BigInteger.ZERO;
            }
            return data.getBigInt();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, -5)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return BigInteger.ZERO;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return BigInteger.ONE;
                    }
                    return BigInteger.ZERO;
                }
                case -8: 
                case 1: {
                    return new BigInteger(((String)value).trim());
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    return new BigInteger((String)value);
                }
                case 2: 
                case 3: {
                    return ((BigDecimal)value).toBigInteger();
                }
            }
            return new BigInteger(((Number)value).toString());
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(-5));
        }
    }

    public static Object toObject(DataWrapper data, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        short type = meta.getType();
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, type, 2000)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            switch (type) {
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    return TypeConverter.toString(data, meta);
                }
                case -5: {
                    return TypeConverter.toLong(data, warningListener);
                }
                case -6: 
                case 4: 
                case 5: {
                    return TypeConverter.toInt(data, warningListener);
                }
                case 6: 
                case 8: {
                    return TypeConverter.toDouble(data, warningListener);
                }
                case 7: {
                    return Float.valueOf(TypeConverter.toFloat(data, warningListener));
                }
                case 2: 
                case 3: {
                    return TypeConverter.toBigDecimal(data, warningListener);
                }
                case 91: {
                    return TypeConverter.toDate(data, warningListener);
                }
                case 92: {
                    return TypeConverter.toTime(data, meta, warningListener);
                }
                case 93: {
                    return TypeConverter.toTimestamp(data, meta, warningListener);
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    return TypeConverter.toInterval(data, meta, warningListener);
                }
                case -11: {
                    return TypeConverter.toGUID(data, warningListener);
                }
                case -7: 
                case 16: {
                    return TypeConverter.toBoolean(data, warningListener);
                }
            }
            return data.getObject();
        }
        catch (IncorrectTypeException e) {
            return null;
        }
    }

    public static short toShort(DataWrapper data, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (5 == type) {
            if (data.isNull()) {
                return 0;
            }
            return data.getSmallInt().shortValue();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 5)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return 0;
        }
        Object value = data.getObject();
        try {
            switch (type) {
                default: {
                    return ((Number)value).shortValue();
                }
                case -7: 
                case 16: {
                    if (((Boolean)value).booleanValue()) {
                        return 1;
                    }
                    return 0;
                }
                case -8: 
                case 1: {
                    try {
                        return (short)Long.parseLong(((String)value).trim());
                    }
                    catch (Exception e) {
                        return (short)Double.parseDouble(((String)value).trim());
                    }
                }
                case -10: 
                case -9: 
                case -1: 
                case 12: {
                    try {
                        return (short)Long.parseLong((String)value);
                    }
                    catch (Exception e) {
                        return (short)Double.parseDouble((String)value);
                    }
                }
                case 2: 
                case 3: 
            }
            return ((BigDecimal)value).shortValue();
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(5));
        }
    }

    public static String toString(DataWrapper data, TypeMetadata meta) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (TypeUtilities.isCharacterType(type)) {
            if (data.isNull()) {
                return null;
            }
            return (String)data.getObject();
        }
        if (type > 1999 && type < 2007 && type != 2003 && type != 2002 && type != 2000 || 70 == type) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        Object value = data.getObject();
        switch (type) {
            case -7: 
            case 16: {
                if (((Boolean)value).booleanValue()) {
                    return "1";
                }
                return "0";
            }
            case -4: 
            case -3: 
            case -2: {
                StringBuilder builder = new StringBuilder();
                byte[] b = (byte[])value;
                for (int i = 0; i < b.length; ++i) {
                    String temp;
                    int intVal = b[i];
                    if (0 > intVal) {
                        intVal += 256;
                    }
                    if (1 == (temp = Integer.toString(intVal, 16).toUpperCase()).length()) {
                        builder.append("0");
                    }
                    builder.append(temp);
                }
                return builder.toString();
            }
            case 2: 
            case 3: {
                return ((BigDecimal)value).toPlainString();
            }
            case 91: {
                return TypeConverter.dateToStringLargeYear((Date)value);
            }
            case 92: {
                char[] buf = new char[]{'0', '0', ':', '0', '0', ':', '0', '0'};
                Calendar cal = null;
                if (value instanceof TimeTz) {
                    TimeTz timeTz = (TimeTz)value;
                    cal = timeTz.getTimezoneCalendar();
                    cal.clear();
                    cal.setTimeInMillis(timeTz.getTime());
                    cal.set(1970, 0, 1);
                    value = new Time(cal.getTimeInMillis());
                    cal.clear();
                }
                Time timeVal = (Time)value;
                int hour = timeVal.getHours();
                int minute = timeVal.getMinutes();
                int second = timeVal.getSeconds();
                buf[0] = (char)(48 + hour / 10);
                buf[1] = (char)(48 + hour % 10);
                buf[3] = (char)(48 + minute / 10);
                buf[4] = (char)(48 + minute % 10);
                buf[6] = (char)(48 + second / 10);
                buf[7] = (char)(48 + second % 10);
                int precision = 0;
                if (meta.getType() == 93 || meta.getType() == 92) {
                    precision = meta.getPrecision();
                }
                if (0 >= precision) {
                    return new String(buf);
                }
                if (3 < precision) {
                    precision = 3;
                }
                if (null == cal) {
                    cal = Calendar.getInstance();
                }
                cal.setTimeInMillis(timeVal.getTime());
                int millis = cal.get(14);
                StringBuilder builder = new StringBuilder(new String(buf));
                builder.append(".000");
                for (int i = 11; i > 8; --i) {
                    builder.setCharAt(i, (char)(48 + millis % 10));
                    millis /= 10;
                }
                return builder.substring(0, 9 + precision);
            }
            case 93: {
                char[] buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0', ' ', '0', '0', ':', '0', '0', ':', '0', '0', '.', '0', '0', '0', '0', '0', '0', '0', '0', '0'};
                Timestamp timestamp = (Timestamp)value;
                int year = timestamp.getYear() + 1900;
                int month = timestamp.getMonth() + 1;
                int day = timestamp.getDate();
                int hour = timestamp.getHours();
                int minute = timestamp.getMinutes();
                int second = timestamp.getSeconds();
                int startIndex = 5;
                if (year > 99999999) {
                    startIndex = 0;
                    buf[0] = (char)(48 + year / 100000000 % 10);
                    buf[1] = (char)(48 + year / 10000000 % 10);
                    buf[2] = (char)(48 + year / 1000000 % 10);
                    buf[3] = (char)(48 + year / 100000 % 10);
                    buf[4] = (char)(48 + year / 10000 % 10);
                    buf[5] = (char)(48 + year / 1000 % 10);
                } else if (year > 9999999) {
                    startIndex = 1;
                    buf[1] = (char)(48 + year / 10000000 % 10);
                    buf[2] = (char)(48 + year / 1000000 % 10);
                    buf[3] = (char)(48 + year / 100000 % 10);
                    buf[4] = (char)(48 + year / 10000 % 10);
                    buf[5] = (char)(48 + year / 1000 % 10);
                } else if (year > 999999) {
                    startIndex = 2;
                    buf[2] = (char)(48 + year / 1000000 % 10);
                    buf[3] = (char)(48 + year / 100000 % 10);
                    buf[4] = (char)(48 + year / 10000 % 10);
                    buf[5] = (char)(48 + year / 1000 % 10);
                } else if (year > 99999) {
                    startIndex = 3;
                    buf[3] = (char)(48 + year / 100000 % 10);
                    buf[4] = (char)(48 + year / 10000 % 10);
                    buf[5] = (char)(48 + year / 1000 % 10);
                } else if (year > 9999) {
                    startIndex = 4;
                    buf[4] = (char)(48 + year / 10000 % 10);
                    buf[5] = (char)(48 + year / 1000 % 10);
                } else {
                    buf[5] = (char)(48 + year / 1000);
                }
                buf[6] = (char)(48 + year / 100 % 10);
                buf[7] = (char)(48 + year / 10 % 10);
                buf[8] = (char)(48 + year % 10);
                buf[10] = (char)(48 + month / 10);
                buf[11] = (char)(48 + month % 10);
                buf[13] = (char)(48 + day / 10);
                buf[14] = (char)(48 + day % 10);
                buf[16] = (char)(48 + hour / 10);
                buf[17] = (char)(48 + hour % 10);
                buf[19] = (char)(48 + minute / 10);
                buf[20] = (char)(48 + minute % 10);
                buf[22] = (char)(48 + second / 10);
                buf[23] = (char)(48 + second % 10);
                short precision = 0;
                if (93 == meta.getType() || 92 == meta.getType()) {
                    precision = meta.getPrecision();
                }
                int endIndex = 24 - startIndex;
                if (0 < precision) {
                    int nanos = timestamp.getNanos();
                    buf[25] = (char)(48 + nanos / 100000000);
                    buf[26] = (char)(48 + nanos / 10000000 % 10);
                    buf[27] = (char)(48 + nanos / 1000000 % 10);
                    buf[28] = (char)(48 + nanos / 100000 % 10);
                    buf[29] = (char)(48 + nanos / 10000 % 10);
                    buf[30] = (char)(48 + nanos / 1000 % 10);
                    buf[31] = (char)(48 + nanos / 100 % 10);
                    buf[32] = (char)(48 + nanos / 10 % 10);
                    buf[33] = (char)(48 + nanos % 10);
                    endIndex = 25 + precision - startIndex;
                }
                Calendar calendar = null;
                calendar = timestamp instanceof TimestampTz ? ((TimestampTz)timestamp).getTimezoneCalendar() : Calendar.getInstance();
                if (timestamp.getTime() < TypeConverter.getZeroTimeAD(calendar)) {
                    return '-' + new String(buf, startIndex, endIndex);
                }
                return new String(buf, startIndex, endIndex);
            }
            case 101: {
                return IntervalConverter.convertIntervalYearToString(value, meta);
            }
            case 102: {
                return IntervalConverter.convertIntervalMonthToString(value, meta);
            }
            case 103: {
                return IntervalConverter.convertIntervalDayToString(value, meta);
            }
            case 104: {
                return IntervalConverter.convertIntervalHourToString(value, meta);
            }
            case 105: {
                return IntervalConverter.convertIntervalMinuteToString(value, meta);
            }
            case 106: {
                return IntervalConverter.convertIntervalSecondToString(value, meta);
            }
            case 107: {
                return IntervalConverter.convertIntervalYearToMonthToString(value, meta);
            }
            case 108: {
                return IntervalConverter.convertIntervalDayToHourToString(value, meta);
            }
            case 109: {
                return IntervalConverter.convertIntervalDayToMinuteToString(value, meta);
            }
            case 110: {
                return IntervalConverter.convertIntervalDayToSecondToString(value, meta);
            }
            case 111: {
                return IntervalConverter.convertIntervalHourToMinuteToString(value, meta);
            }
            case 112: {
                return IntervalConverter.convertIntervalHourToSecondToString(value, meta);
            }
            case 113: {
                return IntervalConverter.convertIntervalMinuteToSecondToString(value, meta);
            }
            case 2003: {
                IArray array = (IArray)value;
                return array.getStringRepresentation();
            }
        }
        return value.toString();
    }

    public static Time toTime(DataWrapper data, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.convertToTime(data, null, meta, warningListener, true);
    }

    public static Time toTime(DataWrapper data, Calendar cal, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        Object value;
        Time time = TypeConverter.convertToTime(data, cal, meta, warningListener, true);
        if (!(null == time || (value = data.getObject()) instanceof TimeTz || value instanceof TimestampTz || time instanceof TimeTz || value instanceof String)) {
            time = CalendarSetter.getTime(time, cal);
        }
        return time;
    }

    public static Timestamp toTimestamp(DataWrapper data, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        return TypeConverter.convertToTimestamp(data, null, meta, warningListener);
    }

    public static Timestamp toTimestamp(DataWrapper data, Calendar cal, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        Timestamp timestamp = TypeConverter.convertToTimestamp(data, cal, meta, warningListener);
        if (null != timestamp) {
            Object value = data.getObject();
            if (!(value instanceof TimeTz || value instanceof TimestampTz || timestamp instanceof TimestampTz || value instanceof String)) {
                timestamp = CalendarSetter.getTimestamp(timestamp, cal);
            }
            if (value instanceof Time) {
                int tsNanos = timestamp.getNanos();
                Calendar local = Calendar.getInstance();
                local.setTimeInMillis(timestamp.getTime());
                local.set(1, 1970);
                local.set(2, 0);
                local.set(5, 1);
                local.set(14, 0);
                timestamp = new Timestamp(local.getTimeInMillis());
                timestamp.setNanos(tsNanos);
            }
        }
        return timestamp;
    }

    @Deprecated
    public static DataWrapper toType(DataWrapper data, int toType, IWarningListener warningListener) throws SQLException, IncorrectTypeException {
        try {
            TypeMetadata toTypeMetadata = TypeMetadata.createTypeMetadata(toType);
            return TypeConverter.toType(data, toTypeMetadata, warningListener);
        }
        catch (ErrorException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, warningListener);
        }
    }

    public static DataWrapper toType(DataWrapper data, Object value, int targetIntSqlType, IWarningListener warningListener) throws SQLException, IncorrectTypeException {
        try {
            int sqltype = TypeConverter.getSqlType(value);
            int precision = 0;
            int scale = 0;
            int intervalPrecision = 0;
            boolean isSigned = false;
            switch (sqltype) {
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    if (!TypeUtilities.isIntegerType(targetIntSqlType) && !TypeUtilities.isExactNumericType(targetIntSqlType)) break;
                    isSigned = true;
                    break;
                }
                case -11: 
                case -7: 
                case -6: 
                case -4: 
                case -3: 
                case -2: 
                case 0: 
                case 16: 
                case 91: 
                case 92: 
                case 93: 
                case 2002: 
                case 2003: {
                    break;
                }
                case -5: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    isSigned = true;
                    break;
                }
                case 2: 
                case 3: {
                    precision = ((BigDecimal)value).precision();
                    scale = ((BigDecimal)value).scale();
                    BigDecimal newValue = TypeConverter.setPrecScale((BigDecimal)value, (short)precision, (short)scale);
                    precision = newValue.precision();
                    scale = newValue.scale();
                    isSigned = true;
                    break;
                }
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: {
                    intervalPrecision = 2;
                }
            }
            TypeMetadata toTypeMetadata = TypeMetadata.createTypeMetadata(targetIntSqlType, (short)precision, (short)scale, intervalPrecision, isSigned);
            return TypeConverter.toType(data, toTypeMetadata, warningListener);
        }
        catch (ErrorException e) {
            throw ExceptionConverter.getInstance().toSQLException(e, warningListener);
        }
    }

    public static DataWrapper toType(DataWrapper data, TypeMetadata toTypeMetadata, IWarningListener warningListener) throws SQLException, IncorrectTypeException {
        short toType = toTypeMetadata.getType();
        DataWrapper convertedData = new DataWrapper();
        switch (toType) {
            case -6: {
                if (toTypeMetadata.isSigned()) {
                    convertedData.setTinyInt(TypeConverter.toByte(data, warningListener));
                    break;
                }
                short result = TypeConverter.toShort(data, warningListener);
                result = (short)((result % 256 + 256) % 256);
                convertedData.setTinyInt(result);
                break;
            }
            case 5: {
                if (toTypeMetadata.isSigned()) {
                    convertedData.setSmallInt(TypeConverter.toShort(data, warningListener));
                    break;
                }
                int result = TypeConverter.toInt(data, warningListener);
                result = (result % 65536 + 65536) % 65536;
                convertedData.setSmallInt(result);
                break;
            }
            case 4: {
                if (toTypeMetadata.isSigned()) {
                    convertedData.setInteger(TypeConverter.toInt(data, warningListener));
                    break;
                }
                long result = TypeConverter.toLong(data, warningListener);
                result = (result % 0x100000000L + 0x100000000L) % 0x100000000L;
                convertedData.setInteger(result);
                break;
            }
            case -5: {
                if (toTypeMetadata.isSigned()) {
                    convertedData.setBigInt(TypeConverter.toLong(data, warningListener));
                    break;
                }
                BigInteger result = TypeConverter.toBigInteger(data, warningListener);
                result = result.mod(TWO_TO_64);
                convertedData.setBigInt(result);
                break;
            }
            case 7: {
                convertedData.setReal(TypeConverter.toFloat(data, warningListener));
                break;
            }
            case 6: {
                convertedData.setFloat(TypeConverter.toDouble(data, warningListener));
                break;
            }
            case 8: {
                convertedData.setDouble(TypeConverter.toDouble(data, warningListener));
                break;
            }
            case 3: {
                BigDecimal bigDec = TypeConverter.toBigDecimal(data, toTypeMetadata, warningListener);
                convertedData.setDecimal(bigDec);
                break;
            }
            case 2: {
                BigDecimal bigDec = TypeConverter.toBigDecimal(data, toTypeMetadata, warningListener);
                convertedData.setNumeric(bigDec);
                break;
            }
            case -7: {
                convertedData.setBit(TypeConverter.toBoolean(data, warningListener));
                break;
            }
            case 16: {
                convertedData.setBoolean(TypeConverter.toBoolean(data, warningListener));
                break;
            }
            case -10: 
            case -9: 
            case -8: 
            case -1: 
            case 1: 
            case 12: {
                convertedData.setData(toType, TypeConverter.toString(data, toTypeMetadata));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                convertedData.setData(toType, TypeConverter.toBytes(data));
                break;
            }
            case 91: {
                convertedData.setDate(TypeConverter.toDate(data, warningListener));
                break;
            }
            case 92: {
                convertedData.setTime(TypeConverter.toTime(data, toTypeMetadata, warningListener));
                break;
            }
            case 93: {
                convertedData.setTimestamp(TypeConverter.toTimestamp(data, toTypeMetadata, warningListener));
                break;
            }
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                convertedData.setInterval(TypeConverter.toInterval(data, toTypeMetadata, warningListener));
                break;
            }
            case -11: {
                convertedData.setGuid(TypeConverter.toGUID(data, warningListener));
                break;
            }
            case 2003: {
                convertedData.setArray(data.getArray());
                break;
            }
            case 2002: {
                if (data.getObject() instanceof Struct) {
                    convertedData.setData(2002, data.getObject());
                    break;
                }
                throw new IncorrectTypeException();
            }
            case 2000: {
                convertedData.setData(2000, data.getObject());
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_DATA_TYPE, warningListener, ExceptionType.DATA, String.valueOf(toType));
            }
        }
        if (data.isNull()) {
            convertedData.setNull(toType);
        }
        return convertedData;
    }

    private static void addOtherConversion() {
        TYPE_CONVERSION_MAP.put(1111, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5419872955240700190L;
            {
                this.add(1111);
                this.add(12);
                this.add(2000);
                this.add(2012);
            }
        });
    }

    private static void addArrayConversions() {
        TYPE_CONVERSION_MAP.put(2003, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -5808381603173623432L;
            {
                this.add(2003);
                this.add(2000);
            }
        });
    }

    private static void addBigDecimalConversions() {
        ArrayList<Integer> conversionList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 1577877504986853963L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(3, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(2, (List<Integer>)conversionList);
    }

    private static void addBlobConversions() {
        TYPE_CONVERSION_MAP.put(2004, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -7731683182785746359L;
            {
                this.add(2004);
                this.add(2000);
            }
        });
    }

    private static void addBooleanConversions() {
        ArrayList<Integer> conversionList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 2301839103144606467L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(-7, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(16, (List<Integer>)conversionList);
    }

    private static void addByteArrayConversions() {
        ArrayList<Integer> conversionList = new ArrayList<Integer>(){
            private static final long serialVersionUID = -1114162276767314579L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(-2);
                this.add(-3);
                this.add(-4);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(-2, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-3, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-4, (List<Integer>)conversionList);
    }

    private static void addByteConversions() {
        TYPE_CONVERSION_MAP.put(-6, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6519746940765096630L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addClobConversions() {
        TYPE_CONVERSION_MAP.put(2005, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6716762231938641114L;
            {
                this.add(2005);
                this.add(2000);
            }
        });
    }

    private static void addDatalinkConversions() {
        TYPE_CONVERSION_MAP.put(70, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 6722890534148572228L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(70);
                this.add(2000);
            }
        });
    }

    private static void addDateConversions() {
        TYPE_CONVERSION_MAP.put(91, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -8309432154352550135L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static void addDoubleConversions() {
        ArrayList<Integer> conversionList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 195745121961923503L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        };
        TYPE_CONVERSION_MAP.put(6, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(8, (List<Integer>)conversionList);
    }

    private static void addFloatConversions() {
        TYPE_CONVERSION_MAP.put(7, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5643763617643704580L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addGUIDConversions() {
        TYPE_CONVERSION_MAP.put(-11, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5643763617823704580L;
            {
                this.add(-11);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntegerConversions() {
        TYPE_CONVERSION_MAP.put(4, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 8345823480060895785L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayConversions() {
        TYPE_CONVERSION_MAP.put(103, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 4866030494371585298L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToHourConversions() {
        TYPE_CONVERSION_MAP.put(108, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -1674137461171786776L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToMinuteConversions() {
        TYPE_CONVERSION_MAP.put(109, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 1604160148277244646L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalDayToSecondConversions() {
        TYPE_CONVERSION_MAP.put(110, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 7503758923848687080L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourConversions() {
        TYPE_CONVERSION_MAP.put(104, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -5527798794271899424L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourToMinuteConversions() {
        TYPE_CONVERSION_MAP.put(111, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 4369576614259490766L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalHourToSecondConversions() {
        TYPE_CONVERSION_MAP.put(112, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -2680238796369792914L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMinuteConversions() {
        TYPE_CONVERSION_MAP.put(105, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -3933329123374503084L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMinuteToSecondConversions() {
        TYPE_CONVERSION_MAP.put(113, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 8410562587770552421L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalMonthConversions() {
        TYPE_CONVERSION_MAP.put(102, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -4032100586168037610L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalSecondConversions() {
        TYPE_CONVERSION_MAP.put(106, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 7482252078605327034L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalYearConversions() {
        TYPE_CONVERSION_MAP.put(101, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 3319575356233198861L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addIntervalYearToMonthConversions() {
        TYPE_CONVERSION_MAP.put(107, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -9112026322270541556L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addLongConversions() {
        TYPE_CONVERSION_MAP.put(-5, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 360724167690817441L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addObjectConversions() {
        TYPE_CONVERSION_MAP.put(2000, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5419872955240700190L;
            {
                this.add(2000);
            }
        });
    }

    private static void addRefConversions() {
        TYPE_CONVERSION_MAP.put(2006, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6712233574615351824L;
            {
                this.add(2006);
                this.add(2000);
            }
        });
    }

    private static void addShortConversions() {
        TYPE_CONVERSION_MAP.put(5, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 6565711157919530708L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(2000);
            }
        });
    }

    private static void addStringConversions() {
        ArrayList<Integer> conversionList = new ArrayList<Integer>(){
            private static final long serialVersionUID = 8390603353416789286L;
            {
                this.add(-6);
                this.add(5);
                this.add(4);
                this.add(-5);
                this.add(7);
                this.add(6);
                this.add(8);
                this.add(3);
                this.add(2);
                this.add(-7);
                this.add(16);
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(92);
                this.add(93);
                this.add(2000);
                this.add(-8);
                this.add(-9);
                this.add(-10);
                this.add(103);
                this.add(108);
                this.add(109);
                this.add(110);
                this.add(104);
                this.add(111);
                this.add(112);
                this.add(105);
                this.add(113);
                this.add(102);
                this.add(106);
                this.add(101);
                this.add(107);
                this.add(-11);
            }
        };
        TYPE_CONVERSION_MAP.put(1, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(12, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-1, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-8, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-9, (List<Integer>)conversionList);
        TYPE_CONVERSION_MAP.put(-10, (List<Integer>)conversionList);
    }

    private static void addStructConversions() {
        TYPE_CONVERSION_MAP.put(2002, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 5758877648898297886L;
            {
                this.add(2002);
                this.add(2000);
            }
        });
    }

    private static void addTimeConversions() {
        TYPE_CONVERSION_MAP.put(92, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = -6865504919287790919L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(92);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static void addTimestampConversions() {
        TYPE_CONVERSION_MAP.put(93, (List<Integer>)new ArrayList<Integer>(){
            private static final long serialVersionUID = 2573081359751242726L;
            {
                this.add(1);
                this.add(12);
                this.add(-1);
                this.add(91);
                this.add(92);
                this.add(93);
                this.add(2000);
            }
        });
    }

    private static boolean canConvertFrom(Map<Integer, List<Integer>> conversionMap, int fromType, int toType) {
        List<Integer> toTypes = conversionMap.get(fromType);
        if (null == toTypes) {
            return false;
        }
        return toTypes.contains(toType);
    }

    private static boolean canConvertFrom(Map<Integer, List<Integer>> conversionMap, DataWrapper data, int toType) {
        int fromType = data.getType();
        if (2000 == fromType) {
            fromType = TypeConverter.getSqlType(data.getObject());
        }
        return TypeConverter.canConvertFrom(conversionMap, fromType, toType);
    }

    private static Date convertToDate(DataWrapper data, Calendar cal, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (91 == type) {
            if (data.isNull()) {
                return null;
            }
            return (Date)data.getObject();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 91)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            switch (type) {
                case 93: {
                    Object obj = data.getObject();
                    if (obj instanceof TimestampTz) {
                        TimestampTz tz = (TimestampTz)obj;
                        Calendar c = tz.getTimezoneCalendar();
                        c.clear();
                        c.setTimeInMillis(tz.getTime());
                        c.set(11, 0);
                        c.set(12, 0);
                        c.set(13, 0);
                        c.set(14, 0);
                        return new Date(c.getTimeInMillis());
                    }
                    return new Date(data.getTimestamp().getTime());
                }
            }
            if (null == cal) {
                cal = Calendar.getInstance();
            }
            String stringValue = TypeConverter.toString(data, null);
            int timeSeparatorIndex = stringValue.indexOf(58);
            Date result = null;
            if (-1 != timeSeparatorIndex) {
                result = new Date(StringConverter.parseTimestamp(stringValue, new GregorianCalendar(null == cal ? TimeZone.getDefault() : cal.getTimeZone())).getTime());
            } else {
                result = StringConverter.parseDate(stringValue, new GregorianCalendar(null == cal ? TimeZone.getDefault() : cal.getTimeZone()));
                if (null == result) {
                    throw new IllegalArgumentException();
                }
            }
            cal.clear();
            cal.setTimeInMillis(result.getTime());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return new Date(cal.getTimeInMillis());
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(91));
        }
    }

    private static Time convertToTime(DataWrapper data, Calendar calendar, TypeMetadata meta, IWarningListener warningListener, boolean truncate) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (92 == type) {
            if (data.isNull()) {
                return null;
            }
            return data.getTime();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 92)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            Date date;
            String dateString;
            int firstSpaceIndex;
            switch (type) {
                case 91: {
                    Date d = data.getDate();
                    if (truncate) {
                        Calendar c = Calendar.getInstance();
                        c.setTimeInMillis(d.getTime());
                        c.set(1970, 0, 1);
                        return new Time(c.getTimeInMillis());
                    }
                    return new Time(d.getTime());
                }
                case 93: {
                    TimestampTz ts = data.getTimestampTz();
                    if (truncate) {
                        Calendar c = ts.getTimezoneCalendar();
                        c.clear();
                        c.setTimeInMillis(ts.getTime());
                        c.set(1970, 0, 1);
                        return new Time(c.getTimeInMillis());
                    }
                    return new Time(ts.getTime());
                }
            }
            if (null == calendar) {
                calendar = Calendar.getInstance();
            }
            if (-1 != (firstSpaceIndex = (dateString = TypeConverter.toString(data, meta).trim()).indexOf(32)) && null != (date = StringConverter.parseDate(dateString.substring(0, firstSpaceIndex), new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone())))) {
                dateString = dateString.substring(firstSpaceIndex + 1);
            }
            int length = dateString.length();
            int fractionPos = dateString.indexOf(46);
            int timeZonePos = dateString.indexOf(32);
            if (-1 == timeZonePos && -1 == (timeZonePos = dateString.indexOf(43))) {
                timeZonePos = dateString.indexOf(45);
            }
            int endTime = -1 == fractionPos ? (-1 == timeZonePos ? length : timeZonePos) : fractionPos;
            Time timeVal = StringConverter.parseTime(dateString.substring(0, endTime), new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
            if (endTime != length) {
                if (0 < fractionPos) {
                    int fracSize = 3;
                    int endFrac = length;
                    if (timeZonePos > 0) {
                        endFrac = timeZonePos;
                    }
                    if (fractionPos + 3 >= endFrac) {
                        fracSize = endFrac - fractionPos - 1;
                    }
                    if (0 == fracSize) {
                        throw new IllegalArgumentException();
                    }
                    int fraction = StringConverter.parseInt(dateString, fractionPos + 1, fractionPos + fracSize + 1);
                    while (fracSize++ < 3) {
                        fraction *= 10;
                    }
                    timeVal.setTime(timeVal.getTime() + (long)fraction);
                }
                if (0 < timeZonePos) {
                    timeVal = TypeConverter.convertToTimeTz(timeVal, dateString.substring(timeZonePos, length));
                }
            }
            calendar.clear();
            calendar.setTimeInMillis(timeVal.getTime());
            if (truncate) {
                calendar.set(1970, 0, 1);
            }
            return new Time(calendar.getTimeInMillis());
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(92));
        }
    }

    private static Timestamp convertToTimestamp(DataWrapper data, Calendar calendar, TypeMetadata meta, IWarningListener warningListener) throws IncorrectTypeException, SQLException {
        int type = data.getType();
        if (93 == type) {
            if (data.isNull()) {
                return null;
            }
            return data.getTimestamp();
        }
        if (!TypeConverter.canConvertFrom(TYPE_CONVERSION_MAP, data, 93)) {
            throw new IncorrectTypeException();
        }
        if (data.isNull()) {
            return null;
        }
        try {
            switch (type) {
                case 91: {
                    return new Timestamp(data.getDate().getTime());
                }
                case 92: {
                    return new Timestamp(data.getTime().getTime());
                }
                case -10: 
                case -9: 
                case -8: 
                case -1: 
                case 1: 
                case 12: {
                    String value = (String)data.getObject();
                    boolean datePresent = value.contains("-");
                    boolean timePresent = value.contains(":");
                    if (datePresent && timePresent) {
                        return StringConverter.parseTimestamp(value, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
                    }
                    if (datePresent) {
                        Date date = StringConverter.parseDate(value, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
                        if (null == date) {
                            throw new IllegalArgumentException();
                        }
                        return new Timestamp(date.getTime());
                    }
                    if (timePresent) {
                        Time time = TypeConverter.convertToTime(data, calendar, meta, warningListener, false);
                        if (time instanceof TimeTz) {
                            time = ((TimeTz)time).getAdjustedTime();
                        }
                        Timestamp result = new Timestamp(time.getTime());
                        int fracSepIndex = value.indexOf(46);
                        if (-1 != fracSepIndex) {
                            char ch;
                            int strLen = value.length();
                            int fracEnd = fracSepIndex;
                            while (++fracEnd < strLen && (ch = value.charAt(fracEnd)) >= '0' && ch <= '9') {
                            }
                            int fracSecLen = fracEnd - fracSepIndex - 1;
                            if (fracSecLen <= 3) {
                                return result;
                            }
                            if (fracSecLen > 9) {
                                throw new IllegalArgumentException();
                            }
                            int fractionalSeconds = StringConverter.parseInt(value, fracSepIndex + 1, fracEnd);
                            result.setNanos(fractionalSeconds *= StringConverter.s_fractionalMultiplier[fracSecLen]);
                        }
                        return result;
                    }
                    throw new IllegalArgumentException();
                }
            }
            String dateString = TypeConverter.toString(data, meta);
            return StringConverter.parseTimestamp(dateString, new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone()));
        }
        catch (Throwable e) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CONVERT_TO_ERR, warningListener, ExceptionType.DATA, TypeNames.getTypeName(93));
        }
    }

    private static TimeTz convertToTimeTz(Time timeVal, String timeZone) {
        String processedTz = timeZone.trim();
        if (!Character.isLetter(processedTz.charAt(0))) {
            if (Character.isDigit(processedTz.charAt(0))) {
                processedTz = "+" + processedTz;
            }
            processedTz = "GMT" + processedTz;
        }
        TimeZone tz = TimeZone.getTimeZone(processedTz);
        Calendar tzCal = Calendar.getInstance(tz);
        timeVal = CalendarSetter.getTime(timeVal, tzCal);
        return new TimeTz(timeVal, tzCal);
    }

    private static void initializeClassToTypeMap() {
        CLASS_TO_TYPE_MAP.put(BigDecimal.class, 3);
        CLASS_TO_TYPE_MAP.put(BigInteger.class, -5);
        CLASS_TO_TYPE_MAP.put(byte[].class, -2);
        CLASS_TO_TYPE_MAP.put(Byte.class, -6);
        CLASS_TO_TYPE_MAP.put(ByteArrayInputStream.class, -2);
        CLASS_TO_TYPE_MAP.put(Boolean.class, -7);
        CLASS_TO_TYPE_MAP.put(Date.class, 91);
        CLASS_TO_TYPE_MAP.put(Double.class, 8);
        CLASS_TO_TYPE_MAP.put(Float.class, 7);
        CLASS_TO_TYPE_MAP.put(Integer.class, 4);
        CLASS_TO_TYPE_MAP.put(Long.class, -5);
        CLASS_TO_TYPE_MAP.put(Short.class, 5);
        CLASS_TO_TYPE_MAP.put(String.class, 1);
        CLASS_TO_TYPE_MAP.put(StringReader.class, 1);
        CLASS_TO_TYPE_MAP.put(Time.class, 92);
        CLASS_TO_TYPE_MAP.put(Timestamp.class, 93);
        CLASS_TO_TYPE_MAP.put(UUID.class, -11);
        CLASS_TO_TYPE_MAP.put(java.util.Date.class, 93);
        CLASS_TO_TYPE_MAP.put(Calendar.class, 93);
    }

    private static String normalizeInfinityOrNaN(String data) {
        String value = NORMALIZE_DOUBLE_OR_FLOAT_MAP.get(data.toUpperCase());
        if (value != null) {
            return value;
        }
        return data;
    }

    private static BigDecimal rescaleBigDecimal(BigDecimal bigDec, int scale, IWarningListener warningListener) {
        int bigDecScale = bigDec.scale();
        if (bigDecScale == scale) {
            return bigDec;
        }
        BigDecimal rescaledBigDec = bigDec.setScale(scale, 4);
        if (0 != bigDec.compareTo(rescaledBigDec)) {
            warningListener.postWarning(new Warning(WarningCode.FRACTIONAL_TRUNCATION, 1, JDBCMessageKey.WARN_FRACTIONAL_TRUNC.name()));
        }
        return rescaledBigDec;
    }

    private static void addPairsToNormalDoubleOrFloatMap() {
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("INF", "Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+INF", "+Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-INF", "-Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("INFINITY", "Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+INFINITY", "+Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-INFINITY", "-Infinity");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("NAN", "NaN");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("+NAN", "NaN");
        NORMALIZE_DOUBLE_OR_FLOAT_MAP.put("-NAN", "NaN");
    }

    private static long getZeroTimeAD(Calendar calendar) {
        GregorianCalendar gCal = new GregorianCalendar(null == calendar ? TimeZone.getDefault() : calendar.getTimeZone());
        gCal.clear();
        gCal.set(1, 0, 1, 0, 0, 0);
        return gCal.getTimeInMillis();
    }

    public static BigDecimal setPrecScale(BigDecimal input, short precision, short scale) {
        int targetIntPrec;
        if (precision < 1 || scale > precision || scale < 0) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        Pair<Short, Short> sourcePrecScale = TypeConverter.calculateSQLPrecisionScale(input);
        int sourceIntPrec = sourcePrecScale.key() - sourcePrecScale.value();
        if (sourceIntPrec > (targetIntPrec = precision - scale)) {
            if (input.compareTo(BigDecimal.ZERO) < 0) {
                throw new IllegalArgumentException("Invalid precision scale");
            }
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (sourcePrecScale.value() <= scale) {
            return input;
        }
        BigDecimal ret = input.setScale((int)scale, RoundingMode.DOWN);
        return ret;
    }

    public static Pair<Short, Short> calculateSQLPrecisionScale(BigDecimal data) {
        int sourcePrec;
        if (data.compareTo(BigDecimal.ZERO) == 0) {
            return new Pair<Short, Short>((short)1, (short)0);
        }
        int sourceScale = data.scale() < 0 ? 0 : data.scale();
        int n = sourcePrec = data.scale() < 0 ? data.precision() - data.scale() : data.precision();
        if (0 > sourcePrec || Short.MAX_VALUE < sourcePrec) {
            throw new IllegalArgumentException("Invalid precision scale");
        }
        if (Short.MAX_VALUE < sourceScale) {
            sourceScale = Short.MAX_VALUE;
        }
        return new Pair<Short, Short>((short)sourcePrec, (short)sourceScale);
    }

    public static String dateToStringLargeYear(Date value) {
        int year = value.getYear() + 1900;
        int month = value.getMonth() + 1;
        int day = value.getDate();
        char[] buf = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '-', '0', '0', '-', '0', '0'};
        int startIndex = 5;
        if (year > 99999999) {
            startIndex = 0;
            buf[0] = (char)(48 + year / 100000000 % 10);
            buf[1] = (char)(48 + year / 10000000 % 10);
            buf[2] = (char)(48 + year / 1000000 % 10);
            buf[3] = (char)(48 + year / 100000 % 10);
            buf[4] = (char)(48 + year / 10000 % 10);
            buf[5] = (char)(48 + year / 1000 % 10);
        } else if (year > 9999999) {
            startIndex = 1;
            buf[1] = (char)(48 + year / 10000000 % 10);
            buf[2] = (char)(48 + year / 1000000 % 10);
            buf[3] = (char)(48 + year / 100000 % 10);
            buf[4] = (char)(48 + year / 10000 % 10);
            buf[5] = (char)(48 + year / 1000 % 10);
        } else if (year > 999999) {
            startIndex = 2;
            buf[2] = (char)(48 + year / 1000000 % 10);
            buf[3] = (char)(48 + year / 100000 % 10);
            buf[4] = (char)(48 + year / 10000 % 10);
            buf[5] = (char)(48 + year / 1000 % 10);
        } else if (year > 99999) {
            startIndex = 3;
            buf[3] = (char)(48 + year / 100000 % 10);
            buf[4] = (char)(48 + year / 10000 % 10);
            buf[5] = (char)(48 + year / 1000 % 10);
        } else if (year > 9999) {
            startIndex = 4;
            buf[4] = (char)(48 + year / 10000 % 10);
            buf[5] = (char)(48 + year / 1000 % 10);
        } else {
            buf[5] = (char)(48 + year / 1000);
        }
        buf[6] = (char)(48 + year / 100 % 10);
        buf[7] = (char)(48 + year / 10 % 10);
        buf[8] = (char)(48 + year % 10);
        buf[10] = (char)(48 + month / 10);
        buf[11] = (char)(48 + month % 10);
        buf[13] = (char)(48 + day / 10);
        buf[14] = (char)(48 + day % 10);
        if (value.getTime() < TypeConverter.getZeroTimeAD(Calendar.getInstance())) {
            return '-' + new String(buf, startIndex, 15 - startIndex);
        }
        return new String(buf, startIndex, 15 - startIndex);
    }

    public static Object[] convertToObjectArray(Object array) throws IncorrectTypeException {
        Class<?> ofArray = array.getClass().getComponentType();
        if (ofArray == null) {
            throw new IncorrectTypeException();
        }
        if (ofArray.isPrimitive()) {
            ArrayList<Object> ar = new ArrayList<Object>();
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                ar.add(Array.get(array, i));
            }
            return ar.toArray();
        }
        return (Object[])array;
    }

    static {
        CLASS_TO_TYPE_MAP = new HashMap();
        TypeConverter.initializeClassToTypeMap();
        TYPE_CONVERSION_MAP = new HashMap<Integer, List<Integer>>();
        NORMALIZE_DOUBLE_OR_FLOAT_MAP = new HashMap<String, String>();
        TypeConverter.addByteConversions();
        TypeConverter.addShortConversions();
        TypeConverter.addIntegerConversions();
        TypeConverter.addLongConversions();
        TypeConverter.addFloatConversions();
        TypeConverter.addDoubleConversions();
        TypeConverter.addBigDecimalConversions();
        TypeConverter.addBooleanConversions();
        TypeConverter.addStringConversions();
        TypeConverter.addByteArrayConversions();
        TypeConverter.addDateConversions();
        TypeConverter.addTimeConversions();
        TypeConverter.addTimestampConversions();
        TypeConverter.addGUIDConversions();
        TypeConverter.addClobConversions();
        TypeConverter.addBlobConversions();
        TypeConverter.addRefConversions();
        TypeConverter.addDatalinkConversions();
        TypeConverter.addArrayConversions();
        TypeConverter.addStructConversions();
        TypeConverter.addObjectConversions();
        TypeConverter.addIntervalDayConversions();
        TypeConverter.addIntervalDayToHourConversions();
        TypeConverter.addIntervalDayToMinuteConversions();
        TypeConverter.addIntervalDayToSecondConversions();
        TypeConverter.addIntervalHourConversions();
        TypeConverter.addIntervalHourToMinuteConversions();
        TypeConverter.addIntervalHourToSecondConversions();
        TypeConverter.addIntervalMinuteConversions();
        TypeConverter.addIntervalMinuteToSecondConversions();
        TypeConverter.addIntervalMonthConversions();
        TypeConverter.addIntervalSecondConversions();
        TypeConverter.addIntervalYearConversions();
        TypeConverter.addIntervalYearToMonthConversions();
        TypeConverter.addPairsToNormalDoubleOrFloatMap();
        TypeConverter.addOtherConversion();
        TWO_TO_64 = new BigInteger("18446744073709551616");
        STREAM_FROM_CONVERSION_MAP = new HashMap<Integer, List<Integer>>(){
            private static final long serialVersionUID = 131682938025320073L;
            {
                this.put(1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7240274558857187054L;
                    {
                        this.add(-1);
                    }
                });
                this.put(12, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 2714265807427510204L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 224991913801084918L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-2, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -3032857584866793994L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
                this.put(-8, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7240274558826187054L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-9, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 2714265991427510204L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-10, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 226991913301084918L;
                    {
                        this.add(-1);
                    }
                });
                this.put(-3, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 7317673487611447914L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
                this.put(-4, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 3254144638476462886L;
                    {
                        this.add(-1);
                        this.add(-4);
                    }
                });
            }
        };
        STREAM_TO_CONVERSION_MAP = new HashMap<Integer, List<Integer>>(){
            private static final long serialVersionUID = 3124019339494993466L;
            {
                this.put(1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(12, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-1, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-8, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-9, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-10, new ArrayList<Integer>(){
                    private static final long serialVersionUID = 6484643743691109517L;
                    {
                        this.add(1);
                        this.add(12);
                        this.add(-1);
                        this.add(-8);
                        this.add(-9);
                        this.add(-10);
                    }
                });
                this.put(-2, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
                this.put(-3, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
                this.put(-4, new ArrayList<Integer>(){
                    private static final long serialVersionUID = -8069855771950595180L;
                    {
                        this.add(-2);
                        this.add(-3);
                        this.add(-4);
                    }
                });
            }
        };
    }
}

