/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.streams.parameters;

import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.exceptions.InputOutputException;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.streams.parameters.AbstractParameterStream;
import java.io.IOException;
import java.io.InputStream;

public class UnicodeParameterStream
extends AbstractParameterStream {
    public UnicodeParameterStream(InputStream stream, int streamLength) {
        super(stream, streamLength);
    }

    @Deprecated
    public UnicodeParameterStream(InputStream stream, int streamLength, ParameterMetadata paramMeta, int type) {
        super(stream, streamLength, paramMeta, type);
    }

    @Override
    public ParameterInputValue getNextValue() throws IOException {
        if (this.isClosed()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CLOSED.name());
        }
        if (!this.hasMoreData()) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_EMPTY.name());
        }
        if (null == this.m_parameterMetadata) {
            throw new InputOutputException(1, JDBCMessageKey.NULL_PARAM_METADATA.name());
        }
        if (!this.m_valuesPushed) {
            this.m_valuesPushed = true;
        }
        int numCharsToFetch = this.getNumToFetch();
        byte[] buffer = new byte[numCharsToFetch];
        int numBytesRead = this.m_stream.read(buffer);
        this.m_numRead += (long)numBytesRead;
        DataWrapper data = new DataWrapper();
        if (-1L != this.m_streamLength) {
            if (-1 == numBytesRead) {
                throw new InputOutputException(1, JDBCMessageKey.STREAM_UNEXPECTED_END.name());
            }
        } else {
            this.m_lastChunkReadSize = numBytesRead;
            if (numBytesRead < buffer.length && -1 != numBytesRead) {
                byte[] temp = new byte[numBytesRead];
                System.arraycopy(buffer, 0, temp, 0, numBytesRead);
                buffer = temp;
                this.m_lastChunkReadSize = -1L;
            } else if (-1 == numBytesRead) {
                buffer = new byte[]{};
            }
        }
        try {
            if (12 == this.m_parameterMetadata.getTypeMetadata().getType()) {
                data.setVarChar(new String(buffer, "UTF-8"));
            } else {
                data.setLongVarChar(new String(buffer, "UTF-8"));
            }
        }
        catch (Exception e) {
            throw new InputOutputException(1, JDBCMessageKey.STREAM_CORRUPT_UTF.name());
        }
        return new ParameterInputValue(this.m_parameterMetadata, data);
    }
}

