/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc42;

import com.vertica.jdbc.jdbc42.S42PooledConnection;
import com.vertica.jdbc.jdbc42.S42PreparedStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class S42PreparedStatementHandle
implements PreparedStatement {
    private S42PreparedStatement m_preparedStatement;
    private S42PooledConnection m_pooledConnection;

    public S42PreparedStatementHandle(S42PooledConnection connection, S42PreparedStatement statement) {
        this.m_pooledConnection = connection;
        this.m_preparedStatement = statement;
    }

    @Override
    public synchronized void addBatch() throws SQLException {
        try {
            this.m_preparedStatement.addBatch();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void addBatch(String sql) throws SQLException {
        try {
            this.m_preparedStatement.addBatch(sql);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void cancel() throws SQLException {
        try {
            this.m_preparedStatement.cancel();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void clearBatch() throws SQLException {
        try {
            this.m_preparedStatement.clearBatch();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void clearParameters() throws SQLException {
        try {
            this.m_preparedStatement.clearParameters();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            this.m_preparedStatement.clearWarnings();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        this.m_preparedStatement.close();
        this.m_pooledConnection.onHandleStatementClose(this.m_preparedStatement);
    }

    @Override
    public synchronized boolean execute() throws SQLException {
        try {
            return this.m_preparedStatement.execute();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql) throws SQLException {
        try {
            return this.m_preparedStatement.execute(sql);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.m_preparedStatement.execute(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.m_preparedStatement.execute(sql, columnIndexes);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            return this.m_preparedStatement.execute(sql, columnNames);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            return this.m_preparedStatement.executeBatch();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized ResultSet executeQuery() throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized ResultSet executeQuery(String sql) throws SQLException {
        try {
            return this.m_preparedStatement.executeQuery(sql);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate() throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(sql);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.m_preparedStatement.executeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            return this.m_preparedStatement.getConnection();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int getFetchDirection() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchDirection();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized int getFetchSize() throws SQLException {
        try {
            return this.m_preparedStatement.getFetchSize();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        try {
            return this.m_preparedStatement.getGeneratedKeys();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxFieldSize();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getMaxRows() throws SQLException {
        try {
            return this.m_preparedStatement.getMaxRows();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getMetaData();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized boolean getMoreResults(int current) throws SQLException {
        try {
            return this.m_preparedStatement.getMoreResults(current);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        try {
            return this.m_preparedStatement.getParameterMetaData();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        try {
            return this.m_preparedStatement.getQueryTimeout();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSet();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetConcurrency();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetHoldability();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getResultSetType() throws SQLException {
        try {
            return this.m_preparedStatement.getResultSetType();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public int getUpdateCount() throws SQLException {
        try {
            return this.m_preparedStatement.getUpdateCount();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            return this.m_preparedStatement.getWarnings();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.m_preparedStatement.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        try {
            return this.m_preparedStatement.isPoolable();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.m_preparedStatement.isWrapperFor(iface);
    }

    @Override
    public synchronized void setArray(int parameterIndex, Array value) throws SQLException {
        try {
            this.m_preparedStatement.setArray(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setAsciiStream(parameterIndex, x);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setAsciiStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(parameterIndex, value, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.m_preparedStatement.setAsciiStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
        try {
            this.m_preparedStatement.setBigDecimal(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBinaryStream(parameterIndex, x);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setBinaryStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(parameterIndex, value, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        try {
            this.m_preparedStatement.setBinaryStream(parameterIndex, x, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setBlob(int parameterIndex, Blob value) throws SQLException {
        try {
            this.m_preparedStatement.setBlob(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBlob(parameterIndex, x);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setBlob(parameterIndex, inputStream, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setBoolean(int parameterIndex, boolean value) throws SQLException {
        try {
            this.m_preparedStatement.setBoolean(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setByte(int parameterIndex, byte value) throws SQLException {
        try {
            this.m_preparedStatement.setByte(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setBytes(int parameterIndex, byte[] value) throws SQLException {
        try {
            this.m_preparedStatement.setBytes(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setCharacterStream(parameterIndex, reader);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        try {
            this.m_preparedStatement.setCharacterStream(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setClob(int parameterIndex, Clob value) throws SQLException {
        try {
            this.m_preparedStatement.setClob(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setClob(parameterIndex, reader);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setClob(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        try {
            this.m_preparedStatement.setCursorName(name);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date value) throws SQLException {
        try {
            this.m_preparedStatement.setDate(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setDate(int parameterIndex, Date value, Calendar cal) throws SQLException {
        try {
            this.m_preparedStatement.setDate(parameterIndex, value, cal);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setDouble(int parameterIndex, double value) throws SQLException {
        try {
            this.m_preparedStatement.setDouble(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            this.m_preparedStatement.setEscapeProcessing(enable);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setFetchDirection(int direction) throws SQLException {
        try {
            this.m_preparedStatement.setFetchDirection(direction);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setFetchSize(int rows) throws SQLException {
        try {
            this.m_preparedStatement.setFetchSize(rows);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setFloat(int parameterIndex, float value) throws SQLException {
        try {
            this.m_preparedStatement.setFloat(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setInt(int parameterIndex, int value) throws SQLException {
        try {
            this.m_preparedStatement.setInt(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setLong(int parameterIndex, long value) throws SQLException {
        try {
            this.m_preparedStatement.setLong(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            this.m_preparedStatement.setMaxFieldSize(max);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        try {
            this.m_preparedStatement.setMaxRows(max);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNCharacterStream(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNCharacterStream(parameterIndex, value, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(parameterIndex, reader);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNClob(parameterIndex, reader, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setNString(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType) throws SQLException {
        try {
            this.m_preparedStatement.setNull(parameterIndex, sqlType);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        try {
            this.m_preparedStatement.setNull(parameterIndex, sqlType, typeName);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value) throws SQLException {
        try {
            this.m_preparedStatement.setObject(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, int targetSqlType) throws SQLException {
        try {
            this.m_preparedStatement.setObject(parameterIndex, value, targetSqlType);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        try {
            this.m_preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object value, SQLType targetSqlType) throws SQLException {
        try {
            this.m_preparedStatement.setObject(parameterIndex, value, targetSqlType);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scale) throws SQLException {
        try {
            this.m_preparedStatement.setObject(parameterIndex, x, targetSqlType, scale);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            this.m_preparedStatement.setPoolable(poolable);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            this.m_preparedStatement.setQueryTimeout(seconds);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setRef(int parameterIndex, Ref value) throws SQLException {
        try {
            this.m_preparedStatement.setRef(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setRowId(parameterIndex, x);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setShort(int parameterIndex, short value) throws SQLException {
        try {
            this.m_preparedStatement.setShort(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException, SQLFeatureNotSupportedException {
        try {
            this.m_preparedStatement.setSQLXML(parameterIndex, xmlObject);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setString(int parameterIndex, String value) throws SQLException {
        try {
            this.m_preparedStatement.setString(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time value) throws SQLException {
        try {
            this.m_preparedStatement.setTime(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
        try {
            this.m_preparedStatement.setTime(parameterIndex, value, cal);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
        try {
            this.m_preparedStatement.setTimestamp(parameterIndex, value, cal);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setUnicodeStream(int parameterIndex, InputStream value, int length) throws SQLException {
        try {
            this.m_preparedStatement.setUnicodeStream(parameterIndex, value, length);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public synchronized void setURL(int parameterIndex, URL value) throws SQLException {
        try {
            this.m_preparedStatement.setURL(parameterIndex, value);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.m_preparedStatement.unwrap(iface);
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        try {
            this.m_preparedStatement.closeOnCompletion();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        try {
            return this.m_preparedStatement.isCloseOnCompletion();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long[] executeLargeBatch() throws SQLException, BatchUpdateException {
        try {
            return this.m_preparedStatement.executeLargeBatch();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        try {
            return this.m_preparedStatement.executeLargeUpdate();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        try {
            return this.m_preparedStatement.getLargeUpdateCount();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        try {
            return this.m_preparedStatement.executeLargeUpdate(sql);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            return this.m_preparedStatement.executeLargeUpdate(sql, autoGeneratedKeys);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            return this.m_preparedStatement.executeLargeUpdate(sql, columnIndexes);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            return this.m_preparedStatement.executeLargeUpdate(sql, columnNames);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        try {
            return this.m_preparedStatement.getLargeMaxRows();
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        try {
            this.m_preparedStatement.setLargeMaxRows(max);
        }
        catch (SQLException e) {
            if (this.m_preparedStatement.isClosed()) {
                this.m_pooledConnection.onHandleStatementError(this.m_preparedStatement, e);
            }
            throw e;
        }
    }
}

