/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc;

import com.vertica.core.VConnection;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.jdbc.VerticaConnection;
import com.vertica.jdbc.VerticaConnectionSharedImpl;
import com.vertica.jdbc.VerticaDatabaseErrorInfo;
import com.vertica.jdbc.jdbc41.S41Connection;
import com.vertica.support.LogUtilities;
import java.sql.SQLException;

public class VerticaJdbc41ConnectionImpl
extends S41Connection
implements VerticaConnection {
    protected VConnection m_vconn;

    protected VerticaJdbc41ConnectionImpl(IConnection iConnection, String string) throws SQLException {
        super(iConnection, string);
        LogUtilities.logFunctionEntrance(iConnection.getConnectionLog(), iConnection, string);
        this.m_vconn = (VConnection)iConnection;
    }

    @Override
    public Object getProperty(String string) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        return VerticaConnectionSharedImpl.getInstance().getProperty(this.m_vconn, string);
    }

    @Override
    public void setProperty(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), string);
        VerticaConnectionSharedImpl.getInstance().setProperty(this.m_vconn, string, object);
    }

    @Override
    public VerticaDatabaseErrorInfo getLastDatabaseError() {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        return VerticaConnectionSharedImpl.getInstance().getLastDatabaseError(this.m_vconn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.commit();
        }
        finally {
            this.m_vconn.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_vconn.getConnectionLog(), new Object[0]);
        this.m_vconn.lock();
        try {
            super.rollback();
        }
        finally {
            this.m_vconn.unlock();
        }
    }

    @Override
    public void setSchema(String string) throws SQLException {
        throw VerticaConnectionSharedImpl.getInstance().getNotSupportedExc(this.m_vconn);
    }

    @Override
    public String getSchema() throws SQLException {
        throw VerticaConnectionSharedImpl.getInstance().getNotSupportedExc(this.m_vconn);
    }
}

