/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dataengine;

import com.vertica.core.VConnection;
import com.vertica.core.VDriver;
import com.vertica.core.VStatement;
import com.vertica.dataengine.ColumnDescription;
import com.vertica.dataengine.VCopyStreamExecutionContext;
import com.vertica.dataengine.VCopyStreamExecutionContexts;
import com.vertica.dataengine.VResultSet;
import com.vertica.dsi.core.impl.DSILogger;
import com.vertica.dsi.dataengine.impl.DSIErrorResult;
import com.vertica.dsi.dataengine.impl.DSISimpleRowCountResult;
import com.vertica.dsi.dataengine.interfaces.IQueryExecutor;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.ExecutionContext;
import com.vertica.dsi.dataengine.utilities.ExecutionContextStatus;
import com.vertica.dsi.dataengine.utilities.ExecutionContexts;
import com.vertica.dsi.dataengine.utilities.ExecutionResult;
import com.vertica.dsi.dataengine.utilities.ExecutionResults;
import com.vertica.dsi.dataengine.utilities.ParameterInputValue;
import com.vertica.dsi.dataengine.utilities.ParameterMetadata;
import com.vertica.dsi.dataengine.utilities.TypeMetadata;
import com.vertica.dsi.exceptions.BadDefaultParamException;
import com.vertica.dsi.exceptions.ExecutingException;
import com.vertica.dsi.exceptions.OperationCanceledException;
import com.vertica.dsi.exceptions.ParsingException;
import com.vertica.dsi.exceptions.UtilsException;
import com.vertica.io.BindRequestMessage;
import com.vertica.io.CopyDataRequestMessage;
import com.vertica.io.CopyDoneRequestMessage;
import com.vertica.io.CopyErrorRequestMessage;
import com.vertica.io.EndOfBatchRequestMessage;
import com.vertica.io.ErrorResponseMessage;
import com.vertica.io.ExecuteRequestMessage;
import com.vertica.io.LoadFileResponseMessage;
import com.vertica.io.Message;
import com.vertica.io.MessageType;
import com.vertica.io.ProtocolStream;
import com.vertica.io.ReadyForQueryResponseMessage;
import com.vertica.io.RequestMessage;
import com.vertica.io.ResponseMessage;
import com.vertica.io.RowDescriptionResponseMessage;
import com.vertica.io.SimpleQueryRequestMessage;
import com.vertica.io.SyncRequestMessage;
import com.vertica.io.VerifiedFilesRequestMessage;
import com.vertica.io.VerifyFilesResponseMessage;
import com.vertica.io.WriteFileResponseMessage;
import com.vertica.localization.VMessageKey;
import com.vertica.parser.StatementType;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.DiagState;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.GeneralException;
import com.vertica.util.ClientErrorException;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class VQueryExecutor
implements IQueryExecutor {
    protected DSILogger m_log;
    private String m_query;
    private String m_insertSql;
    protected ProtocolStream m_protocolStream;
    private VStatement m_statement;
    protected String m_statementName;
    protected Queue<VResultSet> m_futureResults;
    protected VConnection m_connection;
    protected final ArrayList<ParameterMetadata> m_parameterMetadata;
    private final boolean m_isNonPreparedExecuteBatch;
    protected ArrayList<ColumnDescription> m_preparedRowDescription;
    protected List<String> m_commandTags;
    private boolean m_useExtendedProtocol;
    private ExecutionContexts m_currentContexts;
    private ExecutionContext m_currentExecutionContext;
    private IWarningListener m_currentWarningListener;
    protected boolean m_finishStreamExecute;
    protected boolean m_isStreamingBatchInsert;
    protected int m_addBatchCount;
    protected boolean m_startingCopyOperation;
    private final boolean m_isBatchCopy;
    private final boolean m_generatesOnlyResultSets;
    private boolean m_isStdInCopy;
    protected boolean m_useLocalCopyProtocol;
    protected long[] m_rejects;
    protected long m_biAttemptedRowCount;
    private long m_copyRowCount;
    private VResultSet m_copyRowCountRS;
    private volatile boolean m_expediteWriteFileRunningFlag;
    private volatile ErrorException m_expediteWriteFileException;
    protected final Map<Integer, Map<Integer, List<DataWrapper>>> m_pushedDataCache;
    protected ExecutionResults m_executionResults;
    private final ExecutionResults m_preExecuteResults;
    protected boolean m_previousExecuteFailed;
    protected boolean m_isPreparedExecuteBatch = false;

    public VQueryExecutor(VStatement vStatement, String string, String string2, String string3, ArrayList<ParameterMetadata> arrayList, ArrayList<ColumnDescription> arrayList2, List<String> list, boolean bl, boolean bl2) {
        this.m_connection = vStatement.getConnection();
        this.m_log = this.m_connection.getConnectionLog();
        LogUtilities.logFunctionEntrance(this.m_log, vStatement, string3, arrayList, arrayList2, list, bl, bl2);
        this.m_statement = vStatement;
        this.m_query = string;
        this.m_insertSql = string2;
        this.m_statementName = string3;
        this.m_parameterMetadata = arrayList;
        this.m_protocolStream = this.m_connection.getProtocolStream();
        this.m_preparedRowDescription = arrayList2;
        this.m_useExtendedProtocol = bl2;
        this.m_commandTags = list;
        this.m_isNonPreparedExecuteBatch = bl;
        this.m_isBatchCopy = this.m_preparedRowDescription != null && !bl2 && this.m_commandTags.size() == 1 && this.m_commandTags.get(0).equals("INSERT");
        this.m_useLocalCopyProtocol = this.m_isBatchCopy || this.m_commandTags.size() == 1 && this.m_commandTags.get(0).equals("COPY_LOCAL");
        this.m_pushedDataCache = new HashMap<Integer, Map<Integer, List<DataWrapper>>>();
        this.m_executionResults = new ExecutionResults();
        this.m_futureResults = new ConcurrentLinkedQueue<VResultSet>();
        boolean bl3 = true;
        for (String string4 : list) {
            VResultSet vResultSet = new VResultSet(this, this.m_futureResults, string4, this.m_preparedRowDescription);
            this.registerResult(vResultSet, false);
            bl3 &= StatementType.returnsResultSet(string4);
        }
        this.m_generatesOnlyResultSets = bl3;
        this.m_preExecuteResults = this.m_executionResults;
        this.m_currentContexts = null;
        this.m_currentWarningListener = null;
        this.m_expediteWriteFileRunningFlag = false;
    }

    public VQueryExecutor(VStatement vStatement, String string, List<String> list, boolean bl) {
        this(vStatement, string, string, "", new ArrayList<ParameterMetadata>(), null, list, bl, false);
    }

    @Override
    public void cancelExecute() throws ErrorException {
        this.m_connection.cancelCurrentStatement(this.m_statement);
    }

    @Override
    public void clearCancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public ArrayList<ParameterMetadata> getMetadataForParameters() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_parameterMetadata;
    }

    @Override
    public int getNumParams() {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        return this.m_parameterMetadata.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutionResults getResults() {
        this.m_connection.lock();
        try {
            if ((this.m_isBatchCopy || this.m_useExtendedProtocol) && this.m_previousExecuteFailed) {
                ExecutionResults executionResults = this.m_preExecuteResults;
                return executionResults;
            }
            ExecutionResults executionResults = this.m_executionResults;
            return executionResults;
        }
        finally {
            this.m_connection.unlock();
        }
    }

    @Override
    public void pushParamData(int n, ParameterInputValue parameterInputValue) throws BadDefaultParamException, GeneralException {
        block6: {
            List<DataWrapper> list;
            Map<Integer, List<DataWrapper>> map;
            LogUtilities.logFunctionEntrance(this.m_log, n, parameterInputValue);
            assert (0 < n);
            int n2 = parameterInputValue.getMetadata().getParameterNumber();
            --n2;
            if (this.m_isStreamingBatchInsert) {
                n = 1;
            }
            if ((map = this.m_pushedDataCache.get(n - 1)) == null) {
                map = new HashMap<Integer, List<DataWrapper>>();
                this.m_pushedDataCache.put(n - 1, map);
            }
            List<DataWrapper> list2 = list = map.isEmpty() ? null : map.get(n2);
            if (null == list) {
                list = new ArrayList<DataWrapper>();
                map.put(n2, list);
            }
            try {
                list.add(parameterInputValue.getData());
            }
            catch (UtilsException utilsException) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
    }

    @Override
    public void finalizePushedParamData() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
    }

    @Override
    public void clearPushedParamData() throws GeneralException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        this.m_pushedDataCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(ExecutionContexts executionContexts, IWarningListener iWarningListener) throws BadDefaultParamException, ParsingException, ExecutingException, OperationCanceledException, ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, executionContexts, iWarningListener);
        this.validateQuery();
        this.m_connection.lock();
        try {
            try {
                this.m_protocolStream.setWarningListener(iWarningListener);
                this.m_connection.setCurrentStatement(this.m_statement);
                this.m_connection.ensureNotInLRS(this.m_query, this.m_statement.getResultBufferSize());
                if (this.m_isBatchCopy && this.m_connection.getCurrentCopyExecutor() != this) {
                    if (this.m_isStreamingBatchInsert && this.m_addBatchCount == 0 || !this.m_isStreamingBatchInsert && executionContexts.getCount() == 1) {
                        this.m_useExtendedProtocol = true;
                        this.m_useLocalCopyProtocol = false;
                    } else {
                        this.m_useExtendedProtocol = false;
                        this.m_useLocalCopyProtocol = true;
                    }
                }
                this.m_previousExecuteFailed = false;
                this.m_currentContexts = executionContexts;
                this.m_currentWarningListener = iWarningListener;
                this.m_futureResults = new ConcurrentLinkedQueue<VResultSet>();
                this.m_executionResults = new ExecutionResults();
                if (this.m_useLocalCopyProtocol) {
                    this.m_startingCopyOperation = this.isStartingCopy();
                } else {
                    this.m_connection.endCurrentCopy();
                }
                if (!this.m_finishStreamExecute && this.m_currentContexts.getCount() == 0) {
                    return;
                }
                if (this.m_useExtendedProtocol) {
                    if (this.m_useLocalCopyProtocol) {
                        throw new ClientErrorException("Illegally using local copy protocol");
                    }
                    this.executeExtendedProtocol();
                } else if (!this.m_useLocalCopyProtocol || this.m_startingCopyOperation) {
                    boolean bl = this.executeSimpleProtocol();
                    if (bl) {
                        if (this.m_useLocalCopyProtocol) {
                            throw new ClientErrorException("Illegally using local copy protocol");
                        }
                        return;
                    }
                } else if (!this.m_useLocalCopyProtocol || this.m_connection.getCurrentCopyExecutor() != this) {
                    throw new ClientErrorException("Local copy protocol not in use when it must be or incorrect copy executor in use");
                }
                this.handleExecuteResponse();
            }
            finally {
                this.m_pushedDataCache.clear();
                this.m_protocolStream.clearWarningListener();
            }
        }
        finally {
            this.m_connection.unlock();
        }
    }

    protected boolean isStartingCopy() throws ErrorException {
        VQueryExecutor vQueryExecutor = this.m_connection.getCurrentCopyExecutor();
        if (this == vQueryExecutor) {
            return false;
        }
        this.m_connection.endCurrentCopy();
        return true;
    }

    protected void registerResult(VResultSet vResultSet, boolean bl) {
        if (bl) {
            this.m_futureResults.add(vResultSet);
        }
        if (vResultSet.isRowCount()) {
            this.m_executionResults.addRowCountResult(vResultSet);
        } else {
            this.m_executionResults.addResultSet(vResultSet);
        }
    }

    private void registerExecuteError(ErrorException errorException, ExecutionContext executionContext, boolean bl) {
        executionContext.setStatus(ExecutionContextStatus.ERROR);
        this.m_executionResults.addErrorResult(new DSIErrorResult(errorException), !bl);
    }

    protected boolean executeSimpleProtocol() throws ErrorException, OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        boolean bl = false;
        try {
            String string = this.m_query;
            if (this.m_isBatchCopy && this.m_statement.getDirectBatchInsert()) {
                if (this.m_connection.isAutoCommitEnabled() && this.m_query.endsWith("AUTO")) {
                    string = this.m_query.substring(0, this.m_query.length() - 4) + "DIRECT";
                } else if (this.m_query.endsWith("AUTO NO COMMIT")) {
                    string = this.m_query.substring(0, this.m_query.length() - 14) + "DIRECT NO COMMIT";
                }
            }
            this.m_protocolStream.sendMessage(new SimpleQueryRequestMessage(string));
            ResponseMessage responseMessage = this.m_protocolStream.readMessage();
            MessageType messageType = responseMessage.getType();
            if (messageType.equals((Object)MessageType.Error)) {
                throw ((ErrorResponseMessage)responseMessage).getErrorData().buildException();
            }
            if (messageType.equals((Object)MessageType.EmptyQuery)) {
                ReadyForQueryResponseMessage readyForQueryResponseMessage = (ReadyForQueryResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.ReadyForQuery);
                this.m_connection.setServerTxnState(readyForQueryResponseMessage.getTxnState(), false, true);
                bl = true;
            } else {
                this.m_protocolStream.putBack(responseMessage);
            }
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(false, errorException);
            throw errorException;
        }
        return bl;
    }

    protected void executeExtendedProtocol() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, new Object[0]);
        try {
            Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
            int n = 0;
            while (iterator.hasNext()) {
                ExecutionContext executionContext = iterator.next();
                ArrayList<ParameterInputValue> arrayList = executionContext.getInputs();
                this.m_protocolStream.sendMessage(new BindRequestMessage(arrayList, this.m_pushedDataCache.get(n++), this.m_statementName, "", this.m_connection.getBinaryTransfer()));
                this.m_protocolStream.sendMessage(new ExecuteRequestMessage("", 0));
            }
            this.m_protocolStream.sendMessage(new SyncRequestMessage());
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(true, errorException);
            throw errorException;
        }
    }

    private void handleExecuteResponse() throws ErrorException, OperationCanceledException {
        try {
            if (this.m_useLocalCopyProtocol) {
                if (this.m_currentContexts.getCount() > 0) {
                    this.m_currentExecutionContext = this.m_currentContexts.contextIterator().next();
                }
                if (this.m_startingCopyOperation) {
                    this.readCopyStartResponse();
                }
                boolean bl = true;
                while (bl) {
                    this.sendCopyData();
                    if (this.m_finishStreamExecute || !this.m_isStreamingBatchInsert) {
                        bl = this.readCopyDataResponse();
                        continue;
                    }
                    bl = false;
                }
            } else {
                this.readExecuteResponse();
            }
        }
        catch (ErrorException errorException) {
            this.m_previousExecuteFailed = true;
            this.m_connection.handleError(false, errorException);
            if (this.m_currentExecutionContext != null) {
                if (this.m_isNonPreparedExecuteBatch || this.m_currentContexts.getCount() > 1) {
                    this.registerExecuteError(errorException, this.m_currentExecutionContext, true);
                } else {
                    this.m_currentExecutionContext.setStatus(ExecutionContextStatus.ERROR);
                }
            }
            throw errorException;
        }
    }

    public int getBatchCount() {
        return this.m_addBatchCount;
    }

    protected void readExecuteResponse() throws ErrorException, ClientErrorException {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        if (!this.m_futureResults.isEmpty()) {
            throw new ClientErrorException("There are future results, and should not be");
        }
        boolean bl = false;
        ErrorException errorException = null;
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            boolean bl2 = false;
            for (String string : this.m_commandTags) {
                VResultSet vResultSet = new VResultSet(this, this.m_futureResults, string, this.m_preparedRowDescription);
                if (bl) {
                    if (errorException == null) {
                        throw new ClientErrorException("batchException should not be null, but is");
                    }
                    this.registerExecuteError(errorException, this.m_currentExecutionContext, vResultSet.isRowCount());
                    bl2 = true;
                    continue;
                }
                this.registerResult(vResultSet, true);
                try {
                    if (this.m_connection.inLRS()) continue;
                    vResultSet.initialize();
                }
                catch (ErrorException errorException2) {
                    if (this.m_isPreparedExecuteBatch || this.m_isNonPreparedExecuteBatch) {
                        ArrayList<ExecutionResult> arrayList = this.m_executionResults.getResults();
                        arrayList.remove(arrayList.size() - 1);
                        this.registerExecuteError(errorException2, this.m_currentExecutionContext, vResultSet.isRowCount());
                        bl2 = true;
                        this.m_connection.handleError(false, errorException2);
                        bl = true;
                        errorException = errorException2;
                        continue;
                    }
                    throw errorException2;
                }
            }
            this.m_currentExecutionContext.setStatus(bl2 ? ExecutionContextStatus.ERROR : ExecutionContextStatus.SUCCESS);
        }
    }

    protected void readCopyStartResponse() throws ErrorException, ClientErrorException {
        Message message;
        RowDescriptionResponseMessage rowDescriptionResponseMessage = (RowDescriptionResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.RowDescription);
        this.m_copyRowCountRS = new VResultSet(this, this.m_futureResults, this.m_commandTags.get(0), rowDescriptionResponseMessage.getRowDescription());
        this.m_futureResults.add(this.m_copyRowCountRS);
        this.m_connection.setCurrentCopy(this);
        VerifyFilesResponseMessage verifyFilesResponseMessage = (VerifyFilesResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.VerifyFiles);
        String[] stringArray = verifyFilesResponseMessage.getInputFileNames();
        boolean bl = this.m_isStdInCopy = stringArray.length == 0;
        if (!this.m_isStdInCopy && this.m_connection.getDisableCopyLocal()) {
            throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_COPY_LOCAL_DISABLED.toString());
        }
        File[] fileArray = null;
        try {
            fileArray = this.checkFiles(stringArray, verifyFilesResponseMessage.getExceptionsFileName(), verifyFilesResponseMessage.getRejectionsFileName());
            message = new VerifiedFilesRequestMessage(fileArray);
            this.m_protocolStream.sendMessage((RequestMessage)message);
        }
        catch (IOException iOException) {
            this.m_protocolStream.sendMessage(new CopyErrorRequestMessage(iOException));
        }
        message = this.m_protocolStream.readMessage();
        switch (message.getType()) {
            case CopyIn: {
                if (this.m_isStdInCopy) break;
                throw new ClientErrorException("Response should be StdInCopy and is not");
            }
            case Error: {
                throw ((ErrorResponseMessage)message).getErrorData().buildException();
            }
            default: {
                this.m_protocolStream.putBack((ResponseMessage)message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCopyData() throws ErrorException {
        Object object;
        List<CopyDataRequestMessage> list = null;
        Thread thread = null;
        if (this.m_isStdInCopy) {
            list = this.getStdinCopyData();
        } else {
            if (this.m_connection.getDisableCopyLocal()) {
                throw VDriver.s_vExceptionBuilder.createGeneralException(VMessageKey.ERROR_COPY_LOCAL_DISABLED.toString());
            }
            list = this.getLocalFileCopyData();
        }
        if (!this.m_isStreamingBatchInsert) {
            object = new Runnable(){

                @Override
                public void run() {
                    VQueryExecutor.this.m_expediteWriteFileException = null;
                    int n = 0;
                    while (VQueryExecutor.this.m_expediteWriteFileRunningFlag) {
                        try {
                            n = VQueryExecutor.this.m_protocolStream.expediteWriteFileMessage();
                            if (n == 0) {
                                try {
                                    if (!VQueryExecutor.this.m_expediteWriteFileRunningFlag) continue;
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException interruptedException) {
                                    VQueryExecutor.this.m_expediteWriteFileRunningFlag = false;
                                    Thread.currentThread().interrupt();
                                }
                                continue;
                            }
                            if (n != -1) continue;
                            VQueryExecutor.this.m_expediteWriteFileRunningFlag = false;
                        }
                        catch (ErrorException errorException) {
                            VQueryExecutor.this.m_expediteWriteFileRunningFlag = false;
                            VQueryExecutor.this.m_expediteWriteFileException = errorException;
                        }
                    }
                }
            };
            this.m_expediteWriteFileRunningFlag = true;
            thread = new Thread((Runnable)object);
            thread.start();
        }
        try {
            for (CopyDataRequestMessage copyDataRequestMessage : list) {
                this.m_protocolStream.sendMessage(copyDataRequestMessage);
            }
        }
        finally {
            this.m_expediteWriteFileRunningFlag = false;
            if (thread != null) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (this.m_expediteWriteFileException != null) {
            object = this.m_expediteWriteFileException;
            this.m_expediteWriteFileException = null;
            throw object;
        }
        if (!this.m_isStreamingBatchInsert || this.m_finishStreamExecute) {
            this.m_protocolStream.sendMessage(new EndOfBatchRequestMessage());
        }
    }

    protected boolean readCopyDataResponse() throws ErrorException {
        this.m_rejects = null;
        ResponseMessage responseMessage = this.m_protocolStream.readExpectedMessage(EndOfBatchRequestMessage.LEGAL_RESPONSES);
        while (responseMessage.getType().equals((Object)MessageType.WriteFile)) {
            WriteFileResponseMessage writeFileResponseMessage = (WriteFileResponseMessage)responseMessage;
            if (writeFileResponseMessage.usingReturnRejectedFormat()) {
                this.m_rejects = writeFileResponseMessage.getReturnRejectedRows();
            } else {
                writeFileResponseMessage.writeToDisk();
            }
            responseMessage = this.m_protocolStream.readExpectedMessage(EndOfBatchRequestMessage.LEGAL_RESPONSES);
        }
        if (this.m_rejects == null) {
            this.m_rejects = new long[0];
        }
        this.m_protocolStream.putBack(responseMessage);
        this.m_protocolStream.readExpectedMessage(MessageType.ServerEndOfBatch);
        if (!this.m_isStdInCopy) {
            responseMessage = this.m_protocolStream.readMessage();
            this.m_protocolStream.putBack(responseMessage);
            if (responseMessage.getType().equals((Object)MessageType.LoadFile)) {
                return true;
            }
            this.m_protocolStream.readExpectedMessage(MessageType.ServerCopyDone);
        }
        if (!this.m_isStdInCopy || this.m_isStdInCopy && this.m_connection.isAutoCommitEnabled()) {
            this.m_connection.endCurrentCopy();
        }
        if (this.m_isStreamingBatchInsert && this.m_finishStreamExecute) {
            this.registerStreamingBatchInsertResults();
        } else if (this.m_isBatchCopy) {
            this.registerBatchInsertResults();
        } else {
            this.registerLocalCopyResults();
        }
        return false;
    }

    protected List<CopyDataRequestMessage> getStdinCopyData() {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        int n = 0;
        LinkedList<CopyDataRequestMessage> linkedList = new LinkedList<CopyDataRequestMessage>();
        if (this.m_currentContexts.getCount() == 0 && this.m_isBatchCopy && this.m_startingCopyOperation) {
            linkedList.add(new CopyDataRequestMessage(this.m_startingCopyOperation, this.m_parameterMetadata.size(), null, null));
        }
        while (iterator.hasNext()) {
            Object object;
            Object object2;
            this.m_currentExecutionContext = iterator.next();
            if (this.m_currentExecutionContext instanceof VCopyStreamExecutionContext) {
                object2 = (VCopyStreamExecutionContext)this.m_currentExecutionContext;
                object = ((VCopyStreamExecutionContext)object2).getCopyStream();
                linkedList.add(new CopyDataRequestMessage((InputStream)object));
            } else {
                object2 = this.m_currentExecutionContext.getInputs();
                object = this.m_pushedDataCache.get(n++);
                CopyDataRequestMessage copyDataRequestMessage = new CopyDataRequestMessage(this.m_startingCopyOperation, this.m_parameterMetadata.size(), (List<ParameterInputValue>)object2, (Map<Integer, List<DataWrapper>>)object);
                linkedList.add(copyDataRequestMessage);
            }
            if (!this.m_startingCopyOperation) continue;
            this.m_startingCopyOperation = false;
        }
        return linkedList;
    }

    private List<CopyDataRequestMessage> getLocalFileCopyData() throws ErrorException {
        LinkedList<CopyDataRequestMessage> linkedList = new LinkedList<CopyDataRequestMessage>();
        LoadFileResponseMessage loadFileResponseMessage = (LoadFileResponseMessage)this.m_protocolStream.readExpectedMessage(MessageType.LoadFile);
        String string = loadFileResponseMessage.getFileName();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            linkedList.add(new CopyDataRequestMessage(fileInputStream));
        }
        catch (IOException iOException) {
            this.m_protocolStream.sendMessage(new CopyErrorRequestMessage(iOException));
        }
        return linkedList;
    }

    protected void registerBatchInsertResults() {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        int n = 0;
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            if (n < this.m_rejects.length && this.m_rejects[n] == this.m_biAttemptedRowCount + 1L) {
                this.m_currentExecutionContext.setStatus(ExecutionContextStatus.ERROR);
                this.m_executionResults.addErrorResult(new DSIErrorResult(this.m_connection.getMessageSource().loadMessage(this.m_connection.getLocale(), 101, VMessageKey.ERROR_ROW_REJECTED.toString()), 0, "01S01"), false);
                ++n;
            } else {
                this.m_currentExecutionContext.setStatus(ExecutionContextStatus.SUCCESS);
                String string = System.getProperty("com.vertica.jdbc.ForceLongRowCount");
                if (string != null && string.equals("true")) {
                    this.m_executionResults.addRowCountResult(new DSISimpleRowCountResult(0x10000000AL));
                } else {
                    this.m_executionResults.addRowCountResult(new DSISimpleRowCountResult(1L));
                }
            }
            ++this.m_biAttemptedRowCount;
        }
    }

    private void registerStreamingBatchInsertResults() {
        int n = 0;
        for (int i = 0; i < this.m_addBatchCount; ++i) {
            if (n < this.m_rejects.length && this.m_rejects[n] == this.m_biAttemptedRowCount + 1L) {
                this.m_executionResults.addErrorResult(new DSIErrorResult(this.m_connection.getMessageSource().loadMessage(this.m_connection.getLocale(), 101, VMessageKey.ERROR_ROW_REJECTED.toString()), 0, "01S01"), false);
                ++n;
            } else {
                this.m_executionResults.addRowCountResult(new DSISimpleRowCountResult(1L));
            }
            ++this.m_biAttemptedRowCount;
        }
        this.m_addBatchCount = 0;
    }

    private void registerLocalCopyResults() throws ErrorException {
        Iterator<ExecutionContext> iterator = this.m_currentContexts.contextIterator();
        while (iterator.hasNext()) {
            this.m_currentExecutionContext = iterator.next();
            this.m_currentExecutionContext.setStatus(ExecutionContextStatus.SUCCESS);
        }
        if (!this.m_isStdInCopy) {
            this.registerResult(this.m_copyRowCountRS, false);
        }
        if (this.m_currentContexts instanceof VCopyStreamExecutionContexts) {
            ((VCopyStreamExecutionContexts)this.m_currentContexts).setRejects(this.m_rejects);
        }
    }

    private File[] checkFiles(String[] stringArray, String string, String string2) throws IOException, ClientErrorException {
        ArrayList<File> arrayList = new ArrayList<File>(stringArray.length);
        if (stringArray.length == 0) {
            if (!this.m_isStdInCopy) {
                throw new ClientErrorException("Response should be StdInCopy, but is not");
            }
            return new File[0];
        }
        for (String string3 : stringArray) {
            HashSet<File> hashSet = this.expandGlob(string3);
            if (hashSet.isEmpty()) {
                File file = new File(string3);
                if (file.isDirectory()) {
                    throw new IOException(string3 + " is a directory.");
                }
                if (!file.exists()) {
                    throw new IOException(string3 + " does not exist.");
                }
                hashSet.add(file);
            }
            for (File file : hashSet) {
                this.checkFile(file, true);
            }
            arrayList.addAll(hashSet);
        }
        if (!"".equals(string2)) {
            this.checkFile(new File(string2), false);
        }
        if (!"".equals(string)) {
            this.checkFile(new File(string), false);
        }
        Object[] objectArray = new File[arrayList.size()];
        return (File[])arrayList.toArray(objectArray);
    }

    private void checkFile(File file, boolean bl) throws IOException {
        try {
            String string = file.getAbsolutePath();
            if (file.isDirectory()) {
                throw new IOException(string + " is a directory.");
            }
            if (bl) {
                if (!file.exists()) {
                    throw new IOException(string + " does not exist.");
                }
                if (!file.canRead()) {
                    throw new IOException(string + " is not readable.");
                }
            } else {
                if (file.exists() && !file.canWrite()) {
                    throw new IOException(string + " is not writable.");
                }
                File file2 = file.getParentFile();
                if (!(file2 == null || file2.isDirectory() && file2.canWrite())) {
                    throw new IOException(string + " is not writable.");
                }
            }
        }
        catch (SecurityException securityException) {
            throw new IOException("Insufficient permissions on " + file);
        }
    }

    public VStatement getParentStatement() {
        return this.m_statement;
    }

    public long[] getCopyRejects() {
        return this.m_rejects;
    }

    public long getCopyRowCount() {
        return this.m_copyRowCount;
    }

    protected final boolean generatesOnlyResultSets() {
        return this.m_generatesOnlyResultSets;
    }

    public void endCopy() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_log, this);
        this.m_protocolStream.sendMessage(new CopyDoneRequestMessage());
        ResponseMessage responseMessage = this.m_protocolStream.readMessage();
        if (responseMessage.getType().equals((Object)MessageType.WriteFile)) {
            WriteFileResponseMessage writeFileResponseMessage = (WriteFileResponseMessage)responseMessage;
            writeFileResponseMessage.toString();
        } else {
            this.m_protocolStream.putBack(responseMessage);
        }
        this.m_connection.setCurrentCopy(null);
        this.m_copyRowCountRS.initialize();
        this.m_copyRowCount += this.m_copyRowCountRS.getRowCount();
        this.m_biAttemptedRowCount = 0L;
    }

    private HashSet<File> expandGlob(String string) throws IOException {
        File file = new File(string);
        String string2 = Pattern.quote(File.separator);
        boolean bl = System.getProperty("os.name", "").contains("Windows");
        if (bl) {
            string2 = string2 + "|" + Pattern.quote("/");
        }
        String[] stringArray = string.split(string2);
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + 1);
        if (file.isAbsolute()) {
            if ("".equals(stringArray[0]) && !bl) {
                arrayList.add(File.separator);
            }
        } else if (!".".equals(stringArray[0]) && !"..".equals(stringArray[0])) {
            arrayList.add(".");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if ("".equals(stringArray[i])) continue;
            arrayList.add(stringArray[i]);
        }
        HashSet<File> hashSet = new HashSet<File>();
        try {
            this.expandGlobImpl(new File((String)arrayList.get(0)), 1, arrayList, hashSet);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IOException(patternSyntaxException.getMessage());
        }
        return hashSet;
    }

    private boolean expandGlobImpl(File file, int n, ArrayList<String> arrayList, HashSet<File> hashSet) throws IOException {
        boolean bl = false;
        String string = arrayList.get(n);
        ++n;
        File[] fileArray = null;
        if ("..".equals(string)) {
            File[] fileArray2 = file.getAbsoluteFile();
            if (fileArray2.getParentFile() != null) {
                fileArray2 = fileArray2.getParentFile();
            }
            fileArray = new File[]{fileArray2};
        } else {
            fileArray = ".".equals(string) ? new File[]{file} : file.listFiles(new GlobFileFilter(string));
        }
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (n < arrayList.size()) {
                    if (!file2.isDirectory()) continue;
                    bl |= this.expandGlobImpl(file2.getCanonicalFile(), n, arrayList, hashSet);
                    continue;
                }
                if (!file2.exists() || !file2.isFile()) continue;
                hashSet.add(file2);
                bl = true;
            }
        }
        return bl;
    }

    public void setIsPreparedExecuteBatch(boolean bl) {
        this.m_isPreparedExecuteBatch = bl;
    }

    public boolean getIsPreparedExecuteBatch() {
        return this.m_isPreparedExecuteBatch;
    }

    public VStatement getStatement() {
        return this.m_statement;
    }

    @Override
    public void pushMappedParamTypes(Map<Integer, TypeMetadata> map) {
    }

    private void validateQuery() throws ErrorException {
        for (String string : this.m_commandTags) {
            if (!string.equals("COPY_LOCAL") || this.m_commandTags.size() <= 1) continue;
            throw new ErrorException(DiagState.DIAG_GENERAL_ERROR, 101, VMessageKey.ERROR_COMPOUND_COPY_LOCAL_NOT_SUPPORTED.toString());
        }
    }

    private static class GlobFileFilter
    implements FileFilter {
        private Pattern m_regex;

        public GlobFileFilter(String string) throws PatternSyntaxException {
            String string2 = this.glob2regex(string);
            this.m_regex = Pattern.compile(string2);
        }

        private String glob2regex(String string) {
            StringBuilder stringBuilder = new StringBuilder(string.length() * 2);
            boolean bl = false;
            int n = 0;
            for (char c : string.toCharArray()) {
                switch (c) {
                    case '\\': {
                        if (!bl) break;
                        stringBuilder.append("\\\\");
                        break;
                    }
                    case '*': {
                        if (bl) {
                            stringBuilder.append("\\*");
                            break;
                        }
                        stringBuilder.append(".*");
                        break;
                    }
                    case '?': {
                        if (bl) {
                            stringBuilder.append("\\?");
                            break;
                        }
                        stringBuilder.append(".");
                        break;
                    }
                    case '{': {
                        if (bl) {
                            stringBuilder.append("\\{");
                            break;
                        }
                        stringBuilder.append('(');
                        ++n;
                        break;
                    }
                    case '}': {
                        if (bl) {
                            stringBuilder.append("\\}");
                            break;
                        }
                        if (n > 0) {
                            stringBuilder.append(')');
                            --n;
                            break;
                        }
                        stringBuilder.append("}");
                        break;
                    }
                    case ',': {
                        if (bl) {
                            stringBuilder.append("\\,");
                            break;
                        }
                        if (n > 0) {
                            stringBuilder.append('|');
                            break;
                        }
                        stringBuilder.append(',');
                        break;
                    }
                    case '$': 
                    case '%': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '@': 
                    case '^': 
                    case '|': {
                        stringBuilder.append('\\');
                        stringBuilder.append(c);
                        break;
                    }
                    default: {
                        stringBuilder.append(c);
                    }
                }
                bl = !bl && c == '\\';
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean accept(File file) {
            Matcher matcher = this.m_regex.matcher(file.getName());
            boolean bl = matcher.matches();
            return bl;
        }
    }
}

