/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.lz4;

import java.nio.ByteBuffer;
import java.util.Arrays;
import net.jpountz.lz4.LZ4Utils;

public abstract class LZ4Compressor {
    public final int maxCompressedLength(int n2) {
        return LZ4Utils.maxCompressedLength(n2);
    }

    public abstract int compress(byte[] var1, int var2, int var3, byte[] var4, int var5, int var6);

    public abstract int compress(ByteBuffer var1, int var2, int var3, ByteBuffer var4, int var5, int var6);

    public final int compress(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        return this.compress(byArray, n2, n3, byArray2, n4, byArray2.length - n4);
    }

    public final int compress(byte[] byArray, byte[] byArray2) {
        return this.compress(byArray, 0, byArray.length, byArray2, 0);
    }

    public final byte[] compress(byte[] byArray, int n2, int n3) {
        int n4 = this.maxCompressedLength(n3);
        byte[] byArray2 = new byte[n4];
        int n5 = this.compress(byArray, n2, n3, byArray2, 0);
        return Arrays.copyOf(byArray2, n5);
    }

    public final byte[] compress(byte[] byArray) {
        return this.compress(byArray, 0, byArray.length);
    }

    public final void compress(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n2 = this.compress(byteBuffer, byteBuffer.position(), byteBuffer.remaining(), byteBuffer2, byteBuffer2.position(), byteBuffer2.remaining());
        byteBuffer.position(byteBuffer.limit());
        byteBuffer2.position(byteBuffer2.position() + n2);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

