/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pane;

import com.jidesoft.animation.CustomAnimation;
import com.jidesoft.animation.Function;
import com.jidesoft.icons.IconsFactory;
import com.jidesoft.pane.event.CollapsiblePaneEvent;
import com.jidesoft.pane.event.CollapsiblePaneListener;
import com.jidesoft.plaf.CollapsiblePaneUI;
import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.Resource;
import com.jidesoft.swing.VisibilityFocusTraversalPolicy;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import com.jidesoft.utils.ReflectionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.plaf.PanelUI;

public class CollapsiblePane
extends JPanel
implements SwingConstants,
WindowConstants {
    private static final Logger \u0114;
    private static final String \u0117 = "CollapsiblePaneUI";
    private JComponent \u0101;
    private boolean \u011d = false;
    private Icon \u0102;
    private Icon \u0121;
    private Icon \u011b;
    private Icon \u0104;
    private String \u0124;
    private int \u0103 = 0;
    private int \u0123 = 10;
    private int \u010e = 0;
    private int \u0110 = 11;
    private int \u0113 = 4;
    private int \u0106 = 4;
    private boolean \u0122 = true;
    public static final String CONTENT_PANE_PROPERTY = "contentPane";
    public static final String TITLE_PROPERTY = "title";
    public static final String ICON_PROPERTY = "icon";
    public static final String PROPERTY_TITLE_ICON = "titleIcon";
    public static final String COLLAPSED_PROPERTY = "collapsed";
    public static final String STYLE_PROPERTY = "style";
    public static final String PROPERTY_COLLAPSED_ICON = "collapsedIcon";
    public static final String PROPERTY_EXPANDED_ICON = "expandedIcon";
    protected boolean _collapsed = false;
    protected int _collapsedPercentage = 0;
    protected int _contentPaneHeight = -1;
    protected int _contentPaneWidth = -1;
    private A \u010a;
    private int \u0105 = 50;
    private int \u011e = 5;
    private int \u0108 = 10;
    private Function \u0112;
    public static final int DROPDOWN_STYLE = 0;
    public static final int TREE_STYLE = 1;
    public static final int PLAIN_STYLE = 2;
    public static final int SEPARATOR_STYLE = 3;
    private int \u010b;
    private boolean \u0107;
    private boolean \u0115 = true;
    public static final String EMPHASIZED_PROPERTY = "emphasized";
    private int \u0118 = 5;
    private boolean \u011c = true;
    private boolean \u011f = true;
    private boolean \u0119 = true;
    private boolean \u0111 = true;
    private boolean \u010c = true;
    private Component \u011a;
    private JComponent \u010d;
    private boolean \u0120 = true;
    protected boolean _rollover = false;
    private boolean \u010f = true;
    private Action \u0116 = null;
    private boolean \u0109 = true;
    public static final String ICONTEXTGAP_PROPERTY = "iconTextGap";
    public static final String VERTICAL_ALIGNMENT_PROPERTY = "verticalAlignment";
    public static final String HORIZONTAL_ALIGNMENT_PROPERTY = "horizontalAlignment";
    public static final String VERTICAL_TEXTPOSITION_PROPERTY = "verticalTextPosition";
    public static final String HORIZONTAL_TEXTPOSITION_PROPERTY = "horizontalTextPosition";
    public static final String PROPERTY_COLLAPSIBLE = "collapsible";
    public static final String PROPERTY_SHOW_TITLE_BAR = "showTitleBar";
    public static final String PROPERTY_SHOW_EXPAND_BUTTON = "showExpandButton";
    public static final String PROPERTY_SLIDING_DIRECTION = "slidingDirection";
    public static final String PROPERTY_FOCUS_PAINTED = "focusPainted";
    public static final String PROPERTY_CONTENTAREA_FILLED = "contentAreaFilled";
    public static final String PROPERTY_TITLE_PANE_OPAQUE = "titlePaneOpaque";
    public static final String PROPERTY_AUTO_EXPAND_ON_DRAGOVER = "autoExpandOnDragover";
    public static final String PROPERTY_TITLE_COMPONENT = "titleComponent";
    public static final String PROPERTY_TITLE_LABEL_COMPONENT = "titleLabelComponent";
    public static final String PROPERTY_COLLAPSE_ON_TITLE_CLICK = "collapseOnTitleClick";
    public static final String PROPERTY_COLLAPSED_PERCENTAGE = "collapsedPercentage";
    public static final String PROPERTY_TOGGLE_ACTION = "toggleAction";
    public static final String PROPERTY_CONTENT_BORDER_VISIBLE = "contentBorderVisible";

    public CollapsiblePane() {
        this("");
    }

    public CollapsiblePane(String string) {
        this(string, UIDefaultsLookup.getIcon("CollapsiblePane.defaultIcon"));
    }

    public CollapsiblePane(String string, int n2) {
        this(string, UIDefaultsLookup.getIcon("CollapsiblePane.defaultIcon"), n2);
    }

    public CollapsiblePane(String string, Icon icon, int n2, int n3, int n4) {
        this(string, icon);
        this.\u0105 = n2;
        this.\u011e = n3;
        this.\u0108 = n4;
    }

    public CollapsiblePane(String string, Icon icon, int n2, int n3, int n4, int n5) {
        this(string, icon);
        this.\u0105 = n2;
        this.\u011e = n3;
        this.\u0108 = n4;
        this.\u0118 = n5;
    }

    public CollapsiblePane(String string, Icon icon) {
        this(string, icon, 5);
    }

    public CollapsiblePane(String string, Icon icon, int n2) {
        if (string == null) {
            throw new IllegalArgumentException("title cannot be null");
        }
        this.setContentPaneCheckingEnabled(false);
        this.setOpaque(false);
        this.setFocusable(true);
        this.\u010a = new A();
        this.\u010a.setOpaque(false);
        this.add(this.\u010a);
        this.\u010a.setBorder(BorderFactory.createEmptyBorder());
        JPanel jPanel = new JPanel();
        jPanel.setOpaque(false);
        this.setContentPane(jPanel);
        this.setTitle(string);
        this.setIcon(icon);
        this.setSlidingDirection(n2);
        this.setContentPaneCheckingEnabled(true);
        this.updateUI();
    }

    @Override
    public PanelUI getUI() {
        return (CollapsiblePaneUI)this.ui;
    }

    public void setUI(CollapsiblePaneUI collapsiblePaneUI) {
        boolean bl = this.isContentPaneCheckingEnabled();
        try {
            this.setContentPaneCheckingEnabled(false);
            super.setUI(collapsiblePaneUI);
        }
        finally {
            this.setContentPaneCheckingEnabled(bl);
        }
    }

    @Override
    public void updateUI() {
        if (UIDefaultsLookup.get(\u0117) == null) {
            LookAndFeelFactory.installJideExtension();
        }
        this.setUI((CollapsiblePaneUI)UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return \u0117;
    }

    protected boolean isContentPaneCheckingEnabled() {
        return this.\u011d;
    }

    protected void setContentPaneCheckingEnabled(boolean bl) {
        this.\u011d = bl;
    }

    private Error \u0101(String string) {
        String string2 = this.getClass().getName();
        return new Error("Do not use " + string2 + "." + string + "() use " + string2 + ".getContentPane()." + string + "() instead");
    }

    @Override
    protected void addImpl(Component component, Object object, int n2) {
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().add(component, object, n2);
        } else {
            super.addImpl(component, object, n2);
        }
    }

    @Override
    public void remove(Component component) {
        int n2 = this.getComponentCount();
        super.remove(component);
        if (n2 == this.getComponentCount()) {
            this.getContentPane().remove(component);
        }
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (this.isContentPaneCheckingEnabled()) {
            this.getContentPane().setLayout(layoutManager);
        } else {
            super.setLayout(layoutManager);
        }
    }

    public JComponent getContentPane() {
        return this.\u0101;
    }

    public void setContentPane(JComponent jComponent) {
        JComponent jComponent2 = this.getContentPane();
        if (this.\u0101 == null || !this.\u0101.equals(jComponent)) {
            this.\u010a.removeAll();
            this.\u010a.add(jComponent);
            this.\u0101 = jComponent;
            this.firePropertyChange(CONTENT_PANE_PROPERTY, jComponent2, jComponent);
        }
    }

    public void setCollapsed(boolean bl) throws PropertyVetoException {
        Boolean bl2 = this.isCollapsed() ? Boolean.TRUE : Boolean.FALSE;
        Boolean bl3 = bl ? Boolean.TRUE : Boolean.FALSE;
        this.fireVetoableChange(COLLAPSED_PROPERTY, bl2, bl3);
        this._collapsed = bl;
        if (this._collapsed) {
            this.fireCollapsiblePaneEvent(6102);
        } else {
            this.fireCollapsiblePaneEvent(6100);
        }
        this.firePropertyChange(COLLAPSED_PROPERTY, bl2, bl3);
    }

    public boolean isCollapsed() {
        return this._collapsed;
    }

    public boolean isExpanded() {
        return !this.isCollapsed();
    }

    public String getTitle() {
        return this.\u0124;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null or empty");
        }
        String string2 = this.\u0124;
        if (!string.equals(string2)) {
            this.\u0124 = string;
            this.firePropertyChange(TITLE_PROPERTY, string2, string);
        }
    }

    public void setIcon(Icon icon) {
        Icon icon2 = this.\u0102;
        this.\u0102 = icon;
        this.firePropertyChange(ICON_PROPERTY, icon2, icon);
    }

    public Icon getIcon() {
        return this.\u0102;
    }

    public void setTitleIcon(Icon icon) {
        Icon icon2 = this.\u0121;
        this.\u0121 = icon;
        this.firePropertyChange(PROPERTY_TITLE_ICON, icon2, icon);
    }

    public Icon getTitleIcon() {
        return this.\u0121;
    }

    protected int checkHorizontalKey(int n2, String string) {
        if (n2 == 2 || n2 == 0 || n2 == 4 || n2 == 10 || n2 == 11) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    protected int checkVerticalKey(int n2, String string) {
        if (n2 == 1 || n2 == 0 || n2 == 3) {
            return n2;
        }
        throw new IllegalArgumentException(string);
    }

    public int getIconTextGap() {
        return this.\u0113;
    }

    public void setIconTextGap(int n2) {
        int n3 = this.\u0113;
        this.\u0113 = n2;
        this.firePropertyChange(ICONTEXTGAP_PROPERTY, n3, n2);
        if (n2 != n3) {
            this.revalidate();
            this.repaint();
        }
    }

    public int getVerticalAlignment() {
        return this.\u0103;
    }

    public void setVerticalAlignment(int n2) {
        if (n2 == this.\u0103) {
            return;
        }
        int n3 = this.\u0103;
        this.\u0103 = this.checkVerticalKey(n2, VERTICAL_ALIGNMENT_PROPERTY);
        this.firePropertyChange(VERTICAL_ALIGNMENT_PROPERTY, n3, this.\u0103);
        this.repaint();
    }

    public int getHorizontalAlignment() {
        return this.\u0123;
    }

    public void setHorizontalAlignment(int n2) {
        if (n2 == this.\u0123) {
            return;
        }
        int n3 = this.\u0123;
        this.\u0123 = this.checkHorizontalKey(n2, HORIZONTAL_ALIGNMENT_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_PROPERTY, n3, this.\u0123);
        this.repaint();
    }

    public int getVerticalTextPosition() {
        return this.\u010e;
    }

    public void setVerticalTextPosition(int n2) {
        if (n2 == this.\u010e) {
            return;
        }
        int n3 = this.\u010e;
        this.\u010e = this.checkVerticalKey(n2, VERTICAL_TEXTPOSITION_PROPERTY);
        this.firePropertyChange(VERTICAL_TEXTPOSITION_PROPERTY, n3, this.\u010e);
        this.repaint();
    }

    public int getHorizontalTextPosition() {
        return this.\u0110;
    }

    public void setHorizontalTextPosition(int n2) {
        int n3 = this.\u0110;
        this.\u0110 = this.checkHorizontalKey(n2, HORIZONTAL_TEXTPOSITION_PROPERTY);
        this.firePropertyChange(HORIZONTAL_TEXTPOSITION_PROPERTY, n3, this.\u0110);
        this.repaint();
    }

    public void addCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listenerList.add(CollapsiblePaneListener.class, collapsiblePaneListener);
        this.enableEvents(0L);
    }

    public void removeCollapsiblePaneListener(CollapsiblePaneListener collapsiblePaneListener) {
        this.listenerList.remove(CollapsiblePaneListener.class, collapsiblePaneListener);
    }

    public CollapsiblePaneListener[] getCollapsiblePaneListeners() {
        return (CollapsiblePaneListener[])this.listenerList.getListeners(CollapsiblePaneListener.class);
    }

    public void fireCollapsiblePaneEvent(int n2) {
        if (\u0114.isLoggable(Level.FINE)) {
            switch (n2) {
                case 6099: {
                    \u0114.fine("CollapsiblePane \"" + this.getTitle() + "\" is expanding.");
                    break;
                }
                case 6100: {
                    \u0114.fine("CollapsiblePane \"" + this.getTitle() + "\" is expanded.");
                    break;
                }
                case 6101: {
                    \u0114.fine("CollapsiblePane \"" + this.getTitle() + "\" is collapsing.");
                    break;
                }
                case 6102: {
                    \u0114.fine("CollapsiblePane \"" + this.getTitle() + "\" is collapsed.");
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        CollapsiblePaneEvent collapsiblePaneEvent = null;
        block12: for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != CollapsiblePaneListener.class) continue;
            if (collapsiblePaneEvent == null) {
                collapsiblePaneEvent = new CollapsiblePaneEvent(this, n2);
            }
            switch (n2) {
                case 6099: {
                    ((CollapsiblePaneListener)objectArray[i2 + 1]).paneExpanding(collapsiblePaneEvent);
                    continue block12;
                }
                case 6100: {
                    ((CollapsiblePaneListener)objectArray[i2 + 1]).paneExpanded(collapsiblePaneEvent);
                    continue block12;
                }
                case 6101: {
                    ((CollapsiblePaneListener)objectArray[i2 + 1]).paneCollapsing(collapsiblePaneEvent);
                    continue block12;
                }
                case 6102: {
                    ((CollapsiblePaneListener)objectArray[i2 + 1]).paneCollapsed(collapsiblePaneEvent);
                }
            }
        }
        if (n2 == 6102) {
            Container container;
            for (container = this; container != null && !container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot(); container = container.getParent()) {
            }
            if (container != null) {
                FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
                if (focusTraversalPolicy instanceof VisibilityFocusTraversalPolicy) {
                    ((VisibilityFocusTraversalPolicy)focusTraversalPolicy).addContainer(this);
                } else if (focusTraversalPolicy == null || !ReflectionUtils.isSubClassOf(focusTraversalPolicy, "LegacyGlueFocusTraversalPolicy")) {
                    container.setFocusTraversalPolicy(new VisibilityFocusTraversalPolicy(focusTraversalPolicy, this));
                }
            }
        } else if (n2 == 6100) {
            Container container;
            for (container = this; container != null && !container.isFocusTraversalPolicyProvider() && !container.isFocusCycleRoot(); container = container.getParent()) {
            }
            if (container != null && container.getFocusTraversalPolicy() instanceof VisibilityFocusTraversalPolicy) {
                VisibilityFocusTraversalPolicy visibilityFocusTraversalPolicy = (VisibilityFocusTraversalPolicy)container.getFocusTraversalPolicy();
                visibilityFocusTraversalPolicy.removeContainer(this);
                if (visibilityFocusTraversalPolicy.getContainers().length == 0) {
                    container.setFocusTraversalPolicy(visibilityFocusTraversalPolicy.getDefaultPolicy());
                }
            }
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCollapsiblePane();
        }
        return this.accessibleContext;
    }

    public boolean isCollapseOnTitleClick() {
        return this.\u010f;
    }

    public void setCollapseOnTitleClick(boolean bl) {
        if (this.\u010f != bl) {
            boolean bl2 = this.\u010f;
            this.\u010f = bl;
            this.firePropertyChange(PROPERTY_COLLAPSE_ON_TITLE_CLICK, bl2, this.\u010f);
        }
    }

    public int getTitleLabelGap() {
        return this.\u0106;
    }

    public void setTitleLabelGap(int n2) {
        this.\u0106 = n2;
    }

    public int getContentPaneHeight() {
        if (this._contentPaneHeight < 0) {
            return this.getContentPane().getPreferredSize().height;
        }
        return this._contentPaneHeight;
    }

    public void setContentPaneHeight(int n2) {
        this._contentPaneHeight = n2;
    }

    public int getContentPaneWidth() {
        if (this._contentPaneWidth < 0) {
            return this.getContentPane().getPreferredSize().width;
        }
        return this._contentPaneWidth;
    }

    public void setContentPaneWidth(int n2) {
        this._contentPaneWidth = n2;
    }

    public JComponent getActualComponent() {
        return this.\u010a;
    }

    public int getInitDelay() {
        return this.\u0105;
    }

    public void setInitDelay(int n2) {
        this.\u0105 = n2;
    }

    public int getStepDelay() {
        return this.\u011e;
    }

    public void setStepDelay(int n2) {
        this.\u011e = n2;
    }

    public int getSteps() {
        return this.\u0108;
    }

    public void setSteps(int n2) {
        this.\u0108 = n2;
    }

    public int getStyle() {
        return this.\u010b;
    }

    public void setStyle(int n2) {
        if (n2 == 0 || n2 == 1 || n2 == 2 || n2 == 3) {
            if (n2 == this.\u010b) {
                return;
            }
        } else {
            throw new IllegalArgumentException("Invalid style. Valid styles are DROPDOWN_STYLE, TREE_STYLE, PLAIN_STYLE and SEPARATOR_STYLE that are defined in CollapsiblePane.");
        }
        int n3 = this.\u010b;
        this.\u010b = n2;
        this.firePropertyChange(STYLE_PROPERTY, n3, this.\u010b);
    }

    public int getSlidingDirection() {
        return this.\u0118;
    }

    public void setSlidingDirection(int n2) {
        if (n2 != 1 && n2 != 5 && n2 != 7 && n2 != 3) {
            throw new IllegalArgumentException("Sliding direction can be either SwingConstants.NORTH or SwingConstants.SOUTH.");
        }
        int n3 = this.\u0118;
        this.\u0118 = n2;
        this.firePropertyChange(PROPERTY_SLIDING_DIRECTION, n3, n2);
    }

    public boolean isEmphasized() {
        return this.\u0107;
    }

    public void setEmphasized(boolean bl) {
        boolean bl2 = this.\u0107;
        if (this.\u0107 != bl) {
            this.\u0107 = bl;
            this.firePropertyChange(EMPHASIZED_PROPERTY, bl2, bl);
        }
    }

    public boolean isCollapsible() {
        return this.\u0115;
    }

    public void setCollapsible(boolean bl) {
        boolean bl2 = this.\u0115;
        if (this.\u0115 != bl) {
            this.\u0115 = bl;
            this.firePropertyChange(PROPERTY_COLLAPSIBLE, bl2, bl);
        }
    }

    public boolean isShowTitleBar() {
        return this.\u011c;
    }

    public void setShowTitleBar(boolean bl) {
        boolean bl2 = this.\u011c;
        if (bl2 != bl) {
            this.\u011c = bl;
            this.firePropertyChange(PROPERTY_SHOW_TITLE_BAR, bl2, this.\u011c);
        }
    }

    public boolean isShowExpandButton() {
        return this.\u011f;
    }

    public void setShowExpandButton(boolean bl) {
        boolean bl2 = this.\u011f;
        if (bl2 != bl) {
            this.\u011f = bl;
            this.firePropertyChange(PROPERTY_SHOW_EXPAND_BUTTON, bl2, this.\u011f);
        }
    }

    public void collapse(boolean bl) {
        if (!this.isVisible() || !this.isShowing()) {
            try {
                this.setCollapsed(bl);
            }
            catch (PropertyVetoException propertyVetoException) {}
        } else {
            Action action = this.getToggleAction();
            if (action != null) {
                if (this.isCollapsed() && !bl) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                } else if (!this.isCollapsed() && bl) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            }
        }
    }

    public boolean isFocusPainted() {
        return this.\u0119;
    }

    public void setFocusPainted(boolean bl) {
        boolean bl2 = this.\u0119;
        if (bl2 != bl) {
            this.\u0119 = bl;
            this.firePropertyChange(PROPERTY_FOCUS_PAINTED, bl2, this.\u0119);
            if (this.isFocusOwner()) {
                this.revalidate();
                this.repaint();
            }
        }
    }

    public boolean isContentAreaFilled() {
        return this.\u0111;
    }

    public void setContentAreaFilled(boolean bl) {
        boolean bl2 = this.\u0111;
        if (bl2 != bl) {
            this.\u0111 = bl;
            this.firePropertyChange(PROPERTY_CONTENTAREA_FILLED, bl2, this.\u0111);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isTitlePaneOpaque() {
        return this.\u010c;
    }

    public void setTitlePaneOpaque(boolean bl) {
        boolean bl2 = this.\u010c;
        if (bl2 != bl) {
            this.\u010c = bl;
            this.firePropertyChange(PROPERTY_TITLE_PANE_OPAQUE, bl2, this.\u010c);
            this.revalidate();
            this.repaint();
        }
    }

    public Component getTitleComponent() {
        return this.\u011a;
    }

    public void setTitleComponent(Component component) {
        Component component2 = this.\u011a;
        if (component2 != component) {
            this.\u011a = component;
            this.firePropertyChange(PROPERTY_TITLE_COMPONENT, component2, component);
        }
    }

    public void setTitleLabelComponent(JComponent jComponent) {
        JComponent jComponent2 = this.\u010d;
        if (jComponent2 != jComponent) {
            this.\u010d = jComponent;
            this.firePropertyChange(PROPERTY_TITLE_LABEL_COMPONENT, jComponent2, this.\u010d);
        }
    }

    public JComponent getTitleLabelComponent() {
        return this.\u010d;
    }

    public boolean isAutoExpandOnDragover() {
        return this.\u0120;
    }

    public void setAutoExpandOnDragover(boolean bl) {
        boolean bl2 = this.\u0120;
        if (bl2 != bl) {
            this.\u0120 = bl;
            this.firePropertyChange(PROPERTY_AUTO_EXPAND_ON_DRAGOVER, bl2, this.\u0120);
            this.updateUI();
        }
    }

    public boolean isRollover() {
        return this._rollover;
    }

    public void setRollover(boolean bl) {
        boolean bl2 = this._rollover;
        this._rollover = bl;
        if (bl2 != this._rollover) {
            this.firePropertyChange("rollover", bl2, this._rollover);
            this.repaint();
        }
    }

    public void setExpandedIcon(Icon icon) {
        Icon icon2 = this.\u0104;
        this.\u0104 = icon;
        this.firePropertyChange(PROPERTY_EXPANDED_ICON, icon2, icon);
    }

    public Icon getExpandedIcon() {
        return this.\u0104;
    }

    public void setCollapsedIcon(Icon icon) {
        Icon icon2 = this.\u011b;
        this.\u011b = icon;
        this.firePropertyChange(PROPERTY_COLLAPSED_ICON, icon2, icon);
    }

    public Icon getCollapsedIcon() {
        return this.\u011b;
    }

    public void setCollapsedPercentage(int n2) {
        int n3 = this._collapsedPercentage;
        this._collapsedPercentage = n2;
        this.firePropertyChange(PROPERTY_COLLAPSED_PERCENTAGE, n3, n2);
    }

    public int getCollapsedPercentage() {
        return this._collapsedPercentage;
    }

    public void setToggleAction(Action action) {
        Action action2 = this.\u0116;
        this.\u0116 = action;
        this.firePropertyChange(PROPERTY_TOGGLE_ACTION, action2, action);
    }

    public Action getToggleAction() {
        if (this.\u0116 == null && this.getUI() instanceof CollapsiblePaneUI) {
            return ((CollapsiblePaneUI)this.getUI()).getToggleAction();
        }
        return this.\u0116;
    }

    public boolean isContentBorderVisible() {
        return this.\u0109;
    }

    public void setContentBorderVisible(boolean bl) {
        boolean bl2 = this.\u0109;
        this.\u0109 = bl;
        if (bl2 != this.\u0109) {
            this.firePropertyChange(PROPERTY_CONTENT_BORDER_VISIBLE, bl2, this.\u0109);
            this.repaint();
            this.revalidate();
        }
    }

    public String getResourceString(String string) {
        return Resource.getResourceBundle(this.getLocale()).getString(string);
    }

    public Function getAnimationFunction() {
        return this.\u0112 == null ? CustomAnimation.FUNC_POW2 : this.\u0112;
    }

    public void setAnimationFunction(Function function) {
        this.\u0112 = function;
    }

    public Icon rotateIcon(Icon icon) {
        if (this.getSlidingDirection() == 7) {
            icon = IconsFactory.createRotatedImage(this, icon, 90.0);
        } else if (this.getSlidingDirection() == 1) {
            icon = IconsFactory.createRotatedImage(this, icon, 180.0);
        } else if (this.getSlidingDirection() == 3) {
            icon = IconsFactory.createRotatedImage(this, icon, 270.0);
        }
        return icon;
    }

    public boolean isRotateIcon() {
        return this.\u0122;
    }

    public void setRotateIcon(boolean bl) {
        this.\u0122 = bl;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2)) {
            Lm.showInvalidProductMessage(CollapsiblePane.class.getName(), 2);
        }
        \u0114 = Logger.getLogger(CollapsiblePane.class.getName());
    }

    class A
    extends JPanel
    implements Scrollable {
        public A() {
            this.setLayout(new BorderLayout());
        }

        public A(Component component) {
            this.setLayout(new BorderLayout());
            this.add(component);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle rectangle, int n2, int n3) {
            return 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle rectangle, int n2, int n3) {
            return 10;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            if (this.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)this.getParent();
                int n2 = jViewport.getWidth();
                Dimension dimension = this.getMinimumSize();
                Dimension dimension2 = this.getMaximumSize();
                if (n2 >= dimension.width && n2 <= dimension2.width) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (this.getParent() instanceof JViewport) {
                JViewport jViewport = (JViewport)this.getParent();
                int n2 = jViewport.getHeight();
                Dimension dimension = this.getPreferredSize();
                Dimension dimension2 = this.getMaximumSize();
                if (n2 >= dimension.height && n2 <= dimension2.height) {
                    return true;
                }
            }
            return false;
        }
    }

    protected class AccessibleCollapsiblePane
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long \u0101 = -3854196785760685510L;

        protected AccessibleCollapsiblePane() {
            super(CollapsiblePane.this);
        }

        @Override
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            return CollapsiblePane.this.getTitle();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            if (CollapsiblePane.this.isCollapsed()) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean setCurrentAccessibleValue(Number number) {
            if (number instanceof Integer) {
                try {
                    if (number.intValue() == 0) {
                        CollapsiblePane.this.setCollapsed(true);
                    } else {
                        CollapsiblePane.this.setCollapsed(false);
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
                return true;
            }
            return false;
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return Integer.MIN_VALUE;
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return Integer.MAX_VALUE;
        }
    }
}

