/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.marker;

import com.jidesoft.marker.Marker;
import com.jidesoft.marker.MarkerEvent;
import com.jidesoft.marker.MarkerListener;
import com.jidesoft.marker.MarkerModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import javax.swing.event.EventListenerList;

public class DefaultMarkerModel
implements MarkerModel,
PropertyChangeListener {
    protected List<Marker> _markers;
    private List<Marker> \u0102;
    private boolean \u0101 = true;
    protected boolean _isAdjusting;
    protected EventListenerList _listenerList = new EventListenerList();

    public DefaultMarkerModel() {
        this._markers = new Vector<Marker>();
    }

    @Override
    public synchronized List<Marker> getMarkers() {
        Collections.sort(this._markers, new Comparator<Marker>(){

            public int \u0101(Marker marker, Marker marker2) {
                int n2;
                int n3 = marker.getType();
                return n3 == (n2 = marker2.getType()) ? 0 : (n3 > n2 ? -1 : 1);
            }
        });
        if (this.\u0101) {
            this.\u0102 = Collections.unmodifiableList(new ArrayList<Marker>(this._markers));
            this.\u0101 = false;
        }
        return this.\u0102;
    }

    @Override
    public synchronized List<Marker> getMarkersAt(int n2, int n3) {
        Vector<Marker> vector = new Vector<Marker>();
        for (Marker marker : this._markers) {
            if (marker.getStartOffset() > n3 || marker.getEndOffset() < n2) continue;
            vector.add(marker);
        }
        return vector;
    }

    @Override
    public synchronized boolean isAdjusting() {
        return this._isAdjusting;
    }

    @Override
    public synchronized void setAdjusting(boolean bl) {
        this._isAdjusting = bl;
        if (!this.isAdjusting()) {
            this.fireMarkerChanged(null, 2, this.isAdjusting());
        }
    }

    @Override
    public synchronized Marker addMarker(int n2, int n3, int n4, String string) {
        Marker marker = this.createMarker(n2, n3, n4, string);
        marker.addPropertyChangeListener(this);
        boolean bl = this._markers.add(marker);
        if (bl) {
            this.\u0101 = true;
            this.fireMarkerChanged(marker, 0, this.isAdjusting());
            return marker;
        }
        return null;
    }

    protected Marker createMarker(int n2, int n3, int n4, String string) {
        return new Marker(n2, n3, n4, string);
    }

    @Override
    public synchronized void clearMarkers() {
        if (this._markers == null) {
            return;
        }
        for (Marker marker : this._markers) {
            marker.removePropertyChangeListener(this);
        }
        if (this._markers.size() > 0) {
            this._markers.clear();
            this.\u0101 = true;
            this.\u0102 = null;
            this.fireMarkerChanged(null, 1, this.isAdjusting());
        }
    }

    @Override
    public synchronized boolean removeMarker(Marker marker) {
        boolean bl = this._markers.remove(marker);
        if (bl) {
            if (marker != null) {
                marker.removePropertyChangeListener(this);
            }
            this.\u0101 = true;
            this.fireMarkerChanged(marker, 1, this.isAdjusting());
        }
        return bl;
    }

    @Override
    public synchronized void updateMarker(Marker marker) {
        this.fireMarkerChanged(marker, 2, this.isAdjusting());
    }

    protected void fireMarkerChanged(Marker marker, int n2, boolean bl) {
        Object[] objectArray = this._listenerList.getListenerList();
        MarkerEvent markerEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != MarkerListener.class) continue;
            if (markerEvent == null) {
                markerEvent = new MarkerEvent(this, marker, n2, bl);
            }
            ((MarkerListener)objectArray[i2 + 1]).markerChanged(markerEvent);
        }
    }

    @Override
    public void addMarkerListener(MarkerListener markerListener) {
        this._listenerList.add(MarkerListener.class, markerListener);
    }

    @Override
    public void removeMarkerListener(MarkerListener markerListener) {
        this._listenerList.remove(MarkerListener.class, markerListener);
    }

    @Override
    public MarkerListener[] getMarkerListeners() {
        return (MarkerListener[])this._listenerList.getListeners(MarkerListener.class);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof Marker) {
            this.updateMarker((Marker)propertyChangeEvent.getSource());
        }
    }
}

