/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.margin;

import com.jidesoft.margin.AbstractRowMarginSupport;
import com.jidesoft.margin.MarginSupport;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreeRowMarginSupport
extends AbstractRowMarginSupport {
    protected JTree _tree;
    private TreeModelListener \u010d;
    private TreeExpansionListener \u010b;
    private PropertyChangeListener \u010c;

    public TreeRowMarginSupport(JTree jTree, JScrollPane jScrollPane) {
        super(jScrollPane);
        this._tree = jTree;
    }

    @Override
    public int getRowCount() {
        return this._tree.getRowCount();
    }

    @Override
    public void scrollTo(int n2, int n3, boolean bl) {
        if (bl) {
            this._tree.getSelectionModel().clearSelection();
            TreePath[] treePathArray = new TreePath[Math.abs(n3 - n2) + 1];
            for (int i2 = 0; i2 < treePathArray.length; ++i2) {
                treePathArray[i2] = this._tree.getPathForRow(Math.min(n2, n3) + i2);
            }
            this._tree.getSelectionModel().addSelectionPaths(treePathArray);
        }
        this._tree.scrollRectToVisible(this._tree.getPathBounds(this._tree.getPathForRow(n3)));
    }

    @Override
    public int getRowHeight(int n2) {
        return this._tree.isFixedRowHeight() ? this._tree.getRowHeight() : this._tree.getRowBounds((int)n2).height;
    }

    @Override
    public int positionToRow(int n2) {
        int n3 = this.getViewPosition();
        return this._tree.getClosestRowForLocation(0, n3 + n2);
    }

    @Override
    public int rowToPosition(int n2) {
        Rectangle rectangle = this._tree.getRowBounds(n2);
        if (rectangle == null) {
            return Integer.MIN_VALUE;
        }
        int n3 = this.getViewPosition();
        return rectangle.y - n3;
    }

    @Override
    public void installListeners(MarginSupport.RepaintCallback repaintCallback, final MarginSupport.ModelChangedCallback modelChangedCallback) {
        super.installListeners(repaintCallback, modelChangedCallback);
        if (modelChangedCallback != null) {
            if (this.\u010d == null) {
                this.\u010d = new TreeModelListener(){

                    @Override
                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }

                    @Override
                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        modelChangedCallback.modelChanged(treeModelEvent);
                    }
                };
            }
            if (this.\u010b == null) {
                this.\u010b = new TreeExpansionListener(){

                    @Override
                    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                        modelChangedCallback.modelChanged(treeExpansionEvent);
                    }

                    @Override
                    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                        modelChangedCallback.modelChanged(treeExpansionEvent);
                    }
                };
            }
            if (this.\u010c == null) {
                this.\u010c = new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        Object object;
                        Object object2 = propertyChangeEvent.getOldValue();
                        if (object2 instanceof TreeModel) {
                            ((TreeModel)object2).removeTreeModelListener(TreeRowMarginSupport.this.\u010d);
                        }
                        if ((object = propertyChangeEvent.getNewValue()) instanceof TreeModel) {
                            ((TreeModel)object).addTreeModelListener(TreeRowMarginSupport.this.\u010d);
                        }
                        modelChangedCallback.modelChanged(propertyChangeEvent);
                    }
                };
            }
            this._tree.addPropertyChangeListener("model", this.\u010c);
            this._tree.addTreeExpansionListener(this.\u010b);
            this._tree.getModel().addTreeModelListener(this.\u010d);
        }
    }

    @Override
    public void uninstallListeners(MarginSupport.RepaintCallback repaintCallback, MarginSupport.ModelChangedCallback modelChangedCallback) {
        if (this.\u010c != null) {
            this._tree.removePropertyChangeListener("model", this.\u010c);
        }
        if (this.\u010b != null) {
            this._tree.removeTreeExpansionListener(this.\u010b);
        }
        if (this.\u010d != null) {
            this._tree.getModel().removeTreeModelListener(this.\u010d);
        }
        super.uninstallListeners(repaintCallback, modelChangedCallback);
    }
}

