/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class AbstractIntelliHints
implements IntelliHints {
    private JidePopup \u0102;
    private JTextComponent \u0105;
    private JComponent \u0108;
    private boolean \u0107 = false;
    private boolean \u010a = false;
    private boolean \u010b = true;
    private int \u0109 = 200;
    private List<KeyStroke> \u0101;
    private DelegateAction \u0104;
    private DelegateAction \u0106 = new DelegateAction(){
        private static final long \u012c = -2516216121942080133L;

        @Override
        public boolean isDelegateEnabled() {
            return AbstractIntelliHints.this.isHintsPopupVisible() && AbstractIntelliHints.this.getSelectedHint() != null;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
            if (intelliHints instanceof AbstractIntelliHints) {
                AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                abstractIntelliHints.hideHintsPopup();
                if (abstractIntelliHints.getSelectedHint() != null) {
                    abstractIntelliHints.setHintsEnabled(false);
                    abstractIntelliHints.acceptHint(intelliHints.getSelectedHint());
                    abstractIntelliHints.setHintsEnabled(true);
                    return true;
                }
            }
            return false;
        }
    };
    private DelegateAction \u0103 = new DelegateAction(){
        private static final long \u012a = 1921213578011852535L;

        @Override
        public boolean isDelegateEnabled() {
            return AbstractIntelliHints.this.\u0105.isEnabled() && AbstractIntelliHints.this.isHintsPopupVisible();
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            if (this.isEnabled()) {
                AbstractIntelliHints.this.hideHintsPopup();
                return true;
            }
            return false;
        }
    };
    private DocumentListener \u010c = new DocumentListener(){
        private Timer \u0102;
        {
            this.\u0102 = new Timer(AbstractIntelliHints.this.getShowHintsDelay(), new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (AbstractIntelliHints.this.\u0101()) {
                        if (AbstractIntelliHints.this.isHintsPopupVisible() || AbstractIntelliHints.this.isAutoPopup()) {
                            AbstractIntelliHints.this.showHintsPopup(true);
                        }
                        AbstractIntelliHints.this.\u0101(false);
                    }
                }
            });
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.\u0101();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        void \u0101() {
            if (this.\u0102.isRunning()) {
                this.\u0102.setInitialDelay(AbstractIntelliHints.this.getShowHintsDelay());
                this.\u0102.setDelay(AbstractIntelliHints.this.getShowHintsDelay());
                this.\u0102.restart();
            } else {
                this.\u0102.setRepeats(false);
                this.\u0102.setInitialDelay(AbstractIntelliHints.this.getShowHintsDelay());
                this.\u0102.setDelay(AbstractIntelliHints.this.getShowHintsDelay());
                this.\u0102.start();
            }
        }
    };

    public AbstractIntelliHints(JTextComponent jTextComponent) {
        KeyStroke[] keyStrokeArray;
        this.\u0105 = jTextComponent;
        this.getTextComponent().putClientProperty("INTELLI_HINTS", this);
        this.\u0102 = this.createPopup();
        this.getTextComponent().getDocument().addDocumentListener(this.\u010c);
        this.getTextComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (27 != keyEvent.getKeyCode() && 10 != keyEvent.getKeyCode()) {
                    AbstractIntelliHints.this.\u0101(true);
                }
            }
        });
        this.getTextComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                Container container = AbstractIntelliHints.this.\u0102.getTopLevelAncestor();
                if (container == null) {
                    return;
                }
                Component component = focusEvent.getOppositeComponent();
                if (container == component || container.isAncestorOf(component)) {
                    return;
                }
                AbstractIntelliHints.this.hideHintsPopup();
            }
        });
        this.\u0104 = new DelegateAction(){
            private static final long \u0131 = 2243999895981912016L;

            @Override
            public boolean delegateActionPerformed(ActionEvent actionEvent) {
                JComponent jComponent = (JComponent)actionEvent.getSource();
                IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
                if (intelliHints instanceof AbstractIntelliHints) {
                    AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                    if (jComponent.isEnabled() && !abstractIntelliHints.isHintsPopupVisible()) {
                        abstractIntelliHints.showHintsPopup(false);
                        return true;
                    }
                }
                return false;
            }

            @Override
            public boolean isDelegateEnabled() {
                return !AbstractIntelliHints.this.isHintsPopupVisible();
            }
        };
        this.addShowHintsKeyStroke(this.getShowHintsKeyStroke());
        for (KeyStroke keyStroke : keyStrokeArray = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, new A(keyStroke));
        }
    }

    protected JidePopup createPopup() {
        JidePopup jidePopup = JidePopupFactory.getSharedInstance().createPopup();
        jidePopup.setLayout(new BorderLayout());
        jidePopup.setResizable(true);
        jidePopup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        jidePopup.setMovable(false);
        jidePopup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), AbstractIntelliHints.this.\u0103);
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), AbstractIntelliHints.this.\u0106);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }
        });
        jidePopup.setTransient(true);
        jidePopup.setKeepPreviousSize(false);
        jidePopup.setReturnFocusToOwner(false);
        return jidePopup;
    }

    public JTextComponent getTextComponent() {
        return this.\u0105;
    }

    @Override
    public void acceptHint(Object object) {
        String string;
        int n2;
        String string2;
        if (object == null) {
            return;
        }
        int n3 = this.getTextComponent().getCaretPosition();
        if (this.isMultilineTextComponent()) {
            string2 = this.getTextComponent().getText();
            n2 = string2.lastIndexOf(10, n3 - 1);
            String string3 = n3 == -1 ? "" : string2.substring(n3);
            string2 = string2.substring(0, n2 + 1);
            string2 = string2 + object;
            string = string2 = string2 + string3;
        } else {
            string = object.toString();
        }
        this.getTextComponent().setText(string);
        string2 = this.getTextComponent().getText();
        n2 = string2.indexOf(10, n3);
        this.getTextComponent().setCaretPosition(n2 == -1 ? string2.length() : n2);
    }

    protected boolean isMultilineTextComponent() {
        return this.getTextComponent() instanceof JTextArea || this.getTextComponent() instanceof JEditorPane;
    }

    protected void showHintsPopup(boolean bl) {
        if (!(this.getTextComponent().isEnabled() && this.getTextComponent().isEditable() && this.getTextComponent().hasFocus())) {
            return;
        }
        this.showHints(bl);
    }

    @Override
    public boolean updateHints(Object object) {
        return false;
    }

    @Override
    public boolean updateHints(Object object, boolean bl) {
        return this.updateHints(object);
    }

    public void showHints(boolean bl) {
        if (this.\u0102 == null) {
            return;
        }
        if (this.\u0108 == null) {
            this.\u0108 = this.createHintsComponent();
            this.\u0102.add(this.\u0108);
            this.getDelegateComponent().setRequestFocusEnabled(false);
            this.getDelegateComponent().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    AbstractIntelliHints.this.hideHintsPopup();
                    AbstractIntelliHints.this.setHintsEnabled(false);
                    AbstractIntelliHints.this.acceptHint(AbstractIntelliHints.this.getSelectedHint());
                    AbstractIntelliHints.this.setHintsEnabled(true);
                }
            });
        }
        if (this.updateHints(this.getContext(), bl)) {
            if (!this.isHintsPopupVisible()) {
                DelegateAction.replaceAction(this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), this.\u0103);
                DelegateAction.replaceAction((JComponent)this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), this.\u0106, true);
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            try {
                int n5 = this.getCaretPositionForPopup();
                Rectangle rectangle = this.getCaretRectangleForPopup(n5);
                n3 = rectangle.y;
                n2 = rectangle.x;
                n4 = rectangle.height;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.\u0102.setOwner(this.getTextComponent());
            this.\u0102.showPopup(new Insets(n3, n2, this.getTextComponent().getHeight() - n4 - n3, 0));
        } else {
            this.\u0102.hidePopup();
        }
    }

    protected Rectangle getCaretRectangleForPopup(int n2) throws BadLocationException {
        return this.getTextComponent().getUI().modelToView(this.getTextComponent(), n2);
    }

    protected int getCaretPositionForPopup() {
        int n2 = Math.min(this.getTextComponent().getCaret().getDot(), this.getTextComponent().getCaret().getMark());
        if (this.isFollowCaret()) {
            return n2;
        }
        try {
            Rectangle rectangle = this.getTextComponent().getUI().modelToView(this.getTextComponent(), n2);
            rectangle.x = 0;
            return this.getTextComponent().getUI().viewToModel(this.getTextComponent(), rectangle.getLocation());
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
    }

    protected Object getContext() {
        if (this.isMultilineTextComponent()) {
            int n2 = this.getTextComponent().getCaretPosition();
            if (n2 == 0) {
                return "";
            }
            String string = this.getTextComponent().getText();
            int n3 = string.lastIndexOf(10, n2 - 1);
            return string.substring(n3 + 1, n2);
        }
        return this.getTextComponent().getText();
    }

    protected void hideHintsPopup() {
        if (this.\u0102 != null) {
            this.\u0102.hidePopup();
        }
        this.\u0101(false);
    }

    public void setHintsEnabled(boolean bl) {
        if (!bl) {
            this.getTextComponent().getDocument().removeDocumentListener(this.\u010c);
        } else {
            this.getTextComponent().getDocument().addDocumentListener(this.\u010c);
        }
    }

    public boolean isHintsPopupVisible() {
        return this.\u0102 != null && this.\u0102.isPopupVisible();
    }

    public boolean isFollowCaret() {
        return this.\u0107;
    }

    public void setFollowCaret(boolean bl) {
        this.\u0107 = bl;
    }

    public boolean isAutoPopup() {
        return this.\u010b;
    }

    public void setAutoPopup(boolean bl) {
        this.\u010b = bl;
    }

    protected abstract KeyStroke[] getDelegateKeyStrokes();

    protected abstract JComponent getDelegateComponent();

    protected KeyStroke getShowHintsKeyStroke() {
        if (this.isMultilineTextComponent()) {
            return KeyStroke.getKeyStroke(32, 2);
        }
        return KeyStroke.getKeyStroke(40, 0);
    }

    private boolean \u0101() {
        return this.\u010a;
    }

    private void \u0101(boolean bl) {
        this.\u010a = bl;
    }

    public int getShowHintsDelay() {
        return this.\u0109;
    }

    public void setShowHintsDelay(int n2) {
        this.\u0109 = n2;
    }

    public void addShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this.\u0101 == null) {
            this.\u0101 = new ArrayList<KeyStroke>();
        }
        this.\u0101.add(keyStroke);
        DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, this.\u0104);
    }

    public void removeShowHintsKeyStroke(KeyStroke keyStroke) {
        if (this.\u0101 != null) {
            this.\u0101.remove(keyStroke);
            DelegateAction.restoreAction((JComponent)this.getTextComponent(), 0, keyStroke, this.\u0104);
        }
    }

    public KeyStroke[] getAllShowHintsKeyStrokes() {
        if (this.\u0101 == null) {
            return new KeyStroke[0];
        }
        return this.\u0101.toArray(new KeyStroke[this.\u0101.size()]);
    }

    public static IntelliHints getIntelliHints(JComponent jComponent) {
        return (IntelliHints)jComponent.getClientProperty("INTELLI_HINTS");
    }

    private class A
    extends DelegateAction {
        private KeyStroke \u012e;
        private static final long \u012f = -5799290233797844786L;

        public A(KeyStroke keyStroke) {
            this.\u012e = keyStroke;
        }

        @Override
        public boolean isDelegateEnabled() {
            Action action = this.\u0102();
            return action != null && action.isEnabled();
        }

        private Action \u0102() {
            if (AbstractIntelliHints.this.isHintsPopupVisible() && AbstractIntelliHints.this.getDelegateComponent() != null) {
                Object object = AbstractIntelliHints.this.getDelegateComponent().getInputMap().get(this.\u012e);
                Object object2 = object = object == null ? AbstractIntelliHints.this.getTextComponent().getInputMap(1).get(this.\u012e) : object;
                if (object != null) {
                    return AbstractIntelliHints.this.getDelegateComponent().getActionMap().get(object);
                }
            }
            return null;
        }

        @Override
        public boolean delegateActionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = (JComponent)actionEvent.getSource();
            IntelliHints intelliHints = AbstractIntelliHints.getIntelliHints(jComponent);
            if (intelliHints instanceof AbstractIntelliHints) {
                AbstractIntelliHints abstractIntelliHints = (AbstractIntelliHints)intelliHints;
                if (jComponent.isEnabled() && abstractIntelliHints.isHintsPopupVisible()) {
                    Action action;
                    Object object = abstractIntelliHints.getDelegateComponent().getInputMap().get(this.\u012e);
                    Object object2 = object = object == null ? abstractIntelliHints.getTextComponent().getInputMap(1).get(this.\u012e) : object;
                    if (object != null && (action = abstractIntelliHints.getDelegateComponent().getActionMap().get(object)) instanceof Action) {
                        action.actionPerformed(new ActionEvent(abstractIntelliHints.getDelegateComponent(), 0, "" + object));
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

