/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.grid;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.grid.CompoundTableModelEvent;
import com.jidesoft.grid.ContextSensitiveTableModel;
import com.jidesoft.grid.EditorContext;
import com.jidesoft.grid.MultiTableModel;
import com.jidesoft.paging.PageNavigationEvent;
import com.jidesoft.paging.PageNavigationListener;
import com.jidesoft.paging.PageNavigationSupport;
import com.jidesoft.utils.Lm;
import com.jidesoft.utils.Q;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPageTableModel
extends AbstractTableModel
implements ContextSensitiveTableModel,
MultiTableModel,
PageNavigationSupport,
TableModelListener {
    private static final long \u0c33 = 5801822175946179395L;
    private int \u0c30 = 10;
    private int \u0c32 = -1;
    private int \u0c31;
    private TableModelEvent \u0c2e;
    private static final Logger \u0c2d;
    private transient int \u0c2f = -1;
    private transient boolean \u0c2c = true;

    public AbstractPageTableModel() {
    }

    public AbstractPageTableModel(int n2) {
        this.\u0c30 = n2;
    }

    @Override
    public int getPageSize() {
        return this.\u0c30 == 0 ? 10 : this.\u0c30;
    }

    @Override
    public void setPageSize(int n2) {
        int n3 = this.\u0c30;
        if (n3 != n2) {
            this.\u0c30 = n2;
            this.pageSizeChanged(n3, this.getPageSize());
            this.firePageNavigationEvent(this, 14100, n3, this.getPageSize());
        }
    }

    @Override
    public int getCurrentPage() {
        return this.\u0c32;
    }

    @Override
    public void setCurrentPage(int n2) {
        this.\u0104(n2, false);
    }

    void \u0104(int n2, boolean bl) {
        int n3 = this.\u0c32;
        if (bl || n3 != n2 && (this.getPageCount() < 0 || n2 <= this.getPageCount() - 1) && n2 >= 0) {
            this.\u0c32 = n2;
            this.pageIndexChanged(n3, this.\u0c32);
            this.firePageNavigationEvent(this, 14101, n3, this.\u0c32);
            if (this.\u0c2c) {
                this.\u01da();
            }
        }
    }

    private void \u01da() {
        this.\u0c2f = this.getPageSize() > 0 ? this.getCurrentPage() * this.getPageSize() : 0;
    }

    protected void setPageCount(int n2) {
        int n3 = this.\u0c31;
        if (n3 != n2) {
            this.\u0c31 = n2;
            this.pageCountChanged(n3, this.\u0c31);
            this.firePageNavigationEvent(this, 14099, n3, this.\u0c31);
            if (this.getCurrentPage() >= this.getPageCount()) {
                this.setCurrentPage(this.getPageCount() - 1);
            } else if (this.getCurrentPage() < 0) {
                this.setCurrentPage(0);
            }
        }
    }

    @Override
    public int getPageCount() {
        return this.\u0c31;
    }

    @Override
    public void nextPage() {
        int n2 = this.getCurrentPage();
        if (n2 < this.getPageCount() - 1) {
            this.setCurrentPage(n2 + 1);
        }
    }

    @Override
    public void previousPage() {
        int n2 = this.getCurrentPage();
        if (n2 > 0) {
            this.setCurrentPage(n2 - 1);
        }
    }

    @Override
    public void firstPage() {
        if (this.getCurrentPage() > 0) {
            this.setCurrentPage(0);
        }
    }

    @Override
    public void lastPage() {
        int n2 = this.getPageCount();
        if (this.getCurrentPage() < n2 - 1) {
            this.setCurrentPage(n2 - 1);
        }
    }

    @Override
    public void addPageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.add(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public void removePageNavigationListener(PageNavigationListener pageNavigationListener) {
        this.listenerList.remove(PageNavigationListener.class, pageNavigationListener);
    }

    @Override
    public PageNavigationListener[] getPageNavigationListeners() {
        return (PageNavigationListener[])this.listenerList.getListeners(PageNavigationListener.class);
    }

    @Override
    public void firePageNavigationEvent(Object object, int n2, int n3, int n4) {
        if (object == null) {
            object = this;
        }
        if (\u0c2d.isLoggable(Level.FINE)) {
            switch (n2) {
                case 14099: {
                    \u0c2d.fine("Total page count is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14100: {
                    \u0c2d.fine("Page size is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
                case 14101: {
                    \u0c2d.fine("The current page index is changed from " + n3 + " => " + n4 + ", source is " + object.getClass().getName());
                    break;
                }
            }
        }
        Object[] objectArray = this.listenerList.getListenerList();
        PageNavigationEvent pageNavigationEvent = new PageNavigationEvent(object, n2, n3, n4);
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PageNavigationListener.class) continue;
            ((PageNavigationListener)objectArray[i2 + 1]).pageNavigationEventFired(pageNavigationEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pageSizeChanged(int n2, int n3) {
        int n4 = this.getCurrentPage();
        int n5 = this.getTotalRecordCount();
        if (n5 >= 0) {
            this.setPageCount(n5 / n3 + (n5 % n3 == 0 ? 0 : 1));
        } else {
            this.setPageCount(-1);
        }
        this.\u0c2c = false;
        try {
            if (this.\u0c2f > 0) {
                this.setCurrentPage(this.\u0c2f / n3);
            } else {
                this.setCurrentPage(0);
            }
        }
        finally {
            this.\u0c2c = true;
        }
        int n6 = this.getCurrentPage();
        if (n6 == n4) {
            this.pageIndexChanged(n4, n6);
        }
    }

    protected abstract void pageCountChanged(int var1, int var2);

    protected abstract void pageIndexChanged(int var1, int var2);

    @Override
    public synchronized int getRowCount() {
        int n2 = this.getCurrentPage();
        int n3 = this.getTotalRecordCount();
        if (n3 >= 0 && n3 <= this.getPageSize()) {
            return n3;
        }
        if (this.getPageCount() >= 0 && n2 == this.getPageCount() - 1) {
            return n3 - n2 * this.getPageSize();
        }
        return this.getPageSize();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            this.\u0c2e = ((CompoundTableModelEvent)tableModelEvent).getOriginalEvent();
        }
        try {
            switch (tableModelEvent.getType()) {
                case 1: {
                    this.tableRowsInserted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case -1: {
                    this.tableRowsDeleted(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    return;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        this.tableStructureChanged();
                        return;
                    } else if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        if (tableModelEvent instanceof CompoundTableModelEvent) {
                            this.\u0101((CompoundTableModelEvent)tableModelEvent);
                            return;
                        } else {
                            this.tableDataChanged();
                            return;
                        }
                    } else if (tableModelEvent.getColumn() == -1) {
                        this.tableRowsUpdated(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    } else {
                        this.tableCellsUpdated(tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        return;
                    }
                }
                default: {
                    throw new IllegalArgumentException("Unknown TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        finally {
            this.\u0c2e = null;
        }
    }

    private int[] \u010a(int n2, int n3) {
        int n4;
        int n5 = this.getCurrentPage();
        int n6 = n5 * (n4 = this.getPageSize());
        if (n3 < n6) {
            return null;
        }
        int n7 = Math.min(this.getTotalRecordCount() - 1, n6 + n4);
        if (n2 > n7) {
            return null;
        }
        return new int[]{Math.max(n2, n6) % n4, Math.min(n3, n7) % n4};
    }

    protected void tableRowsInserted(int n2, int n3) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.\u0105(compoundTableModelEvent, n2, n3);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void \u0105(CompoundTableModelEvent compoundTableModelEvent, int n2, int n3) {
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n3, -1, 1));
    }

    protected void tableRowsDeleted(int n2, int n3) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.\u0106(compoundTableModelEvent, n2, n3);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void \u0106(CompoundTableModelEvent compoundTableModelEvent, int n2, int n3) {
        compoundTableModelEvent.addEvent(new TableModelEvent(this, n2, n3, -1, -1));
    }

    protected void tableRowsUpdated(int n2, int n3) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.\u0104(compoundTableModelEvent, n2, n3);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    private void \u0104(CompoundTableModelEvent compoundTableModelEvent, int n2, int n3) {
        int[] nArray = this.\u010a(n2, n3);
        if (nArray != null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], -1, 0));
        }
    }

    public void fireTableCellsUpdated(int n2, int n3, int n4) {
        this.fireTableChanged(new TableModelEvent(this, n2, n3, n4));
    }

    protected void tableCellsUpdated(int n2, int n3, int n4) {
        CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
        this.\u0102(compoundTableModelEvent, n2, n3, n4);
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
    }

    protected CompoundTableModelEvent createCompoundTableModelEvent() {
        CompoundTableModelEvent compoundTableModelEvent = new CompoundTableModelEvent(this);
        compoundTableModelEvent.setOriginalEvent(this.\u0c2e);
        return compoundTableModelEvent;
    }

    private void \u0102(CompoundTableModelEvent compoundTableModelEvent, int n2, int n3, int n4) {
        int[] nArray = this.\u010a(n3, n4);
        if (nArray != null) {
            compoundTableModelEvent.addEvent(new TableModelEvent(this, nArray[0], nArray[1], n2));
        }
    }

    private void \u0101(CompoundTableModelEvent compoundTableModelEvent) {
        if (compoundTableModelEvent == null || compoundTableModelEvent.getEvents() == null || compoundTableModelEvent.getEvents().length <= 0) {
            this.tableDataChanged();
            return;
        }
        CompoundTableModelEvent compoundTableModelEvent2 = this.createCompoundTableModelEvent();
        block5: for (TableModelEvent tableModelEvent : compoundTableModelEvent.getEvents()) {
            switch (tableModelEvent.getType()) {
                case 1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, 1));
                    continue block5;
                }
                case -1: {
                    compoundTableModelEvent2.addEvent(new TableModelEvent(this, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow(), -1, -1));
                    continue block5;
                }
                case 0: {
                    if (tableModelEvent.getFirstRow() == -1) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this, -1));
                        continue block5;
                    }
                    if (tableModelEvent.getLastRow() == Integer.MAX_VALUE) {
                        compoundTableModelEvent2.addEvent(new TableModelEvent(this));
                        continue block5;
                    }
                    if (tableModelEvent.getColumn() == -1) {
                        this.\u0104(compoundTableModelEvent2, tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                        continue block5;
                    }
                    this.\u0102(compoundTableModelEvent2, tableModelEvent.getColumn(), tableModelEvent.getFirstRow(), tableModelEvent.getLastRow());
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown Embedded TableModelEvent type: " + tableModelEvent.getType());
                }
            }
        }
        CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent2);
    }

    protected void tableDataChanged() {
        this.fireTableDataChanged();
    }

    protected void tableStructureChanged() {
        this.fireTableStructureChanged();
    }

    @Override
    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (tableModelEvent instanceof CompoundTableModelEvent) {
            super.fireTableChanged(tableModelEvent);
        } else {
            CompoundTableModelEvent compoundTableModelEvent = this.createCompoundTableModelEvent();
            compoundTableModelEvent.addEvent(tableModelEvent);
            CompoundTableModelEvent.fireTableModelEvent(this, compoundTableModelEvent);
        }
    }

    @Override
    public ConverterContext getConverterContextAt(int n2, int n3) {
        return null;
    }

    @Override
    public EditorContext getEditorContextAt(int n2, int n3) {
        return null;
    }

    @Override
    public Class<?> getCellClassAt(int n2, int n3) {
        return this.getColumnClass(n3);
    }

    @Override
    public int getColumnType(int n2) {
        return 0;
    }

    @Override
    public int getTableIndex(int n2) {
        return 0;
    }

    static {
        try {
            if (Lm.class.getDeclaredMethods().length != 29 && Lm.class.getDeclaredMethods().length != 31) {
                System.err.println("The Lm class is invalid, exiting ... " + Lm.class.getDeclaredMethods().length);
                System.exit(-1);
            }
        }
        catch (Exception exception) {
            System.exit(-1);
        }
        if (!Q.zz(2048)) {
            Lm.showInvalidProductMessage(AbstractPageTableModel.class.getName(), 2048);
        }
        \u0c2d = Logger.getLogger(PageNavigationEvent.class.getName());
    }
}

