/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.editor.margin;

import com.jidesoft.editor.CodeEditor;
import com.jidesoft.editor.Span;
import com.jidesoft.editor.margin.AbstractMargin;
import com.jidesoft.editor.margin.CodeFoldingMargin;
import com.jidesoft.editor.margin.CodeFoldingPainter;
import com.jidesoft.icons.IconsFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.swing.Icon;

public class DefaultCodeFoldingPainter
implements CodeFoldingPainter {
    private static final Icon \u0102 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom.png");
    private static final Icon \u0105 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top.png");
    private static final Icon \u0106 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed.png");
    private static final Icon \u0107 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened.png");
    private static final Icon \u0103 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_bottom_r.png");
    private static final Icon \u0109 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_top_r.png");
    private static final Icon \u0108 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_closed_r.png");
    private static final Icon \u0101 = IconsFactory.getImageIcon(CodeFoldingMargin.class, "icons/folding_opened_r.png");
    private static final BasicStroke \u0104 = new BasicStroke(1.0f, 2, 1, 1.0f, new float[]{0.0f, 2.0f, 0.0f, 2.0f}, 0.0f);

    @Override
    public int paintFoldingStart(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? \u0109 : \u0105;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 + icon.getIconHeight() / 2;
    }

    @Override
    public int paintFoldingEnd(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? \u0103 : \u0102;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2);
        return rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2;
    }

    @Override
    public void paintCollapsedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? \u0108 : \u0106;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    @Override
    public void paintExpandedFolding(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        Icon icon = n2 == 2 ? \u0101 : \u0107;
        icon.paintIcon(component, graphics, rectangle.x + rectangle.width / 2 - icon.getIconWidth() / 2, rectangle.y + rectangle.height / 2 - icon.getIconHeight() / 2 - 1);
    }

    @Override
    public void paintFoldingLine(Component component, Graphics graphics, Span span, Rectangle rectangle, int n2) {
        if (n2 == 2) {
            graphics.setColor(Color.BLACK);
            int n3 = rectangle.x + rectangle.width / 2;
            graphics.drawLine(n3, rectangle.y, n3, rectangle.y + rectangle.height);
        }
    }

    @Override
    public void paintBackground(Component component, Graphics graphics, Rectangle rectangle) {
        int n2 = rectangle.x + rectangle.width / 2;
        int n3 = rectangle.height;
        Color color = graphics.getColor();
        Stroke stroke = ((Graphics2D)graphics).getStroke();
        graphics.setColor(component.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, n2, n3);
        if (component instanceof AbstractMargin && ((AbstractMargin)component).getCodeEditor() != null) {
            CodeEditor codeEditor = ((AbstractMargin)component).getCodeEditor();
            graphics.setColor(codeEditor.getPainter().getBackground());
        } else {
            graphics.setColor(Color.WHITE);
        }
        graphics.fillRect(rectangle.x + n2 + 1, rectangle.y, n2, n3);
        graphics.setColor(Color.GRAY);
        ((Graphics2D)graphics).setStroke(\u0104);
        graphics.drawLine(n2, 0, n2, n3);
        graphics.setColor(color);
        ((Graphics2D)graphics).setStroke(stroke);
    }

    @Override
    public int getPreferredWidth() {
        return \u0102.getIconWidth() + 4;
    }
}

