/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.ant;

import com.yworks.yguard.ObfuscatorTask;
import com.yworks.yguard.ant.Mappable;
import com.yworks.yguard.ant.PatternMatchedClassesSection;
import com.yworks.yguard.common.ant.YGuardBaseTask;
import com.yworks.yguard.obf.LineNumberTableMapper;
import com.yworks.yguard.obf.YGuardRule;
import com.yworks.yguard.obf.classfile.LineNumberTableAttrInfo;
import java.io.PrintWriter;
import java.util.Collection;

public final class LineNumberTableSection
extends PatternMatchedClassesSection
implements Mappable {
    private YGuardBaseTask obfuscatorTask;
    private LineNumberTableMapper mapper;

    public LineNumberTableSection(YGuardBaseTask obfuscatorTask) {
        this.obfuscatorTask = obfuscatorTask;
        this.allowMatchAllPatternSet = true;
    }

    @Override
    public void addEntries(Collection entries, String className) {
        YGuardRule rule = this.createRule(className);
        entries.add(rule);
    }

    private YGuardRule createRule(String className) {
        if (this.mapper == null) {
            this.mapper = this.createMapper();
        }
        return new YGuardRule(className, this.mapper);
    }

    private LineNumberTableMapper createMapper() {
        LineNumberTableMapper lntMapper = null;
        if (this.properties.containsKey("mapping-scheme")) {
            String ms = (String)this.properties.get("mapping-scheme");
            if ("squeeze".equals(ms)) {
                lntMapper = new ObfuscatorTask.LineNumberSqueezer();
            } else if ("scramble".equals(ms)) {
                long saltValue = (long)(Math.random() * 4242.0);
                if (this.properties.containsKey("scrambling-salt")) {
                    String salt = (String)this.properties.get("scrambling-salt");
                    try {
                        saltValue = Long.parseLong(salt);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                lntMapper = new ObfuscatorTask.MyLineNumberTableMapper(saltValue);
            }
        }
        if (lntMapper == null) {
            lntMapper = new LineNumberTableMapper(){

                @Override
                public boolean mapLineNumberTable(String className, String methodName, String methodSignature, LineNumberTableAttrInfo lineNumberTable) {
                    return true;
                }

                @Override
                public void logProperties(PrintWriter pw) {
                }
            };
        }
        return lntMapper;
    }

    @Override
    public void addMapEntries(Collection entries) {
    }
}

