/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.parser.v2;

import java.io.Externalizable;
import java.io.IOException;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLOutputStream;
import oracle.xml.parser.v2.XMLPI;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.scalable.InfosetReader;
import oracle.xml.scalable.InfosetWriter;
import oracle.xml.util.QxNameHash;
import org.w3c.dom.DOMException;

public class XMLDeclPI
extends XMLPI
implements Externalizable {
    boolean textDecl;
    String encoding;
    String standalone;
    String version;
    static String defaultEncoding = "UTF-8";
    static String defaultVersion = "1.0";
    static String defaultStandalone = "no";

    public XMLDeclPI() {
        super("xml");
    }

    public XMLDeclPI(String string, String string2, String string3, boolean bl) {
        super("xml");
        this.textDecl = bl;
        this.version = string;
        this.encoding = string2;
        this.standalone = string3;
    }

    XMLDeclPI(XMLDocument xMLDocument) {
        super(xMLDocument);
        this.xdkSetQxName(QxNameHash.create("", "xml", "", "xml"));
    }

    @Override
    public String getData() throws DOMException {
        String string = this.xdkGetNodeValue();
        if (string != null) {
            return string;
        }
        if (!this.textDecl) {
            string = "version = '" + this.version + "'";
            if (this.encoding != null) {
                string = string + " " + "encoding" + " = '" + this.encoding + "'";
            }
            if (this.standalone != null) {
                string = string + " " + "standalone" + " = '" + this.standalone + "'";
            }
        } else {
            if (this.version != null) {
                string = "version = '" + this.version + "' ";
            }
            string = string + "encoding" + " = '" + this.encoding + "'";
        }
        this.xdkSetNodeValue(string);
        return string;
    }

    @Override
    public String getNodeValue() throws DOMException {
        return this.getData();
    }

    @Override
    public boolean checkTypeNSName(int n, String string, String string2) {
        return false;
    }

    public final String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return defaultVersion;
    }

    public final void setVersion(String string) {
        this.xdkSetNodeValue(null);
        this.version = string;
    }

    public final String getEncoding() {
        if (this.encoding != null) {
            return this.encoding;
        }
        return XMLParser.getXDKDefaultEncoding(defaultEncoding);
    }

    public final void setEncoding(String string) {
        this.xdkSetNodeValue(null);
        this.encoding = string;
    }

    public final String getStandalone() {
        if (this.standalone != null) {
            return this.standalone;
        }
        return defaultStandalone;
    }

    public final boolean setStandalone(String string) {
        this.xdkSetNodeValue(null);
        this.standalone = string;
        return string != null && string.equalsIgnoreCase("yes");
    }

    @Override
    XMLNode xdkCopyNode(XMLDocument xMLDocument, int n) {
        XMLDeclPI xMLDeclPI = (XMLDeclPI)xMLDocument.createNodeFromType((short)15);
        xMLDeclPI.version = this.version;
        xMLDeclPI.standalone = this.standalone;
        xMLDeclPI.encoding = this.encoding;
        xMLDeclPI.textDecl = this.textDecl;
        short s = this.getUserDataHandlerOpcode(n);
        this.callUserDataHandlers(s, xMLDeclPI);
        return xMLDeclPI;
    }

    public static void printXMLDecl(XMLOutputStream xMLOutputStream, String string, String string2, String string3) throws IOException {
        xMLOutputStream.writeIndent();
        xMLOutputStream.writeChars("<?");
        String string4 = "version = '" + string + "'";
        if (string2 != null) {
            string4 = string4 + " " + "encoding" + " = '" + string2 + "'";
        }
        if (string3 != null) {
            string4 = string4 + " " + "standalone" + " = '" + string3 + "'";
        }
        xMLOutputStream.writeChars("xml " + string4);
        xMLOutputStream.writeChars("?>");
        xMLOutputStream.writeNewLine();
        xMLOutputStream.flush();
    }

    @Override
    void print(XMLOutputStream xMLOutputStream, boolean bl) throws IOException {
        if (bl == this.isNodeFlag(128)) {
            xMLOutputStream.writeIndent();
            xMLOutputStream.writeChars("<?");
            xMLOutputStream.writeChars(this.getNodeName() + " " + this.getData());
            xMLOutputStream.writeChars("?>");
            xMLOutputStream.writeNewLine();
        }
    }

    void writeNodeInfo(InfosetWriter infosetWriter, boolean bl) {
        infosetWriter.createEvent(7);
        infosetWriter.setVersion(this.getVersion());
        infosetWriter.setEncoding(this.getEncoding());
        infosetWriter.setStandalone(this.getStandalone());
        infosetWriter.save();
    }

    @Override
    void readNodeInfo(InfosetReader infosetReader, boolean bl) {
        this.setVersion(infosetReader.getVersion());
        this.setEncoding(infosetReader.getEncoding());
        this.setStandalone(infosetReader.getStandalone());
    }
}

