/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.ParseException;
import com.yworks.yguard.obf.Cl;
import com.yworks.yguard.obf.ClassTree;
import com.yworks.yguard.obf.Tools;
import com.yworks.yguard.obf.classfile.AbstractDynamicCpInfo;
import com.yworks.yguard.obf.classfile.AbstractTypeCpInfo;
import com.yworks.yguard.obf.classfile.AnnotationDefaultAttrInfo;
import com.yworks.yguard.obf.classfile.AnnotationInfo;
import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.BootstrapMethod;
import com.yworks.yguard.obf.classfile.BootstrapMethodsAttrInfo;
import com.yworks.yguard.obf.classfile.ClassConstants;
import com.yworks.yguard.obf.classfile.ClassCpInfo;
import com.yworks.yguard.obf.classfile.ClassItemInfo;
import com.yworks.yguard.obf.classfile.CodeAttrInfo;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.CpInfo;
import com.yworks.yguard.obf.classfile.DoubleCpInfo;
import com.yworks.yguard.obf.classfile.DynamicCpInfo;
import com.yworks.yguard.obf.classfile.ElementValueInfo;
import com.yworks.yguard.obf.classfile.ElementValuePairInfo;
import com.yworks.yguard.obf.classfile.EnclosingMethodAttrInfo;
import com.yworks.yguard.obf.classfile.FieldInfo;
import com.yworks.yguard.obf.classfile.FieldrefCpInfo;
import com.yworks.yguard.obf.classfile.InnerClassesAttrInfo;
import com.yworks.yguard.obf.classfile.InnerClassesInfo;
import com.yworks.yguard.obf.classfile.InvokeDynamicCpInfo;
import com.yworks.yguard.obf.classfile.LineNumberTableAttrInfo;
import com.yworks.yguard.obf.classfile.LocalVariableInfo;
import com.yworks.yguard.obf.classfile.LocalVariableTableAttrInfo;
import com.yworks.yguard.obf.classfile.LocalVariableTypeInfo;
import com.yworks.yguard.obf.classfile.LocalVariableTypeTableAttrInfo;
import com.yworks.yguard.obf.classfile.Logger;
import com.yworks.yguard.obf.classfile.LongCpInfo;
import com.yworks.yguard.obf.classfile.MethodHandleCpInfo;
import com.yworks.yguard.obf.classfile.MethodInfo;
import com.yworks.yguard.obf.classfile.MethodTypeCpInfo;
import com.yworks.yguard.obf.classfile.MethodrefCpInfo;
import com.yworks.yguard.obf.classfile.ModuleAttrInfo;
import com.yworks.yguard.obf.classfile.ModuleCpInfo;
import com.yworks.yguard.obf.classfile.NameAndTypeCpInfo;
import com.yworks.yguard.obf.classfile.NameMapper;
import com.yworks.yguard.obf.classfile.PackageCpInfo;
import com.yworks.yguard.obf.classfile.ParameterAnnotationInfo;
import com.yworks.yguard.obf.classfile.RefCpInfo;
import com.yworks.yguard.obf.classfile.RuntimeVisibleAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeVisibleParameterAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.SignatureAttrInfo;
import com.yworks.yguard.obf.classfile.SourceFileAttrInfo;
import com.yworks.yguard.obf.classfile.StringCpInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class ClassFile
implements ClassConstants {
    public static final String SEP_REGULAR = "/";
    public static final String SEP_INNER = "$";
    public static final String LOG_DANGER_HEADER1 = "Methods are called which may break in obfuscated version at runtime.";
    public static final String LOG_DANGER_HEADER2 = "Please review your source code to ensure that the dangerous methods are not intended";
    public static final String LOG_DANGER_HEADER3 = "to act on classes which have been obfuscated.";
    private static final String[] SEMI_DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY = new String[]{"forName(Ljava/lang/String;)Ljava/lang/Class;", "forName(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;"};
    private static final String[] DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY = new String[]{"forName(Ljava/lang/String;)Ljava/lang/Class;", "forName(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;", "getDeclaredField(Ljava/lang/String;)Ljava/lang/reflect/Field;", "getField(Ljava/lang/String;)Ljava/lang/reflect/Field;", "getDeclaredMethod(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", "getMethod(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"};
    private static final String LOG_DANGER_CLASS_PRE = "    Your class ";
    private static final String LOG_DANGER_CLASS_MID = " calls the java.lang.Class method ";
    private static final String[] DANGEROUS_CLASSLOADER_SIMPLENAME_DESCRIPTOR_ARRAY = new String[]{"defineClass(Ljava/lang/String;[BII)Ljava/lang/Class;", "findLoadedClass(Ljava/lang/String;)Ljava/lang/Class;", "findSystemClass(Ljava/lang/String;)Ljava/lang/Class;", "loadClass(Ljava/lang/String;)Ljava/lang/Class;", "loadClass(Ljava/lang/String;Z)Ljava/lang/Class;"};
    private static final String LOG_DANGER_CLASSLOADER_PRE = "    Your class ";
    private static final String LOG_DANGER_CLASSLOADER_MID = " calls the java.lang.ClassLoader method ";
    private static final int BM_TYPE_SCF = 2;
    private static final int BM_TYPE_LMF = 1;
    private static final int BM_TYPE_UNKNOWN = 0;
    private int u4magic;
    private int u2minorVersion;
    private int u2majorVersion;
    private ConstantPool constantPool;
    private int u2accessFlags;
    private int u2thisClass;
    private int u2superClass;
    private int u2interfacesCount;
    private int[] u2interfaces;
    private int u2fieldsCount;
    private FieldInfo[] fields;
    private int u2methodsCount;
    private MethodInfo[] methods;
    private int u2attributesCount;
    private AttrInfo[] attributes;
    private boolean isUnkAttrGone = false;
    private static boolean writeIdString = false;
    private static CpInfo cpIdString = null;
    private static boolean hasHeader = false;

    public static void defineIdString(String id) {
        if (id != null) {
            writeIdString = true;
            cpIdString = new Utf8CpInfo(id);
        } else {
            writeIdString = false;
            cpIdString = null;
        }
    }

    public static ClassFile create(DataInput din) throws IOException {
        if (din == null) {
            throw new NullPointerException("No input stream was provided.");
        }
        ClassFile cf = new ClassFile();
        cf.read(din);
        return cf;
    }

    public static String[] parseDescriptor(String descriptor) {
        return ClassFile.parseDescriptor(descriptor, false);
    }

    public static String[] parseDescriptor(String descriptor, boolean isDisplay) {
        String[] names = null;
        if (descriptor.charAt(0) != '(') {
            names = new String[]{descriptor};
        } else {
            Vector<String> namesVec = new Vector<String>();
            descriptor = descriptor.substring(1);
            String type = "";
            block6: while (descriptor.length() > 0) {
                switch (descriptor.charAt(0)) {
                    case '[': {
                        type = type + "[";
                        descriptor = descriptor.substring(1);
                        continue block6;
                    }
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'I': 
                    case 'J': 
                    case 'S': 
                    case 'V': 
                    case 'Z': {
                        namesVec.addElement(type + descriptor.substring(0, 1));
                        descriptor = descriptor.substring(1);
                        type = "";
                        continue block6;
                    }
                    case ')': {
                        descriptor = descriptor.substring(1);
                        continue block6;
                    }
                    case 'L': {
                        int pos = descriptor.indexOf(59) + 1;
                        namesVec.addElement(type + descriptor.substring(0, pos));
                        descriptor = descriptor.substring(pos);
                        type = "";
                        continue block6;
                    }
                }
                throw new IllegalArgumentException("Illegal field or method descriptor: " + descriptor);
            }
            names = new String[namesVec.size()];
            for (int i = 0; i < names.length; ++i) {
                names[i] = (String)namesVec.elementAt(i);
            }
        }
        String[] translatedNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            translatedNames[i] = ClassFile.translateType(names[i], isDisplay);
        }
        return translatedNames;
    }

    public static String translateType(String inName, boolean isDisplay) {
        String outName = null;
        switch (inName.charAt(0)) {
            case '[': {
                if (!isDisplay) {
                    outName = ClassFile.translate(inName);
                    break;
                }
                outName = ClassFile.translateType(inName.substring(1), true) + "[]";
                break;
            }
            case 'B': {
                outName = Byte.TYPE.getName();
                break;
            }
            case 'C': {
                outName = Character.TYPE.getName();
                break;
            }
            case 'D': {
                outName = Double.TYPE.getName();
                break;
            }
            case 'F': {
                outName = Float.TYPE.getName();
                break;
            }
            case 'I': {
                outName = Integer.TYPE.getName();
                break;
            }
            case 'J': {
                outName = Long.TYPE.getName();
                break;
            }
            case 'S': {
                outName = Short.TYPE.getName();
                break;
            }
            case 'Z': {
                outName = Boolean.TYPE.getName();
                break;
            }
            case 'V': {
                outName = Void.TYPE.getName();
                break;
            }
            case 'L': {
                int pos = inName.indexOf(59);
                outName = ClassFile.translate(inName.substring(1, inName.indexOf(59)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal field or method name: " + inName);
            }
        }
        return outName;
    }

    public static String translate(String name) {
        return name.replace('/', '.');
    }

    private ClassFile() {
    }

    private void read(DataInput din) throws IOException {
        int i;
        this.u4magic = din.readInt();
        this.u2minorVersion = din.readUnsignedShort();
        this.u2majorVersion = din.readUnsignedShort();
        if (this.u4magic != -889275714) {
            throw new IOException("Invalid magic number in class file.");
        }
        if (this.u2majorVersion > 55) {
            throw new IOException("Incompatible version number for class file format: " + this.u2majorVersion + "." + this.u2minorVersion);
        }
        int u2constantPoolCount = din.readUnsignedShort();
        CpInfo[] cpInfo = new CpInfo[u2constantPoolCount];
        for (i = 1; i < u2constantPoolCount; ++i) {
            cpInfo[i] = CpInfo.create(din);
            if (cpInfo[i] instanceof LongCpInfo || cpInfo[i] instanceof DoubleCpInfo) {
                ++i;
                continue;
            }
            if (!(cpInfo[i] instanceof DynamicCpInfo)) continue;
            throw new IOException("Unsupported tag type in constant pool: dynamic");
        }
        this.constantPool = new ConstantPool(this, cpInfo);
        this.u2accessFlags = din.readUnsignedShort();
        this.u2thisClass = din.readUnsignedShort();
        this.u2superClass = din.readUnsignedShort();
        this.u2interfacesCount = din.readUnsignedShort();
        this.u2interfaces = new int[this.u2interfacesCount];
        for (i = 0; i < this.u2interfacesCount; ++i) {
            this.u2interfaces[i] = din.readUnsignedShort();
        }
        this.u2fieldsCount = din.readUnsignedShort();
        this.fields = new FieldInfo[this.u2fieldsCount];
        for (i = 0; i < this.u2fieldsCount; ++i) {
            this.fields[i] = FieldInfo.create(din, this);
        }
        this.u2methodsCount = din.readUnsignedShort();
        this.methods = new MethodInfo[this.u2methodsCount];
        for (i = 0; i < this.u2methodsCount; ++i) {
            this.methods[i] = MethodInfo.create(din, this);
        }
        this.u2attributesCount = din.readUnsignedShort();
        this.attributes = new AttrInfo[this.u2attributesCount];
        for (i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i] = AttrInfo.create(din, this);
        }
    }

    public int getClassFileAccess() {
        return this.u2accessFlags;
    }

    public int getModifiers() {
        int mods = 0;
        if ((this.u2accessFlags & 1) == 1) {
            mods |= 1;
        }
        if ((this.u2accessFlags & 0x10) == 16) {
            mods |= 0x10;
        }
        if ((this.u2accessFlags & 0x200) == 512) {
            mods |= 0x200;
        }
        if ((this.u2accessFlags & 0x400) == 1024) {
            mods |= 0x400;
        }
        return mods;
    }

    public String getName() {
        return this.toName(this.u2thisClass);
    }

    public String getSuper() {
        return this.u2superClass == 0 ? null : this.toName(this.u2superClass);
    }

    public String[] getInterfaces() {
        String[] interfaces = new String[this.u2interfacesCount];
        for (int i = 0; i < this.u2interfacesCount; ++i) {
            interfaces[i] = this.toName(this.u2interfaces[i]);
        }
        return interfaces;
    }

    private String toName(int u2index) {
        CpInfo classEntry = this.getCpEntry(u2index);
        if (classEntry instanceof ClassCpInfo) {
            CpInfo nameEntry = this.getCpEntry(((ClassCpInfo)classEntry).getNameIndex());
            if (nameEntry instanceof Utf8CpInfo) {
                return ((Utf8CpInfo)nameEntry).getString();
            }
            throw new ParseException("Inconsistent Constant Pool in class file.");
        }
        throw new ParseException("Inconsistent Constant Pool in class file.");
    }

    public Enumeration getMethodEnum() {
        Vector<MethodInfo> vec = new Vector<MethodInfo>();
        for (int i = 0; i < this.methods.length; ++i) {
            vec.addElement(this.methods[i]);
        }
        return vec.elements();
    }

    public Enumeration getFieldEnum() {
        Vector<FieldInfo> vec = new Vector<FieldInfo>();
        for (int i = 0; i < this.fields.length; ++i) {
            vec.addElement(this.fields[i]);
        }
        return vec.elements();
    }

    public CpInfo getCpEntry(int cpIndex) {
        return this.constantPool.getCpEntry(cpIndex);
    }

    private String getUtf8(int cpIndex) {
        return ((Utf8CpInfo)this.getCpEntry(cpIndex)).getString();
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public String[] logDangerousMethods(boolean replaceClassNameStrings) {
        Vector<String> warningVec = new Vector<String>();
        Enumeration enumeration = this.constantPool.elements();
        while (enumeration.hasMoreElements()) {
            String jMethod;
            Object o = enumeration.nextElement();
            if (!(o instanceof MethodrefCpInfo)) continue;
            MethodrefCpInfo entry = (MethodrefCpInfo)o;
            ClassCpInfo classEntry = (ClassCpInfo)this.getCpEntry(entry.getClassIndex());
            String className = ((Utf8CpInfo)this.getCpEntry(classEntry.getNameIndex())).getString();
            NameAndTypeCpInfo ntEntry = (NameAndTypeCpInfo)this.getCpEntry(entry.getNameAndTypeIndex());
            String name = ((Utf8CpInfo)this.getCpEntry(ntEntry.getNameIndex())).getString();
            String descriptor = ((Utf8CpInfo)this.getCpEntry(ntEntry.getDescriptorIndex())).getString();
            if (className.equals("java/lang/Class") && Tools.isInArray(name + descriptor, DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY)) {
                if (!replaceClassNameStrings || Tools.isInArray(name + descriptor, SEMI_DANGEROUS_CLASS_SIMPLENAME_DESCRIPTOR_ARRAY)) continue;
                jMethod = Conversion.toJavaMethod(name, descriptor);
                warningVec.addElement("    Your class " + Conversion.toJavaClass(this.getName()) + LOG_DANGER_CLASS_MID + jMethod);
                continue;
            }
            if (Tools.isInArray(name + descriptor, DANGEROUS_CLASSLOADER_SIMPLENAME_DESCRIPTOR_ARRAY)) {
                jMethod = Conversion.toJavaMethod(name, descriptor);
                warningVec.addElement("    Your class " + Conversion.toJavaClass(this.getName()) + LOG_DANGER_CLASSLOADER_MID + jMethod);
                continue;
            }
            if (!"class$(Ljava/lang/String;)Ljava/lang/Class;".equals(name + descriptor) || replaceClassNameStrings) continue;
            warningVec.addElement("    Your class " + Conversion.toJavaClass(this.getName()) + " seems to be using the '.class' construct!");
        }
        String[] warnings = new String[warningVec.size()];
        for (int i = 0; i < warnings.length; ++i) {
            warnings[i] = (String)warningVec.elementAt(i);
        }
        return warnings;
    }

    public static void resetDangerHeader() {
        hasHeader = false;
    }

    public void logDangerousMethods(PrintWriter log, boolean replaceClassNameStrings) {
        String[] warnings = this.logDangerousMethods(replaceClassNameStrings);
        if (warnings != null && warnings.length > 0) {
            if (!hasHeader) {
                log.println("<!-- WARNING");
                log.println(LOG_DANGER_HEADER1);
                log.println(LOG_DANGER_HEADER2);
                log.println(LOG_DANGER_HEADER3);
                Logger logger = Logger.getInstance();
                logger.warning("Methods are called which may break in obfuscated version at runtime.\nPlease review your source code to ensure that the dangerous methods are not intended\nto act on classes which have been obfuscated.\nSee the logfile for a list of these classes and methods.");
                log.println("-->");
                hasHeader = true;
            }
            if (warnings.length > 0) {
                log.println("<!--");
                for (int i = 0; i < warnings.length; ++i) {
                    log.println(" " + warnings[i]);
                }
                log.println("-->");
            }
        }
    }

    public void markUtf8Refs(ConstantPool pool) {
        try {
            int i;
            for (i = 0; i < this.fields.length; ++i) {
                this.fields[i].markUtf8Refs(pool);
            }
            for (i = 0; i < this.methods.length; ++i) {
                this.methods[i].markUtf8Refs(pool);
            }
            for (i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].markUtf8Refs(pool);
            }
            Enumeration enumeration = pool.elements();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!(o instanceof NameAndTypeCpInfo) && !(o instanceof AbstractTypeCpInfo) && !(o instanceof MethodTypeCpInfo) && !(o instanceof StringCpInfo)) continue;
                ((CpInfo)o).markUtf8Refs(pool);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Inconsistent reference to constant pool.");
        }
    }

    public void markNTRefs(ConstantPool pool) {
        try {
            Enumeration enumeration = pool.elements();
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!(o instanceof RefCpInfo) && !(o instanceof AbstractDynamicCpInfo)) continue;
                ((CpInfo)o).markNTRefs(pool);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ParseException("Inconsistent reference to constant pool.");
        }
    }

    public void trimAttrsExcept(String[] extraAttrs) {
        int i;
        String[] keepAttrs = REQUIRED_ATTRS;
        if (extraAttrs != null && extraAttrs.length > 0) {
            String[] tmp = new String[keepAttrs.length + extraAttrs.length];
            System.arraycopy(keepAttrs, 0, tmp, 0, keepAttrs.length);
            System.arraycopy(extraAttrs, 0, tmp, keepAttrs.length, extraAttrs.length);
            keepAttrs = tmp;
        }
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i].trimAttrsExcept(keepAttrs);
        }
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i].trimAttrsExcept(keepAttrs);
        }
        for (i = 0; i < this.attributes.length; ++i) {
            if (Tools.isInArray(this.attributes[i].getAttrName(), keepAttrs)) {
                this.attributes[i].trimAttrsExcept(keepAttrs);
                continue;
            }
            this.attributes[i] = null;
        }
        AttrInfo[] left = new AttrInfo[this.attributes.length];
        int j = 0;
        for (int i2 = 0; i2 < this.attributes.length; ++i2) {
            if (this.attributes[i2] == null) continue;
            left[j++] = this.attributes[i2];
        }
        this.attributes = new AttrInfo[j];
        System.arraycopy(left, 0, this.attributes, 0, j);
        this.u2attributesCount = j;
        this.isUnkAttrGone = true;
        this.constantPool.updateRefCount();
    }

    public Map getInnerClassModifiers() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < this.u2attributesCount; ++i) {
            AttrInfo attrInfo = this.attributes[i];
            if (!(attrInfo instanceof InnerClassesAttrInfo)) continue;
            InnerClassesInfo[] info = ((InnerClassesAttrInfo)attrInfo).getInfo();
            for (int j = 0; j < info.length; ++j) {
                CpInfo cpInfo;
                InnerClassesInfo ici = info[j];
                int index = info[j].getInnerNameIndex();
                if (index == 0 || !((cpInfo = this.getCpEntry(info[j].getInnerNameIndex())) instanceof Utf8CpInfo)) continue;
                Utf8CpInfo utf = (Utf8CpInfo)cpInfo;
                String origClass = utf.getString();
                map.put(origClass, new Integer(ici.getModifiers()));
            }
        }
        return map;
    }

    public void trimAttrs() {
        this.trimAttrsExcept(null);
    }

    private boolean containsDotClassMethodReference() {
        Enumeration enumeration = this.constantPool.elements();
        while (enumeration.hasMoreElements()) {
            String descriptor;
            Object o = enumeration.nextElement();
            if (!(o instanceof MethodrefCpInfo)) continue;
            MethodrefCpInfo entry = (MethodrefCpInfo)o;
            ClassCpInfo classEntry = (ClassCpInfo)this.getCpEntry(entry.getClassIndex());
            String className = ((Utf8CpInfo)this.getCpEntry(classEntry.getNameIndex())).getString();
            NameAndTypeCpInfo ntEntry = (NameAndTypeCpInfo)this.getCpEntry(entry.getNameAndTypeIndex());
            String name = ((Utf8CpInfo)this.getCpEntry(ntEntry.getNameIndex())).getString();
            if (!name.equals("class$") || !(descriptor = ((Utf8CpInfo)this.getCpEntry(ntEntry.getDescriptorIndex())).getString()).equals("(Ljava/lang/String;)Ljava/lang/Class;")) continue;
            return true;
        }
        return false;
    }

    private boolean containsClassMethodReference(String cName, String des) {
        Enumeration enumeration = this.constantPool.elements();
        while (enumeration.hasMoreElements()) {
            Object o = enumeration.nextElement();
            if (!(o instanceof MethodrefCpInfo)) continue;
            MethodrefCpInfo entry = (MethodrefCpInfo)o;
            ClassCpInfo classEntry = (ClassCpInfo)this.getCpEntry(entry.getClassIndex());
            String className = ((Utf8CpInfo)this.getCpEntry(classEntry.getNameIndex())).getString();
            NameAndTypeCpInfo ntEntry = (NameAndTypeCpInfo)this.getCpEntry(entry.getNameAndTypeIndex());
            String name = ((Utf8CpInfo)this.getCpEntry(ntEntry.getNameIndex())).getString();
            String descriptor = ((Utf8CpInfo)this.getCpEntry(ntEntry.getDescriptorIndex())).getString();
            if (!className.equals(cName) || !(name + descriptor).equals(des)) continue;
            return true;
        }
        return false;
    }

    public void remap(NameMapper nm, boolean replaceClassNameStrings, PrintWriter log) {
        CpInfo cpInfo;
        int i;
        String remapName;
        AttrInfo attrInfo;
        String remapDesc;
        int i2;
        String thisClassName = ((Utf8CpInfo)this.getCpEntry(((ClassCpInfo)this.getCpEntry(this.u2thisClass)).getNameIndex())).getString();
        String[] attributesToKeep = nm.getAttrsToKeep(thisClassName);
        if (attributesToKeep.length > 0) {
            this.trimAttrsExcept(attributesToKeep);
        } else {
            this.trimAttrs();
        }
        for (i2 = 0; i2 < this.u2attributesCount; ++i2) {
            String newName;
            Utf8CpInfo utf;
            String origName;
            SourceFileAttrInfo source;
            CpInfo cpInfo2;
            Utf8CpInfo utf2;
            String origClass;
            AttrInfo attrInfo2 = this.attributes[i2];
            if (attrInfo2 instanceof RuntimeVisibleAnnotationsAttrInfo) {
                this.remapAnnotations((RuntimeVisibleAnnotationsAttrInfo)attrInfo2, nm);
                continue;
            }
            if (attrInfo2 instanceof InnerClassesAttrInfo) {
                InnerClassesInfo[] info = ((InnerClassesAttrInfo)attrInfo2).getInfo();
                for (int j = 0; j < info.length; ++j) {
                    CpInfo cpInfo3 = this.getCpEntry(info[j].getInnerNameIndex());
                    if (!(cpInfo3 instanceof Utf8CpInfo) || (origClass = (utf2 = (Utf8CpInfo)cpInfo3).getString()).equals("")) continue;
                    ClassCpInfo innerClassInfo = (ClassCpInfo)this.getCpEntry(info[j].getInnerClassIndex());
                    String innerClassName = ((Utf8CpInfo)this.getCpEntry(innerClassInfo.getNameIndex())).getString();
                    String remapClass = nm.mapClass(innerClassName);
                    remapClass = remapClass.substring(remapClass.lastIndexOf(36) + 1);
                    int remapIndex = this.constantPool.remapUtf8To(remapClass, info[j].getInnerNameIndex());
                    info[j].setInnerNameIndex(remapIndex);
                }
                continue;
            }
            if (attrInfo2 instanceof EnclosingMethodAttrInfo) {
                ClassCpInfo ccpi;
                EnclosingMethodAttrInfo eam = (EnclosingMethodAttrInfo)attrInfo2;
                CpInfo cpi = this.getCpEntry(eam.getClassIndex());
                if (!(cpi instanceof ClassCpInfo) || !((cpi = this.getCpEntry((ccpi = (ClassCpInfo)cpi).getNameIndex())) instanceof Utf8CpInfo)) continue;
                utf2 = (Utf8CpInfo)cpi;
                origClass = utf2.getString();
                String remapClass = nm.mapClass(origClass);
                if (eam.getNameAndTypeIndex() <= 0 || !((cpi = this.getCpEntry(eam.getNameAndTypeIndex())) instanceof NameAndTypeCpInfo)) continue;
                NameAndTypeCpInfo nameTypeInfo = (NameAndTypeCpInfo)cpi;
                Utf8CpInfo refUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getNameIndex());
                Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getDescriptorIndex());
                String origMethodName = refUtf.getString();
                String origDescriptor = descUtf.getString();
                String remapRef = nm.mapMethod(origClass, origMethodName, origDescriptor);
                remapDesc = nm.mapDescriptor(descUtf.getString());
                eam.setNameAndTypeIndex(this.remapNT(refUtf, remapRef, descUtf, remapDesc, nameTypeInfo, eam.getNameAndTypeIndex()));
                continue;
            }
            if (attrInfo2 instanceof SignatureAttrInfo) {
                this.remapSignature(nm, (SignatureAttrInfo)attrInfo2);
                continue;
            }
            if (!(attrInfo2 instanceof SourceFileAttrInfo) || !((cpInfo2 = this.getCpEntry((source = (SourceFileAttrInfo)attrInfo2).getSourceFileIndex())) instanceof Utf8CpInfo) || (origName = (utf = (Utf8CpInfo)cpInfo2).getString()) == null || origName.length() <= 0 || origName.equals(newName = nm.mapSourceFile(thisClassName, origName))) continue;
            if (newName == null || newName.length() < 1) {
                AttrInfo[] newAttributes = new AttrInfo[this.attributes.length - 1];
                System.arraycopy(this.attributes, 0, newAttributes, 0, i2);
                if (newAttributes.length > i2) {
                    System.arraycopy(this.attributes, i2 + 1, newAttributes, i2, newAttributes.length - i2);
                }
                this.attributes = newAttributes;
                --this.u2attributesCount;
                --i2;
                this.constantPool.decRefCount(source.getAttrNameIndex());
                utf.decRefCount();
                continue;
            }
            int remapIndex = this.constantPool.remapUtf8To(newName, source.getSourceFileIndex());
            source.setSourceFileIndex(remapIndex);
        }
        for (i2 = 0; i2 < this.u2methodsCount; ++i2) {
            for (int j = 0; j < this.methods[i2].u2attributesCount; ++j) {
                String methodName = this.methods[i2].getName();
                String descriptor = this.methods[i2].getDescriptor();
                attrInfo = this.methods[i2].attributes[j];
                if (attrInfo instanceof AnnotationDefaultAttrInfo) {
                    this.remapAnnotationDefault((AnnotationDefaultAttrInfo)attrInfo, nm);
                    continue;
                }
                if (attrInfo instanceof RuntimeVisibleAnnotationsAttrInfo) {
                    this.remapAnnotations((RuntimeVisibleAnnotationsAttrInfo)attrInfo, nm);
                    continue;
                }
                if (attrInfo instanceof RuntimeVisibleParameterAnnotationsAttrInfo) {
                    this.remapAnnotations((RuntimeVisibleParameterAnnotationsAttrInfo)attrInfo, nm);
                    continue;
                }
                if (attrInfo instanceof SignatureAttrInfo) {
                    this.remapSignature(nm, (SignatureAttrInfo)attrInfo);
                    continue;
                }
                if (!(attrInfo instanceof CodeAttrInfo)) continue;
                CodeAttrInfo codeAttrInfo = (CodeAttrInfo)attrInfo;
                for (int k = 0; k < codeAttrInfo.u2attributesCount; ++k) {
                    LineNumberTableAttrInfo ltai;
                    Object[] newArray;
                    Utf8CpInfo nameUtf;
                    int m;
                    Object[] lvts;
                    AttrInfo innerAttrInfo = codeAttrInfo.attributes[k];
                    if (innerAttrInfo instanceof LocalVariableTableAttrInfo) {
                        LocalVariableTableAttrInfo lvtAttrInfo = (LocalVariableTableAttrInfo)innerAttrInfo;
                        lvts = lvtAttrInfo.getLocalVariableTable();
                        for (m = 0; m < lvts.length; ++m) {
                            nameUtf = (Utf8CpInfo)this.getCpEntry(((LocalVariableInfo)lvts[m]).getNameIndex());
                            remapName = nm.mapLocalVariable(thisClassName, methodName, descriptor, nameUtf.getString());
                            if (remapName == null || remapName.length() < 1) {
                                this.constantPool.decRefCount(((LocalVariableInfo)lvts[m]).getNameIndex());
                                this.constantPool.decRefCount(((LocalVariableInfo)lvts[m]).getDescriptorIndex());
                                newArray = new LocalVariableInfo[lvts.length - 1];
                                System.arraycopy(lvts, 0, newArray, 0, m);
                                if (newArray.length > m) {
                                    System.arraycopy(lvts, m + 1, newArray, m, newArray.length - m);
                                }
                                lvts = newArray;
                                lvtAttrInfo.setLocalVariableTable((LocalVariableInfo[])lvts);
                                --m;
                                continue;
                            }
                            ((LocalVariableInfo)lvts[m]).setNameIndex(this.constantPool.remapUtf8To(remapName, ((LocalVariableInfo)lvts[m]).getNameIndex()));
                            Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(((LocalVariableInfo)lvts[m]).getDescriptorIndex());
                            remapDesc = nm.mapDescriptor(descUtf.getString());
                            ((LocalVariableInfo)lvts[m]).setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc, ((LocalVariableInfo)lvts[m]).getDescriptorIndex()));
                        }
                        continue;
                    }
                    if (innerAttrInfo instanceof LocalVariableTypeTableAttrInfo) {
                        LocalVariableTypeTableAttrInfo lvttAttrInfo = (LocalVariableTypeTableAttrInfo)innerAttrInfo;
                        lvts = lvttAttrInfo.getLocalVariableTypeTable();
                        for (m = 0; m < lvts.length; ++m) {
                            nameUtf = (Utf8CpInfo)this.getCpEntry(((LocalVariableTypeInfo)lvts[m]).getNameIndex());
                            remapName = nm.mapLocalVariable(thisClassName, methodName, descriptor, nameUtf.getString());
                            if (remapName == null || remapName.length() < 1) {
                                this.constantPool.decRefCount(((LocalVariableTypeInfo)lvts[m]).getNameIndex());
                                this.constantPool.decRefCount(((LocalVariableTypeInfo)lvts[m]).getSignatureIndex());
                                newArray = new LocalVariableTypeInfo[lvts.length - 1];
                                System.arraycopy(lvts, 0, newArray, 0, m);
                                if (newArray.length > m) {
                                    System.arraycopy(lvts, m + 1, newArray, m, newArray.length - m);
                                }
                                lvts = newArray;
                                lvttAttrInfo.setLocalVariableTypeTable((LocalVariableTypeInfo[])lvts);
                                --m;
                                continue;
                            }
                            ((LocalVariableTypeInfo)lvts[m]).setNameIndex(this.constantPool.remapUtf8To(remapName, ((LocalVariableTypeInfo)lvts[m]).getNameIndex()));
                            Utf8CpInfo signatureUtf = (Utf8CpInfo)this.getCpEntry(((LocalVariableTypeInfo)lvts[m]).getSignatureIndex());
                            String remapSig = nm.mapSignature(signatureUtf.getString());
                            ((LocalVariableTypeInfo)lvts[m]).setSignatureIndex(this.constantPool.remapUtf8To(remapSig, ((LocalVariableTypeInfo)lvts[m]).getSignatureIndex()));
                        }
                        continue;
                    }
                    if (!(innerAttrInfo instanceof LineNumberTableAttrInfo) || nm.mapLineNumberTable(thisClassName, methodName, descriptor, ltai = (LineNumberTableAttrInfo)innerAttrInfo)) continue;
                    AttrInfo[] newAtt = new AttrInfo[codeAttrInfo.u2attributesCount - 1];
                    System.arraycopy(codeAttrInfo.attributes, 0, newAtt, 0, k);
                    if (newAtt.length > k) {
                        System.arraycopy(codeAttrInfo.attributes, k + 1, newAtt, k, newAtt.length - k);
                    }
                    codeAttrInfo.attributes = newAtt;
                    --codeAttrInfo.u2attributesCount;
                    --k;
                }
            }
        }
        for (i2 = 0; i2 < this.u2fieldsCount; ++i2) {
            FieldInfo field = this.fields[i2];
            Utf8CpInfo nameUtf = (Utf8CpInfo)this.getCpEntry(field.getNameIndex());
            if (!field.isSynthetic() || nameUtf.getString().startsWith("class$")) {
                String remapName2 = nm.mapField(thisClassName, nameUtf.getString());
                field.setNameIndex(this.constantPool.remapUtf8To(remapName2, field.getNameIndex()));
            }
            for (int j = 0; j < field.u2attributesCount; ++j) {
                attrInfo = field.attributes[j];
                if (attrInfo instanceof RuntimeVisibleAnnotationsAttrInfo) {
                    this.remapAnnotations((RuntimeVisibleAnnotationsAttrInfo)attrInfo, nm);
                    continue;
                }
                if (!(attrInfo instanceof SignatureAttrInfo)) continue;
                this.remapSignature(nm, (SignatureAttrInfo)attrInfo);
            }
            Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(field.getDescriptorIndex());
            String remapDesc2 = nm.mapDescriptor(descUtf.getString());
            field.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc2, field.getDescriptorIndex()));
        }
        for (i2 = 0; i2 < this.u2methodsCount; ++i2) {
            MethodInfo method = this.methods[i2];
            Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(method.getDescriptorIndex());
            if (!method.isSynthetic()) {
                Utf8CpInfo nameUtf = (Utf8CpInfo)this.getCpEntry(method.getNameIndex());
                String remapName3 = nm.mapMethod(thisClassName, nameUtf.getString(), descUtf.getString());
                method.setNameIndex(this.constantPool.remapUtf8To(remapName3, method.getNameIndex()));
            }
            String remapDesc3 = nm.mapDescriptor(descUtf.getString());
            method.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc3, method.getDescriptorIndex()));
        }
        if (replaceClassNameStrings && nm instanceof ClassTree) {
            this.replaceConstantPoolStrings((ClassTree)nm);
        }
        int currentCpLength = this.constantPool.length();
        block14: for (i = 0; i < currentCpLength; ++i) {
            cpInfo = this.getCpEntry(i);
            if (cpInfo == null || !(cpInfo instanceof InvokeDynamicCpInfo)) continue;
            InvokeDynamicCpInfo id = (InvokeDynamicCpInfo)cpInfo;
            BootstrapMethod bm = this.getBootstrapMethod(id);
            switch (this.getType(bm)) {
                case 1: {
                    NameAndTypeCpInfo nameTypeInfo = (NameAndTypeCpInfo)this.getCpEntry(id.getNameAndTypeIndex());
                    Utf8CpInfo refUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getNameIndex());
                    Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getDescriptorIndex());
                    String descriptor = descUtf.getString();
                    String className = descriptor.substring(descriptor.indexOf(")L") + 2, descriptor.length() - 1);
                    MethodTypeCpInfo methodTypeInfo = (MethodTypeCpInfo)this.getCpEntry(bm.getBootstrapArguments()[0]);
                    Utf8CpInfo samMethodDescriptor = (Utf8CpInfo)this.getCpEntry(methodTypeInfo.getU2descriptorIndex());
                    remapName = nm.mapMethod(className, refUtf.getString(), samMethodDescriptor.getString());
                    String remapDesc4 = nm.mapDescriptor(descUtf.getString());
                    id.setNameAndTypeIndex(this.remapNT(refUtf, remapName, descUtf, remapDesc4, nameTypeInfo, id.getNameAndTypeIndex()));
                    continue block14;
                }
                case 2: {
                    int idx = id.getNameAndTypeIndex();
                    NameAndTypeCpInfo ntInfo = (NameAndTypeCpInfo)this.getCpEntry(idx);
                    Utf8CpInfo refUtf = (Utf8CpInfo)this.getCpEntry(ntInfo.getNameIndex());
                    Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(ntInfo.getDescriptorIndex());
                    String remapDesc5 = nm.mapDescriptor(descUtf.getString());
                    id.setNameAndTypeIndex(this.remapNT(refUtf, refUtf.getString(), descUtf, remapDesc5, ntInfo, idx));
                    continue block14;
                }
                default: {
                    String sig = this.getBootstrapMethodSignature(bm);
                    throw new IllegalArgumentException("Unrecognized bootstrap method: " + sig);
                }
            }
        }
        currentCpLength = this.constantPool.length();
        for (i = 0; i < currentCpLength; ++i) {
            String remapRef;
            cpInfo = this.getCpEntry(i);
            if (cpInfo == null) continue;
            if (cpInfo instanceof MethodTypeCpInfo) {
                MethodTypeCpInfo mt = (MethodTypeCpInfo)cpInfo;
                Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(mt.getU2descriptorIndex());
                String remapDesc6 = nm.mapDescriptor(descUtf.getString());
                mt.setU2descriptorIndex(this.constantPool.remapUtf8To(remapDesc6, mt.getU2descriptorIndex()));
                continue;
            }
            if (!(cpInfo instanceof RefCpInfo)) continue;
            ClassCpInfo classInfo = (ClassCpInfo)this.getCpEntry(((RefCpInfo)cpInfo).getClassIndex());
            Utf8CpInfo classUtf = (Utf8CpInfo)this.getCpEntry(classInfo.getNameIndex());
            String className = classUtf.getString();
            int ntIndex = ((RefCpInfo)cpInfo).getNameAndTypeIndex();
            NameAndTypeCpInfo nameTypeInfo = (NameAndTypeCpInfo)this.getCpEntry(ntIndex);
            Utf8CpInfo refUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getNameIndex());
            Utf8CpInfo descUtf = (Utf8CpInfo)this.getCpEntry(nameTypeInfo.getDescriptorIndex());
            if (cpInfo instanceof FieldrefCpInfo) {
                remapRef = nm.mapField(className, refUtf.getString());
                if (refUtf.getString().startsWith("class$") && !replaceClassNameStrings) {
                    String internalClassName = refUtf.getString().substring(6);
                    String realClassName = internalClassName.replace('$', '.');
                    String map = nm.mapClass(internalClassName = internalClassName.replace('$', '/'));
                    if (map != null && !internalClassName.equals(map)) {
                        String warning = realClassName + " shouldn't be obfuscated: it is most likely referenced as " + realClassName + ".class from " + Conversion.toJavaClass(thisClassName);
                        Logger.getInstance().warning(warning);
                        log.println("<!-- WARNING: " + warning + " -->");
                    }
                }
            } else {
                remapRef = nm.mapMethod(className, refUtf.getString(), descUtf.getString());
            }
            String remapDesc7 = nm.mapDescriptor(descUtf.getString());
            ((RefCpInfo)cpInfo).setNameAndTypeIndex(this.remapNT(refUtf, remapRef, descUtf, remapDesc7, nameTypeInfo, ((RefCpInfo)cpInfo).getNameAndTypeIndex()));
        }
        for (i = 0; i < this.constantPool.length(); ++i) {
            PackageCpInfo info;
            int pnIdx;
            CpInfo pnInfo;
            cpInfo = this.getCpEntry(i);
            if (cpInfo == null) continue;
            if (cpInfo instanceof ClassCpInfo) {
                ClassCpInfo classInfo = (ClassCpInfo)cpInfo;
                Utf8CpInfo utf = (Utf8CpInfo)this.getCpEntry(classInfo.getNameIndex());
                String remapClass = nm.mapClass(utf.getString());
                int remapIndex = this.constantPool.remapUtf8To(remapClass, classInfo.getNameIndex());
                classInfo.setNameIndex(remapIndex);
                continue;
            }
            if (!(cpInfo instanceof PackageCpInfo) || !((pnInfo = this.getCpEntry(pnIdx = (info = (PackageCpInfo)cpInfo).getNameIndex())) instanceof Utf8CpInfo)) continue;
            String oldName = ((Utf8CpInfo)pnInfo).getString();
            String newName = nm.mapPackage(oldName);
            info.setNameIndex(this.constantPool.remapUtf8To(newName, pnIdx));
        }
    }

    private BootstrapMethodsAttrInfo getBootstrapMethodAttribute() {
        for (int i = 0; i < this.attributes.length; ++i) {
            AttrInfo attribute = this.attributes[i];
            if (!(attribute instanceof BootstrapMethodsAttrInfo)) continue;
            return (BootstrapMethodsAttrInfo)attribute;
        }
        throw new RuntimeException("No BootstrapMethod attribute in class file");
    }

    private int getType(BootstrapMethod method) {
        String sig = this.getBootstrapMethodSignature(method);
        if ("java/lang/invoke/StringConcatFactory#makeConcat(...)".equals(sig)) {
            return 2;
        }
        if ("java/lang/invoke/StringConcatFactory#makeConcatWithConstants(...)".equals(sig)) {
            return 2;
        }
        if ("java/lang/invoke/LambdaMetafactory#metafactory(...)".equals(sig)) {
            return 1;
        }
        if ("java/lang/invoke/LambdaMetafactory#altMetafactory(...)".equals(sig)) {
            return 1;
        }
        return 0;
    }

    private BootstrapMethod getBootstrapMethod(InvokeDynamicCpInfo info) {
        BootstrapMethodsAttrInfo bmInfo = this.getBootstrapMethodAttribute();
        return bmInfo.getBootstrapMethods()[info.getBootstrapMethodAttrIndex()];
    }

    private String getBootstrapMethodSignature(BootstrapMethod method) {
        int mhIdx = method.getBootstrapMethodRef();
        MethodHandleCpInfo mhInfo = (MethodHandleCpInfo)this.getCpEntry(mhIdx);
        RefCpInfo mrInfo = (RefCpInfo)this.getCpEntry(mhInfo.getReferenceIndex());
        ClassCpInfo cpInfo = (ClassCpInfo)this.getCpEntry(mrInfo.getClassIndex());
        String className = this.getUtf8(cpInfo.getNameIndex());
        NameAndTypeCpInfo ntInfo = (NameAndTypeCpInfo)this.getCpEntry(mrInfo.getNameAndTypeIndex());
        String memberName = this.getUtf8(ntInfo.getNameIndex());
        return className + '#' + memberName + ClassFile.getReferenceKindSuffix(mhInfo.getReferenceKind());
    }

    private static String getReferenceKindSuffix(int referenceKind) {
        switch (referenceKind) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return "";
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return "(...)";
            }
        }
        throw new IllegalArgumentException("Invalid reference kind: " + referenceKind);
    }

    private void remapAnnotationDefault(AnnotationDefaultAttrInfo annotationDefault, NameMapper nm) {
        this.remapElementValue(annotationDefault.elementValue, nm);
    }

    private void remapAnnotations(RuntimeVisibleAnnotationsAttrInfo annotation, NameMapper nm) {
        AnnotationInfo[] annotations = annotation.getAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                this.remapAnnotation(annotations[i], nm);
            }
        }
    }

    private void remapAnnotations(RuntimeVisibleParameterAnnotationsAttrInfo annotation, NameMapper nm) {
        ParameterAnnotationInfo[] annotations = annotation.getParameterAnnotations();
        if (annotations != null) {
            for (int i = 0; i < annotations.length; ++i) {
                ParameterAnnotationInfo info = annotations[i];
                AnnotationInfo[] a = info.getAnnotations();
                if (a == null) continue;
                for (int j = 0; j < a.length; ++j) {
                    this.remapAnnotation(a[j], nm);
                }
            }
        }
    }

    private void remapAnnotation(AnnotationInfo annotation, NameMapper nm) {
        Utf8CpInfo utf;
        String s;
        CpInfo info = this.getCpEntry(annotation.u2typeIndex);
        if (info instanceof Utf8CpInfo && (s = (utf = (Utf8CpInfo)info).getString()).length() > 2 && s.charAt(0) == 'L' && s.charAt(s.length() - 1) == ';') {
            ElementValuePairInfo[] evp;
            String newFqn;
            String fqn = s.substring(1, s.length() - 1);
            if (!fqn.equals(newFqn = nm.mapClass(fqn))) {
                annotation.u2typeIndex = this.constantPool.remapUtf8To('L' + newFqn + ';', annotation.u2typeIndex);
            }
            if ((evp = annotation.getElementValuePairs()) != null) {
                for (int i = 0; i < evp.length; ++i) {
                    ElementValuePairInfo elementValuePair = evp[i];
                    utf = (Utf8CpInfo)this.getCpEntry(elementValuePair.u2ElementNameIndex);
                    String remapName = nm.mapAnnotationField(fqn, utf.getString());
                    if (!remapName.equals(utf.getString())) {
                        elementValuePair.u2ElementNameIndex = this.constantPool.remapUtf8To(remapName, elementValuePair.u2ElementNameIndex);
                    }
                    ElementValueInfo elementValue = elementValuePair.elementValue;
                    this.remapElementValue(elementValue, nm);
                }
            }
        }
    }

    private void remapElementValue(ElementValueInfo elementValue, NameMapper nm) {
        switch (elementValue.u1Tag) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                break;
            }
            case 101: {
                Utf8CpInfo utf = (Utf8CpInfo)this.getCpEntry(elementValue.u2typeNameIndex);
                String name = utf.getString();
                String remapName = nm.mapDescriptor(name);
                elementValue.u2typeNameIndex = this.constantPool.remapUtf8To(remapName, elementValue.u2typeNameIndex);
                break;
            }
            case 99: {
                Utf8CpInfo utf = (Utf8CpInfo)this.getCpEntry(elementValue.u2cpIndex);
                String name = utf.getString();
                String remapName = nm.mapDescriptor(name);
                elementValue.u2cpIndex = this.constantPool.remapUtf8To(remapName, elementValue.u2cpIndex);
                break;
            }
            case 64: {
                this.remapAnnotation(elementValue.nestedAnnotation, nm);
                break;
            }
            case 91: {
                for (int j = 0; j < elementValue.arrayValues.length; ++j) {
                    ElementValueInfo evi = elementValue.arrayValues[j];
                    this.remapElementValue(evi, nm);
                }
                break;
            }
            default: {
                throw new RuntimeException("Unknown type tag in annotation!");
            }
        }
    }

    private void remapSignature(NameMapper nm, SignatureAttrInfo signature) {
        String remapSignature;
        Utf8CpInfo utf;
        String sig;
        CpInfo cpInfo = this.getCpEntry(signature.getSignatureIndex());
        if (cpInfo instanceof Utf8CpInfo && !(sig = (utf = (Utf8CpInfo)cpInfo).getString()).equals(remapSignature = nm.mapSignature(sig))) {
            int remapIndex = this.constantPool.remapUtf8To(remapSignature, signature.getSignatureIndex());
            signature.setSignatureIndex(remapIndex);
        }
    }

    private int remapNT(Utf8CpInfo refUtf, String remapRef, Utf8CpInfo descUtf, String remapDesc, NameAndTypeCpInfo nameTypeInfo, int nameAndTypeIndex) {
        if (!remapRef.equals(refUtf.getString()) || !remapDesc.equals(descUtf.getString())) {
            NameAndTypeCpInfo newNameTypeInfo;
            if (nameTypeInfo.getRefCount() == 1) {
                newNameTypeInfo = nameTypeInfo;
            } else {
                newNameTypeInfo = (NameAndTypeCpInfo)nameTypeInfo.clone();
                this.getCpEntry(newNameTypeInfo.getNameIndex()).incRefCount();
                this.getCpEntry(newNameTypeInfo.getDescriptorIndex()).incRefCount();
                nameAndTypeIndex = this.constantPool.addEntry(newNameTypeInfo);
                newNameTypeInfo.incRefCount();
                nameTypeInfo.decRefCount();
            }
            newNameTypeInfo.setNameIndex(this.constantPool.remapUtf8To(remapRef, newNameTypeInfo.getNameIndex()));
            newNameTypeInfo.setDescriptorIndex(this.constantPool.remapUtf8To(remapDesc, newNameTypeInfo.getDescriptorIndex()));
        }
        return nameAndTypeIndex;
    }

    private void replaceConstantPoolStrings(ClassTree ct) {
        Enumeration enumeration = this.constantPool.elements();
        while (enumeration.hasMoreElements()) {
            Cl cl;
            CpInfo cpi = (CpInfo)enumeration.nextElement();
            if (!(cpi instanceof Utf8CpInfo)) continue;
            Utf8CpInfo ui = (Utf8CpInfo)cpi;
            String s = ui.getString();
            boolean jikes = false;
            if (s.length() > 5 && s.startsWith("[L") && s.endsWith(";")) {
                s = s.substring(2, s.length() - 1);
                jikes = true;
            }
            if (s.length() <= 2 || !Character.isJavaIdentifierPart(s.charAt(s.length() - 1)) || s.indexOf(32) >= 0 || s.indexOf(46) <= 0 || (cl = ct.findClassForName(s)) == null || cl.getFullInName().equals(cl.getFullOutName())) continue;
            if (jikes) {
                ui.setString("[L" + cl.getFullOutName().replace('/', '.') + ";");
                continue;
            }
            ui.setString(cl.getFullOutName().replace('/', '.'));
        }
    }

    public void write(DataOutput dout) throws IOException {
        int i;
        if (dout == null) {
            throw new NullPointerException("No output stream was provided.");
        }
        dout.writeInt(this.u4magic);
        dout.writeShort(this.u2minorVersion);
        dout.writeShort(this.u2majorVersion);
        dout.writeShort(this.constantPool.length() + (writeIdString ? 1 : 0));
        Enumeration enumeration = this.constantPool.elements();
        while (enumeration.hasMoreElements()) {
            CpInfo cpInfo = (CpInfo)enumeration.nextElement();
            if (cpInfo == null) continue;
            cpInfo.write(dout);
        }
        if (writeIdString) {
            cpIdString.write(dout);
        }
        dout.writeShort(this.u2accessFlags);
        dout.writeShort(this.u2thisClass);
        dout.writeShort(this.u2superClass);
        dout.writeShort(this.u2interfacesCount);
        for (i = 0; i < this.u2interfacesCount; ++i) {
            dout.writeShort(this.u2interfaces[i]);
        }
        dout.writeShort(this.u2fieldsCount);
        for (i = 0; i < this.u2fieldsCount; ++i) {
            this.fields[i].write(dout);
        }
        dout.writeShort(this.u2methodsCount);
        for (i = 0; i < this.u2methodsCount; ++i) {
            this.methods[i].write(dout);
        }
        dout.writeShort(this.u2attributesCount);
        for (i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].write(dout);
        }
    }

    public void dump(PrintWriter pw) {
        int j;
        ClassConstants info;
        int i;
        pw.println("_____________________________________________________________________");
        pw.println("CLASS: " + this.getName());
        pw.println("Magic: " + Integer.toHexString(this.u4magic));
        pw.println("Minor version: " + Integer.toHexString(this.u2minorVersion));
        pw.println("Major version: " + Integer.toHexString(this.u2majorVersion));
        pw.println();
        pw.println("CP length: " + Integer.toHexString(this.constantPool.length()));
        for (i = 0; i < this.constantPool.length(); ++i) {
            CpInfo cpInfo = this.constantPool.getCpEntry(i);
            if (cpInfo == null) continue;
            cpInfo.dump(pw, this, i);
        }
        pw.println("Access: " + Integer.toHexString(this.u2accessFlags));
        pw.println("This class: " + this.getName());
        pw.println("Superclass: " + this.getSuper());
        pw.println("Interfaces count: " + Integer.toHexString(this.u2interfacesCount));
        for (i = 0; i < this.u2interfacesCount; ++i) {
            info = this.getCpEntry(this.u2interfaces[i]);
            if (info == null) {
                pw.println("  Interface " + Integer.toHexString(i) + ": (null)");
                continue;
            }
            pw.println("  Interface " + Integer.toHexString(i) + ": " + ((Utf8CpInfo)this.getCpEntry(((ClassCpInfo)info).getNameIndex())).getString());
        }
        pw.println("Fields count: " + Integer.toHexString(this.u2fieldsCount));
        for (i = 0; i < this.u2fieldsCount; ++i) {
            info = this.fields[i];
            if (info == null) {
                pw.println("  Field " + Integer.toHexString(i) + ": (null)");
            } else {
                pw.println("  Field " + Integer.toHexString(i) + ": " + ((Utf8CpInfo)this.getCpEntry(((ClassItemInfo)info).getNameIndex())).getString() + " " + ((Utf8CpInfo)this.getCpEntry(((ClassItemInfo)info).getDescriptorIndex())).getString());
            }
            pw.println("    Attrs count: " + Integer.toHexString(((ClassItemInfo)info).u2attributesCount));
            for (j = 0; j < ((ClassItemInfo)info).u2attributesCount; ++j) {
                pw.println(((ClassItemInfo)info).attributes[j]);
            }
        }
        pw.println("Methods count: " + Integer.toHexString(this.u2methodsCount));
        for (i = 0; i < this.u2methodsCount; ++i) {
            info = this.methods[i];
            if (info == null) {
                pw.println("  Method " + Integer.toHexString(i) + ": (null)");
            } else {
                pw.println("  Method " + Integer.toHexString(i) + ": " + ((Utf8CpInfo)this.getCpEntry(((ClassItemInfo)info).getNameIndex())).getString() + " " + ((Utf8CpInfo)this.getCpEntry(((ClassItemInfo)info).getDescriptorIndex())).getString() + " " + Integer.toHexString(((ClassItemInfo)info).getAccessFlags()));
            }
            pw.println("    Attrs count: " + Integer.toHexString(((ClassItemInfo)info).u2attributesCount));
            for (j = 0; j < ((ClassItemInfo)info).u2attributesCount; ++j) {
                if (((ClassItemInfo)info).attributes[j] instanceof CodeAttrInfo) {
                    pw.println(((ClassItemInfo)info).attributes[j]);
                    CodeAttrInfo cai = (CodeAttrInfo)((ClassItemInfo)info).attributes[j];
                    for (int k = 0; k < cai.u2attributesCount; ++k) {
                        pw.println(cai.attributes[k]);
                    }
                    continue;
                }
                pw.println(((ClassItemInfo)info).attributes[j]);
            }
        }
        pw.println("Attrs count: " + Integer.toHexString(this.u2attributesCount));
        for (i = 0; i < this.u2attributesCount; ++i) {
            pw.println(this.attributes[i]);
        }
    }

    public AttrInfo[] getAttributes() {
        return this.attributes;
    }

    public int getU2attributesCount() {
        return this.u2attributesCount;
    }

    public String findModuleName() {
        for (int i = 0; i < this.attributes.length; ++i) {
            int nIdx;
            CpInfo nInfo;
            int mIdx;
            CpInfo mInfo;
            if (!(this.attributes[i] instanceof ModuleAttrInfo) || !((mInfo = this.constantPool.getCpEntry(mIdx = ((ModuleAttrInfo)this.attributes[i]).getModuleNameIndex())) instanceof ModuleCpInfo) || !((nInfo = this.constantPool.getCpEntry(nIdx = ((ModuleCpInfo)mInfo).getNameIndex())) instanceof Utf8CpInfo)) continue;
            return ((Utf8CpInfo)nInfo).getString();
        }
        return "";
    }
}

