/*
 * Decompiled with CFR 0.152.
 */
package com.nuodb.impl.security;

import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class ProtectedString
implements Comparable<ProtectedString> {
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final byte[][] TABLE = ProtectedString.getTable();
    private final byte[][] table = ProtectedString.getTable();
    private final byte[] encrypted;

    public ProtectedString(byte[] unencrypted) {
        this.encrypted = ProtectedString.transform(unencrypted, this.table);
    }

    public int length() {
        return this.encrypted.length;
    }

    public byte[] get() {
        return ProtectedString.transform(this.encrypted, this.table);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T apply(Function<byte[], T> fn) {
        byte[] plaintext = this.get();
        try {
            T t = fn.apply(plaintext);
            return t;
        }
        finally {
            Arrays.fill(plaintext, (byte)0);
        }
    }

    public void consume(Consumer<byte[]> fn) {
        this.apply(unencrypted -> {
            fn.accept((byte[])unencrypted);
            return null;
        });
    }

    public boolean matches(ProtectedString other) {
        return this.apply(unencrypted -> other.apply(otherUnencrypted -> Arrays.equals(unencrypted, otherUnencrypted)));
    }

    public boolean equals(Object other) {
        if (other instanceof ProtectedString) {
            return this.matches((ProtectedString)other);
        }
        return false;
    }

    public int hashCode() {
        return this.apply(unencrypted -> Arrays.hashCode(unencrypted));
    }

    @Override
    public int compareTo(ProtectedString other) {
        return this.apply(unencrypted -> other.apply(otherUnencrypted -> ProtectedString.compare(unencrypted, otherUnencrypted)));
    }

    public byte[] getEncrypted() {
        return Arrays.copyOf(this.encrypted, this.encrypted.length);
    }

    public static ProtectedString createAndClear(byte[] unencrypted) {
        ProtectedString ret = ProtectedString.create(unencrypted);
        if (unencrypted != null) {
            Arrays.fill(unencrypted, (byte)0);
        }
        return ret;
    }

    public static ProtectedString create(byte[] unencrypted) {
        return Optional.ofNullable(unencrypted).map(ProtectedString::new).orElse(null);
    }

    private static byte[][] getTable() {
        byte[][] table = new byte[4][128];
        for (int i = 0; i != 4; ++i) {
            RANDOM.nextBytes(table[i]);
        }
        return table;
    }

    private static byte[] transform(byte[] data, byte[][] table) {
        byte[] ret = new byte[data.length];
        int x = ProtectedString.getValue(table, 0);
        for (int i = 0; i != data.length; ++i) {
            int y = ProtectedString.getValue(TABLE, x);
            x = ProtectedString.getValue(table, y);
            ret[i] = (byte)(data[i] ^ x + y);
        }
        return ret;
    }

    private static int getValue(byte[][] table, int i) {
        if (i < 0 || i > 127) {
            return ProtectedString.getValue(table, i & 0x7F);
        }
        return table[0][i] + table[1][i] + table[2][i] + table[3][i];
    }

    private static int compare(byte[] arr1, byte[] arr2) {
        for (int i = 0; i != arr1.length && i != arr2.length; ++i) {
            int ret = Byte.compare(arr1[i], arr2[i]);
            if (ret == 0) continue;
            return ret;
        }
        return Integer.compare(arr1.length, arr2.length);
    }
}

