/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.pivot;

import com.jidesoft.converter.ConverterContext;
import com.jidesoft.converter.ObjectConverterManager;
import com.jidesoft.grid.CategorizedTable;
import com.jidesoft.grid.CellSpan;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.Expandable;
import com.jidesoft.grid.ExpandableProvider;
import com.jidesoft.grid.GridResource;
import com.jidesoft.grid.Node;
import com.jidesoft.grid.TableSelectionEvent;
import com.jidesoft.grid.TableSelectionListener;
import com.jidesoft.grid.ValueConverter;
import com.jidesoft.grid.ValueStringAdjustProvider;
import com.jidesoft.pivot.CompareToConverter;
import com.jidesoft.pivot.DataTable;
import com.jidesoft.pivot.DefaultValues;
import com.jidesoft.pivot.GrandTotalValue;
import com.jidesoft.pivot.GrandTotalValues;
import com.jidesoft.pivot.HeaderTableCellRenderer;
import com.jidesoft.pivot.HeaderTableModel;
import com.jidesoft.pivot.PivotDataModel;
import com.jidesoft.pivot.PivotField;
import com.jidesoft.pivot.PivotTablePane;
import com.jidesoft.pivot.RunningSummary;
import com.jidesoft.pivot.RunningSummaryValue;
import com.jidesoft.pivot.RunningSummaryValues;
import com.jidesoft.pivot.SummaryValue;
import com.jidesoft.pivot.SummaryValues;
import com.jidesoft.pivot.Value;
import com.jidesoft.pivot.Values;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.AutoScroll;
import com.jidesoft.swing.DelegateMouseInputListener;
import com.jidesoft.swing.JidePopupMenu;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import com.jidesoft.utils.TypeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HeaderTable
extends CategorizedTable
implements PropertyChangeListener,
ExpandableProvider,
TableSelectionListener,
ValueStringAdjustProvider {
    private PivotTablePane \u1e3f;
    private TableCellRenderer \u1e43;
    private boolean \u1e42;
    public static final String PROPERTY_DOUBLE_CLICK_ENABLED = "doubleClickEnabled";
    private AutoScroll \u1e48;
    private Point \u1e46;
    private boolean \u1e47 = true;
    private boolean \u1e3e = true;
    private boolean \u1e40 = false;
    private int \u1e41 = -1;
    private int \u1e45 = -1;
    private static final CellStyle \u1e44 = new CellStyle();

    public HeaderTable(PivotTablePane pivotTablePane) {
        this.\u02b1();
        this.\u1e3f = pivotTablePane;
        this.setAutoConvertCellSpan(false);
        this.\u02a8();
    }

    public HeaderTable(PivotTablePane pivotTablePane, TableModel tableModel) {
        super(tableModel);
        this.\u02b1();
        this.\u1e3f = pivotTablePane;
        this.setAutoConvertCellSpan(false);
        this.\u02a8();
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        if (this.getModel() instanceof HeaderTableModel && !((HeaderTableModel)this.getModel()).isRowHeader() && this.\u1e3f.isColumnHidden(tableColumn.getModelIndex())) {
            tableColumn.setPreferredWidth(0);
            tableColumn.setMinWidth(0);
            tableColumn.setWidth(0);
            this.\u1e3f.\u0102(tableColumn);
        }
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        super.tableChanged(tableModelEvent);
        if (this.getModel() instanceof HeaderTableModel && ((HeaderTableModel)this.getModel()).isRowHeader() && (tableModelEvent == null || tableModelEvent.getFirstRow() == -1 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 || tableModelEvent.getType() == 0 && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getColumn() == -1)) {
            this.clearHiddenRows();
            PivotTablePane pivotTablePane = this.getPivotTablePane();
            if (pivotTablePane != null) {
                JTable jTable = pivotTablePane.getDataTable();
                if (jTable != null) {
                    ((DataTable)jTable).clearHiddenRows();
                }
                for (int i2 = 0; i2 < this.getRowCount(); ++i2) {
                    if (!pivotTablePane.\u0131(i2)) continue;
                    this.addHiddenRow(i2);
                    if (jTable == null) continue;
                    ((DataTable)jTable).addHiddenRow(i2);
                }
            }
        }
    }

    void \u02a7() {
        final HeaderTable headerTable = this;
        this.\u1e48 = new AutoScroll(headerTable){
            int \u0106;
            int \u0108;

            @Override
            public void autoScrollingStarted(int n2) {
                Point point;
                Rectangle rectangle = HeaderTable.this.\u1e3f.getDataTable().getVisibleRect();
                Dimension dimension = HeaderTable.this.\u1e3f.getDataTable().getSize();
                Rectangle rectangle2 = HeaderTable.this.\u1e3f.getScrollPane().getVisibleRect();
                if (n2 == 0 || n2 == 1) {
                    if (rectangle2.getHeight() >= dimension.getHeight()) {
                        this.stopAutoScrolling();
                        return;
                    }
                } else if (rectangle2.getWidth() >= dimension.getWidth()) {
                    this.stopAutoScrolling();
                    return;
                }
                switch (n2) {
                    case 0: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y);
                        break;
                    }
                    case 1: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    case 2: {
                        point = new Point(rectangle.x, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    case 4: {
                        point = new Point(rectangle.x + rectangle.width - 2, rectangle.y + rectangle.height - 2);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter direction" + n2);
                    }
                }
                this.\u0106 = HeaderTable.this.rowAtPoint(point);
                this.\u0108 = HeaderTable.this.columnAtPoint(point);
            }

            @Override
            public void autoScrolling(int n2) {
                if (!this.isAutoScrolling()) {
                    return;
                }
                Rectangle rectangle = HeaderTable.this.\u1e3f.getScrollPane().getViewport().getViewRect();
                switch (n2) {
                    case 0: {
                        if (this.\u0106 <= 0 || HeaderTable.this.\u1e3f.getRowHeaderTable() != headerTable) {
                            return;
                        }
                        --this.\u0106;
                        Rectangle rectangle2 = HeaderTable.this.\u1e3f.getDataTable().getCellRect(this.\u0106, this.\u0108, true);
                        rectangle.y = (int)rectangle2.getMinY();
                        break;
                    }
                    case 1: {
                        if (this.\u0106 >= HeaderTable.this.\u1e3f.getDataTable().getModel().getRowCount() - 1 || HeaderTable.this.\u1e3f.getRowHeaderTable() != headerTable) {
                            return;
                        }
                        ++this.\u0106;
                        Rectangle rectangle3 = HeaderTable.this.\u1e3f.getDataTable().getCellRect(this.\u0106, this.\u0108, true);
                        rectangle.y = (int)((double)rectangle.y + (rectangle3.getMaxY() - rectangle.getMaxY()));
                        break;
                    }
                    case 2: {
                        if (this.\u0108 == 0 || HeaderTable.this.\u1e3f.getColumnHeaderTable() != headerTable) {
                            return;
                        }
                        --this.\u0108;
                        Rectangle rectangle4 = HeaderTable.this.\u1e3f.getDataTable().getCellRect(this.\u0106, this.\u0108, true);
                        rectangle.x = (int)rectangle4.getMinX();
                        break;
                    }
                    case 4: {
                        if (this.\u0108 >= HeaderTable.this.\u1e3f.getDataTable().getModel().getColumnCount() - 1 || HeaderTable.this.\u1e3f.getColumnHeaderTable() != headerTable) {
                            return;
                        }
                        ++this.\u0108;
                        Rectangle rectangle5 = HeaderTable.this.\u1e3f.getDataTable().getCellRect(this.\u0106, this.\u0108, true);
                        rectangle.x = (int)((double)rectangle.x + (rectangle5.getMaxX() - rectangle.getMaxX()));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid parameter direction" + n2);
                    }
                }
                Point point = new Point(rectangle.x, rectangle.y);
                HeaderTable.this.\u1e3f.getScrollPane().getViewport().setViewPosition(point);
            }

            @Override
            public void updateSelectionForEvent(MouseEvent mouseEvent, boolean bl) {
            }
        };
        this.\u1e48.setComponentSelfScrollable(false);
    }

    private void \u02a8() {
        this.setClickCountToStart(2);
        this.\u1e3f.addPropertyChangeListener(this);
        this.\u0101(this.\u1e3f.isPlainHeaderTables(), this.\u1e3f.getHeaderSelectionMode());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    private void \u02b1() {
        if (!this.\u1e42) {
            Object object;
            this.setNonContiguousCellSelection(true);
            this.setCellSelectionEnabled(true);
            this.setAutoResizeMode(0);
            boolean bl = false;
            if (SystemInfo.isJdk6Above() && !SystemInfo.isJdk7Above()) {
                object = this.getMouseListeners();
                MouseListener mouseListener = null;
                for (MouseListener mouseListener2 : object) {
                    if (mouseListener2.getClass().getName().indexOf("TableUI") == -1) continue;
                    mouseListener = mouseListener2;
                    this.removeMouseListener(mouseListener2);
                    if (!(mouseListener2 instanceof MouseMotionListener)) break;
                    this.removeMouseMotionListener((MouseMotionListener)((Object)mouseListener2));
                    break;
                }
                if (mouseListener != null && mouseListener instanceof MouseInputListener) {
                    MouseInputListener mouseInputListener = this.createExpandMouseInputListener((MouseInputListener)mouseListener);
                    JideSwingUtilities.insertMouseListener(this, mouseInputListener, 0);
                    JideSwingUtilities.insertMouseMotionListener(this, mouseInputListener, 0);
                    bl = true;
                }
            }
            if (!bl) {
                object = this.createExpandMouseListener();
                JideSwingUtilities.insertMouseListener(this, (MouseListener)object, 0);
                JideSwingUtilities.insertMouseMotionListener(this, (MouseMotionListener)object, 0);
            }
            this.setColumnResizable(true);
            this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
            this.\u1e42 = true;
        }
    }

    @Override
    public void valueChanged(TableSelectionEvent tableSelectionEvent) {
        if (!tableSelectionEvent.getValueIsAdjusting() && !this.\u1e40) {
            this.\u1e45 = -1;
            this.\u1e41 = -1;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("gridColor".equals(propertyChangeEvent.getPropertyName())) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof Color) {
                this.setGridColor((Color)object);
            }
        } else if ("plainHeaderTables".equals(propertyChangeEvent.getPropertyName()) || "headerSelectionModel".equals(propertyChangeEvent.getPropertyName())) {
            this.\u0101(this.\u1e3f.isPlainHeaderTables(), this.\u1e3f.getHeaderSelectionMode());
            this.\u1e43 = this.createCellRenderer();
        }
    }

    private void \u0101(boolean bl, int n2) {
        if (bl) {
            this.setBackground(UIDefaultsLookup.getColor("Table.background"));
            this.setSelectionBackground(UIDefaultsLookup.getColor("Table.selectionBackground"));
            this.setSelectionForeground(UIDefaultsLookup.getColor("Table.selectionForeground"));
            this.setShowGrid(true);
        } else {
            this.setBackground(UIDefaultsLookup.getColor("Panel.background"));
            this.setSelectionBackground(ColorUtils.getDerivedColor(UIDefaultsLookup.getColor("Table.selectionBackground"), 0.85f));
            this.setSelectionForeground(UIDefaultsLookup.getColor("Table.foreground"));
            this.setShowGrid(false);
        }
        if (n2 == 1) {
            this.setFocusable(false);
            this.setRequestFocusEnabled(false);
        } else {
            this.setFocusable(true);
            this.setRequestFocusEnabled(true);
        }
    }

    protected TableCellRenderer createCellRenderer() {
        return new HeaderTableCellRenderer(this.\u1e3f);
    }

    protected ExpandMouseListener createExpandMouseListener() {
        return new ExpandMouseListener();
    }

    protected MouseInputListener createExpandMouseInputListener(MouseInputListener mouseInputListener) {
        return new DelegateExpandMouseInputListener(mouseInputListener);
    }

    public boolean isExpandIconVisible(Node node) {
        boolean bl = true;
        if (!this.isCellSpanOn()) {
            bl = false;
        }
        if (bl && (this.getPivotTablePane().isHideExpandIconOnSingleRow() || !this.getPivotTablePane().getPivotDataModel().isSummaryMode())) {
            boolean bl2 = bl = node instanceof Expandable && ((Expandable)node).getAllVisibleChildrenCount() > 1;
        }
        if (node == null) {
            bl = false;
        } else if (bl && this.getModel() instanceof HeaderTableModel) {
            boolean bl3 = ((HeaderTableModel)this.getModel()).isRowHeader();
            int n2 = node.getLevel();
            PivotField[] pivotFieldArray = this.getPivotTablePane().getPivotDataModel().getRowFields();
            PivotField[] pivotFieldArray2 = this.getPivotTablePane().getPivotDataModel().getColumnFields();
            if (bl3 && pivotFieldArray.length > n2 && n2 >= 0) {
                PivotField pivotField = pivotFieldArray[n2];
                bl = pivotField.isExpandable();
            } else if (pivotFieldArray2.length > n2 && n2 >= 0) {
                PivotField pivotField = pivotFieldArray2[n2];
                bl = pivotField.isExpandable();
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMousePressedEvent(MouseEvent mouseEvent) {
        Rectangle rectangle;
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
            return;
        }
        if (!(this.getModel() instanceof HeaderTableModel)) {
            return;
        }
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        Point point = mouseEvent.getPoint();
        int n2 = this.rowAtPoint(point);
        int n3 = this.columnAtPoint(point);
        if (n2 < 0 || n3 < 0) {
            return;
        }
        if (this.isClickOnIcon(point) || mouseEvent.getClickCount() == 2) {
            Map<Integer, Integer>[] mapArray = null;
            if (!headerTableModel.isRowHeader()) {
                mapArray = PivotTablePane.getTableColumnWidth(this);
            }
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            Object[] objectArray = this.getPivotTablePane().saveSelection();
            headerTableModel.toggle(n2, n3);
            this.getPivotTablePane().loadSelection(objectArray, false, true);
            if (mapArray != null) {
                PivotTablePane.setTableColumnWidth(this, mapArray);
            }
            mouseEvent.consume();
        } else if (this.\u1e3f.getHeaderSelectionMode() != 0 && (rectangle = this.getCellRect(n2, n3, false)).contains(point)) {
            if (!mouseEvent.isShiftDown()) {
                this.\u1e41 = n2;
                this.\u1e45 = n3;
                this.\u1e40 = true;
                try {
                    this.\u1e3f.selectDataCells(headerTableModel.isRowHeader(), n2, n3, mouseEvent.isControlDown());
                }
                finally {
                    this.\u1e40 = false;
                }
                this.\u0103(point);
            } else if (this.\u1e41 >= 0 && this.\u1e45 >= 0) {
                this.\u1e40 = true;
                try {
                    this.\u1e3f.selectDataCellsBetween(headerTableModel.isRowHeader(), this.\u1e41, this.\u1e45, n2, n3, mouseEvent.isControlDown());
                }
                finally {
                    this.\u1e40 = false;
                }
            }
        }
    }

    protected boolean isClickOnIcon(Point point) {
        int n2 = this.rowAtPoint(point);
        int n3 = this.columnAtPoint(point);
        if (n2 < 0 || n3 < 0 || this.getHeaderTableModel() == null) {
            return false;
        }
        Rectangle rectangle = this.getCellRect(n2, n3, false);
        boolean bl = true;
        Expandable expandable = this.getHeaderTableModel().getExpandable(n2, n3);
        if (expandable == null || !this.isExpandIconVisible(expandable)) {
            bl = false;
        }
        int n4 = (16 - this.getCollapsedIcon().getIconWidth()) / 2 + 2;
        int n5 = n4 + this.getCollapsedIcon().getIconWidth();
        boolean bl2 = this.getComponentOrientation().isLeftToRight();
        boolean bl3 = bl2 ? point.x > rectangle.x + n4 && point.x < rectangle.x + n5 : point.x > rectangle.x + rectangle.width - n5 && point.x < rectangle.x + rectangle.width - n4;
        return bl && bl3 && point.y > rectangle.y && point.y < rectangle.y + this.getRowHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMouseDraggedEvent(MouseEvent mouseEvent, Point point) {
        if (point == null) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
            return;
        }
        if (!(this.getModel() instanceof HeaderTableModel)) {
            return;
        }
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        Point point2 = mouseEvent.getPoint();
        int n2 = this.rowAtPoint(point);
        int n3 = this.columnAtPoint(point);
        int n4 = this.rowAtPoint(point2);
        int n5 = this.columnAtPoint(point2);
        if (!(n4 == -1 && n5 == -1 || this.\u1e3f.getHeaderSelectionMode() == 0 || mouseEvent.isShiftDown() || mouseEvent.isControlDown())) {
            this.\u1e40 = true;
            try {
                this.\u1e3f.selectDataCellsBetween(headerTableModel.isRowHeader(), n2, n3, n4, n5);
            }
            finally {
                this.\u1e40 = false;
            }
        }
    }

    private void \u0105(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && !mouseEvent.isConsumed() && this.isShowContextMenu()) {
            int n2;
            Point point = mouseEvent.getPoint();
            int n3 = this.rowAtPoint(point);
            JPopupMenu jPopupMenu = this.createContextMenu(n3, n2 = this.columnAtPoint(point));
            if (jPopupMenu == null) {
                return;
            }
            if (jPopupMenu.getComponentCount() > 0) {
                JideSwingUtilities.showPopupMenu(jPopupMenu, this, point.x, point.y);
            }
        }
    }

    protected String convertValuesToString(Values values, boolean bl) {
        PivotField[] pivotFieldArray = bl ? this.\u1e3f.getPivotDataModel().getRowFields() : this.\u1e3f.getPivotDataModel().getColumnFields();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < values.getCount(); ++i2) {
            Value value = values.getValueAt(i2);
            if (value != null && value.getValue() != null) {
                Class<?> clazz = TypeUtils.convertPrimitiveToWrapperType(pivotFieldArray[i2].getType());
                if (!clazz.isAssignableFrom(TypeUtils.convertPrimitiveToWrapperType(value.getValue().getClass()))) {
                    stringBuffer = new StringBuffer();
                    break;
                }
                stringBuffer.append(ObjectConverterManager.toString(value.getValue(), pivotFieldArray[i2].getType(), pivotFieldArray[i2].getConverterContext()));
            }
            if (i2 == values.getCount() - 1) continue;
            stringBuffer.append("; ");
        }
        return stringBuffer.toString();
    }

    protected JPopupMenu createContextMenu(final int n2, final int n3) {
        Object object;
        Object object2;
        int n4;
        JMenuItem jMenuItem;
        boolean bl;
        Object object3;
        boolean bl2;
        JidePopupMenu jidePopupMenu = new JidePopupMenu();
        if (!(this.getModel() instanceof HeaderTableModel) || n2 < 0 || n3 < 0) {
            return null;
        }
        final HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        boolean bl3 = headerTableModel.isExpandable(n2, n3);
        boolean bl4 = bl2 = bl3 && headerTableModel.isExpanded(n2, n3);
        if (bl3) {
            String string = ObjectConverterManager.toString(headerTableModel.getValueAt(n2, n3), headerTableModel.getCellClassAt(n2, n3), headerTableModel.getConverterContextAt(n2, n3));
            object3 = new JMenuItem(new AbstractAction(MessageFormat.format(bl2 ? this.\u1e3f.getResourceString("HeaderTable.collapse") : this.\u1e3f.getResourceString("HeaderTable.expand"), string)){
                private static final long \u0106 = -1922964687650823793L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (bl2) {
                        headerTableModel.collapse(n2, n3);
                    } else {
                        headerTableModel.expand(n2, n3);
                    }
                }
            });
            ((Component)object3).setName("HeaderTable.expand");
            jidePopupMenu.add((JMenuItem)object3);
            jidePopupMenu.addSeparator();
        }
        boolean bl5 = headerTableModel.isRowHeader() ? n3 == headerTableModel.getColumnCount() - 1 : (bl = n2 == headerTableModel.getRowCount() - 1);
        if (!bl) {
            object3 = null;
            if (headerTableModel.isRowHeader() && headerTableModel.getPivotDataModel().getRowFields().length > n3) {
                object3 = headerTableModel.getPivotDataModel().getRowFields()[n3].getTitle();
            } else if (!headerTableModel.isRowHeader() && headerTableModel.getPivotDataModel().getColumnFields().length > n2) {
                object3 = headerTableModel.getPivotDataModel().getColumnFields()[n2].getTitle();
            }
            if (object3 != null) {
                jMenuItem = new JMenuItem(new AbstractAction(MessageFormat.format(this.\u1e3f.getResourceString("HeaderTable.expand"), object3)){
                    private static final long \u0105 = -1440227287587987403L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        headerTableModel.expand(headerTableModel.isRowHeader() ? n3 : n2);
                    }
                });
                jMenuItem.setName("HeaderTable.expandColumn");
                jidePopupMenu.add(jMenuItem);
                jMenuItem = new JMenuItem(new AbstractAction(MessageFormat.format(this.\u1e3f.getResourceString("HeaderTable.collapse"), object3)){
                    private static final long \u0105 = -3276704545148986941L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        headerTableModel.collapse(headerTableModel.isRowHeader() ? n3 : n2);
                    }
                });
                jMenuItem.setName("HeaderTable.collapseColumn");
                jidePopupMenu.add(jMenuItem);
                jidePopupMenu.addSeparator();
            }
        }
        object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.expandAll")){
            private static final long \u0103 = 2012145597420606832L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (headerTableModel.isRowHeader()) {
                    PivotField[] pivotFieldArray = HeaderTable.this.getPivotTablePane().getHiddenRowFields();
                    int[] nArray = new int[pivotFieldArray.length];
                    PivotField[] pivotFieldArray2 = HeaderTable.this.getPivotTablePane().getPivotDataModel().getRowFields();
                    block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
                        for (int i3 = 0; i3 < pivotFieldArray2.length; ++i3) {
                            if (pivotFieldArray[i2] != pivotFieldArray2[i3]) continue;
                            nArray[i2] = i3;
                            continue block0;
                        }
                    }
                    headerTableModel.expandAll(nArray);
                } else {
                    headerTableModel.expandAll();
                }
            }
        });
        ((Component)object3).setName("HeaderTable.expandAll");
        jidePopupMenu.add((JMenuItem)object3);
        object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.collapseAll")){
            private static final long \u0103 = 8212290915900686491L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (headerTableModel.isRowHeader()) {
                    PivotField[] pivotFieldArray = HeaderTable.this.getPivotTablePane().getHiddenRowFields();
                    int[] nArray = new int[pivotFieldArray.length];
                    PivotField[] pivotFieldArray2 = HeaderTable.this.getPivotTablePane().getPivotDataModel().getRowFields();
                    block0: for (int i2 = 0; i2 < nArray.length; ++i2) {
                        for (int i3 = 0; i3 < pivotFieldArray2.length; ++i3) {
                            if (pivotFieldArray[i2] != pivotFieldArray2[i3]) continue;
                            nArray[i2] = i3;
                            continue block0;
                        }
                    }
                    headerTableModel.collapseAll(nArray);
                } else {
                    headerTableModel.collapseAll();
                }
            }
        });
        ((Component)object3).setName("HeaderTable.collapseAll");
        jidePopupMenu.add((JMenuItem)object3);
        if (jidePopupMenu.getComponentCount() > 0) {
            jidePopupMenu.addSeparator();
        }
        if (!headerTableModel.isDataCell(n2, n3)) {
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this.\u1e3f.getLocale()).getString("Sort.ascending")){
                private static final long \u0104 = 5582099941772432905L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u0102(n2, n3, 1);
                }
            }));
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this.\u1e3f.getLocale()).getString("Sort.descending")){
                private static final long \u0104 = -7359840126731625241L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u0102(n2, n3, -1);
                }
            }));
            jidePopupMenu.add(new JMenuItem(new AbstractAction(GridResource.getResourceBundle(this.\u1e3f.getLocale()).getString("Sort.unsort")){
                private static final long \u0104 = 6728823837181610987L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u0102(n2, n3, 0);
                }
            }));
            if (jidePopupMenu.getComponentCount() > 0) {
                jidePopupMenu.addSeparator();
            }
        }
        if (this.\u1e3f.getHeaderSelectionMode() != 1) {
            jMenuItem = new JMenu(this.\u1e3f.getResourceString("HeaderTable.filter"));
            jMenuItem.setName("HeaderTable.filter");
            n4 = 3;
            JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.keepSelectedValues")){
                private static final long \u0103 = 4097882012902520185L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u1e3f.\u0103(headerTableModel.isRowHeader(), false);
                }
            });
            jMenuItem2.setName("HeaderTable.keepSelectedValues");
            ((JMenu)jMenuItem).add(jMenuItem2);
            JMenuItem jMenuItem3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.filterSelectedCells")){
                private static final long \u0103 = 4913404928467771126L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u1e3f.\u0103(headerTableModel.isRowHeader(), true);
                }
            });
            jMenuItem3.setName("HeaderTable.filterSelectedCells");
            ((JMenu)jMenuItem).add(jMenuItem3);
            object2 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.clearFilter")){
                private static final long \u0105 = -1510545609357884280L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (HeaderTable.this.getTableSelectionModel().getMaxSelectedRowIndex() == -1) {
                        HeaderTable.this.\u1e3f.clearFilter(headerTableModel.isRowHeader(), n2, n2, n3, n3);
                    } else {
                        HeaderTable.this.\u1e3f.clearFilter(headerTableModel.isRowHeader(), HeaderTable.this.getTableSelectionModel().getMinSelectedRowIndex(), HeaderTable.this.getTableSelectionModel().getMaxSelectedRowIndex(), HeaderTable.this.getTableSelectionModel().getMinSelectedColumnIndex(), HeaderTable.this.getTableSelectionModel().getMaxSelectedColumnIndex());
                    }
                }
            });
            ((Component)object2).setName("HeaderTable.clearFilter");
            ((JMenu)jMenuItem).add((JMenuItem)object2);
            if (!this.\u1e3f.isSelectedHeaderFilterable(headerTableModel.isRowHeader(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedRowIndex() : this.getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedRowIndex() : this.getSelectionModel().getMaxSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMaxSelectionIndex())) {
                jMenuItem2.setEnabled(false);
                jMenuItem3.setEnabled(false);
                n4 -= 2;
            }
            if (this.getTableSelectionModel().getMaxSelectedRowIndex() == -1) {
                if (!this.\u1e3f.isFiltering(headerTableModel.isRowHeader(), n2, n2, n3, n3)) {
                    ((JMenuItem)object2).setEnabled(false);
                    --n4;
                }
            } else if (!this.\u1e3f.isFiltering(headerTableModel.isRowHeader(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedRowIndex() : this.getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedRowIndex() : this.getSelectionModel().getMaxSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMinSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMinSelectionIndex(), this.isNonContiguousCellSelection() ? this.getTableSelectionModel().getMaxSelectedColumnIndex() : this.getColumnModel().getSelectionModel().getMaxSelectionIndex())) {
                ((JMenuItem)object2).setEnabled(false);
                --n4;
            }
            if (n4 != 0) {
                jidePopupMenu.add(jMenuItem);
                jidePopupMenu.addSeparator();
            }
        }
        if (this.getPivotTablePane().getHeaderSelectionMode() == 1) {
            int n5;
            int n6 = headerTableModel.isRowHeader() ? n3 : n2;
            n4 = -1;
            if (this.getPivotTablePane().getPivotDataModel().getDataFields().length > 0) {
                n4 = headerTableModel.isRowHeader() ? n2 : n3;
            }
            int n7 = headerTableModel.isRowHeader() ? headerTableModel.getColumnCount() : headerTableModel.getRowCount();
            int n8 = headerTableModel.isDataFieldAdded() ? n7 - 2 : n7 - 1;
            object2 = headerTableModel.\u01fe();
            int n9 = n5 = headerTableModel.isDataFieldAdded() ? this.getPivotTablePane().getPivotDataModel().getDataFields().length : 1;
            if (n6 <= n8 && n4 >= 0 && n4 < object2.size() * n5 && (object = object2.get(n4 / n5)) instanceof Values && !(object instanceof SummaryValues) && !(object instanceof GrandTotalValues) && !(object instanceof RunningSummaryValues)) {
                Object object4;
                int n10 = (headerTableModel.isRowHeader() ? n3 : n2) + 1;
                if (((Values)object).getCount() > n10) {
                    object4 = new Value[n10];
                    for (int i2 = 0; i2 < ((Value[])object4).length; ++i2) {
                        object4[i2] = ((Values)object).getValueAt(i2);
                    }
                    object = new DefaultValues((Value[])object4);
                }
                if ((object4 = this.convertValuesToString((Values)object, headerTableModel.isRowHeader())) != null && ((String)object4).length() > 0) {
                    object3 = new JMenuItem(new AbstractAction(MessageFormat.format(this.\u1e3f.getResourceString("HeaderTable.hide"), object4)){
                        private static final long \u0105 = -187727219542746580L;

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            HeaderTable.this.\u1e3f.hideValuesAt(headerTableModel.isRowHeader(), n2, n3);
                        }
                    });
                    ((Component)object3).setName("HeaderTable.hide");
                    jidePopupMenu.add((JMenuItem)object3);
                }
            }
        } else {
            object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.hideSelect")){
                private static final long \u0103 = -187727219542746580L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u1e3f.\u0124(headerTableModel.isRowHeader());
                }
            });
            ((Component)object3).setName("HeaderTable.hide");
            jidePopupMenu.add((JMenuItem)object3);
        }
        if (this.\u1e3f.getPivotDataModel().hasHiddenValues()) {
            JMenu jMenu = new JMenu(this.\u1e3f.getResourceString("HeaderTable.show"));
            Values[] valuesArray = this.\u1e3f.getPivotDataModel().getHiddenValues();
            if (this.\u1e3f.getPivotDataModel() instanceof PivotDataModel) {
                valuesArray = headerTableModel.isRowHeader() ? ((PivotDataModel)this.\u1e3f.getPivotDataModel()).\u020a() : ((PivotDataModel)this.\u1e3f.getPivotDataModel()).\u020e();
            }
            for (final Values values : valuesArray) {
                if (values == null || ((String)(object = this.convertValuesToString(values, headerTableModel.isRowHeader()))).length() <= 0) continue;
                JMenuItem jMenuItem4 = new JMenuItem(new AbstractAction((String)object){
                    private static final long \u0103 = 6973874074653119777L;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        HeaderTable.this.\u1e3f.removeHiddenValues(values);
                    }
                });
                jMenu.add(jMenuItem4);
            }
            jMenu.setName("HeaderTable.show");
            jMenu.setEnabled(this.\u1e3f.getPivotDataModel().hasHiddenValues());
            if (jMenu.getPopupMenu().getComponentCount() > 0) {
                jidePopupMenu.add(jMenu);
            }
        }
        object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.showAll")){
            private static final long \u0102 = 6973874074653119776L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                HeaderTable.this.\u1e3f.clearHiddenValues();
            }
        });
        ((Component)object3).setName("HeaderTable.showAll");
        ((JMenuItem)object3).setEnabled(this.\u1e3f.getPivotDataModel().hasHiddenValues());
        jidePopupMenu.add((JMenuItem)object3);
        jidePopupMenu.addSeparator();
        if (headerTableModel.isRowHeader()) {
            object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.hideColumn")){
                private static final long \u0103 = -3592530306539431491L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PivotField[] pivotFieldArray = HeaderTable.this.\u1e3f.getPivotDataModel().getRowFields();
                    if (n3 >= 0 && n3 < pivotFieldArray.length) {
                        HeaderTable.this.\u1e3f.addHiddenRowField(pivotFieldArray[n3]);
                    }
                }
            });
            ((Component)object3).setName("HeaderTable.hideColumn");
            ((JMenuItem)object3).setEnabled(this.\u1e3f.\u025f() > 1);
            jidePopupMenu.add((JMenuItem)object3);
            object3 = new JMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.showAllColumn")){
                private static final long \u0102 = 441529161140264925L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    HeaderTable.this.\u1e3f.clearHiddenRowFields();
                }
            });
            ((Component)object3).setName("HeaderTable.showAllColumn");
            ((JMenuItem)object3).setEnabled(this.\u1e3f.\u0266());
            jidePopupMenu.add((JMenuItem)object3);
            jidePopupMenu.addSeparator();
        }
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction(this.\u1e3f.getResourceString("HeaderTable.showGrandTotal")){
            private static final long \u0103 = -3592530306539431491L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
                if (headerTableModel.isRowHeader()) {
                    HeaderTable.this.\u1e3f.getPivotDataModel().setShowGrandTotalForRow(jCheckBoxMenuItem.isSelected());
                } else {
                    HeaderTable.this.\u1e3f.getPivotDataModel().setShowGrandTotalForColumn(jCheckBoxMenuItem.isSelected());
                }
                HeaderTable.this.\u1e3f.bothHeadersUpdated();
            }
        });
        jCheckBoxMenuItem.setSelected(headerTableModel.isRowHeader() ? this.\u1e3f.getPivotDataModel().isShowGrandTotalForRow() : this.\u1e3f.getPivotDataModel().isShowGrandTotalForColumn());
        jidePopupMenu.add(jCheckBoxMenuItem);
        PivotTablePane.PopupMenuCustomizer popupMenuCustomizer = this.\u1e3f.getHeaderTablePopupMenuCustomizer();
        if (popupMenuCustomizer != null) {
            if (popupMenuCustomizer instanceof PivotTablePane.TablePopupMenuCustomizer) {
                ((PivotTablePane.TablePopupMenuCustomizer)popupMenuCustomizer).customize(jidePopupMenu, this, n2, n3);
            } else {
                popupMenuCustomizer.customize(jidePopupMenu, this);
            }
        }
        return jidePopupMenu;
    }

    public void expandAll() {
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        headerTableModel.expandAll();
    }

    public void collapseAll() {
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        headerTableModel.collapseAll();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n2, int n3) {
        if (this.\u1e43 == null) {
            this.\u1e43 = this.createCellRenderer();
        }
        if (this.\u1e43 instanceof HeaderTableCellRenderer) {
            TableCellRenderer tableCellRenderer = super.getCellRenderer(n2, n3);
            ((HeaderTableCellRenderer)this.\u1e43).setActualCellRenderer(tableCellRenderer);
            return this.\u1e43;
        }
        return super.getCellRenderer(n2, n3);
    }

    @Override
    protected void collectCellStyles(int n2, int n3) {
        super.collectCellStyles(n2, n3);
        this._cellStyleList.add(0, \u1e44);
    }

    @Override
    public boolean isCellSelected(int n2, int n3) {
        return this.\u1e3f.getHeaderSelectionMode() != 1 && super.isCellSelected(n2, n3);
    }

    @Override
    public void changeSelection(int n2, int n3, boolean bl, boolean bl2) {
        if (this.\u1e3f.getHeaderSelectionMode() != 1) {
            super.changeSelection(n2, n3, bl, bl2);
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.\u1e42) {
            this.\u1e43 = this.createCellRenderer();
            this.\u0101(this.\u1e3f.isPlainHeaderTables(), this.\u1e3f.getHeaderSelectionMode());
        }
    }

    public PivotTablePane getPivotTablePane() {
        return this.\u1e3f;
    }

    @Override
    public Expandable getExpandableAt(int n2, int n3) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        return headerTableModel == null ? null : headerTableModel.getExpandable(n2, n3);
    }

    public HeaderTableModel getHeaderTableModel() {
        TableModel tableModel = this.getModel();
        if (tableModel instanceof HeaderTableModel) {
            return (HeaderTableModel)tableModel;
        }
        return null;
    }

    @Override
    public boolean editCellAt(int n2, int n3, EventObject eventObject) {
        Point point;
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton(mouseEvent = (MouseEvent)eventObject) && this.isClickOnIcon(point = mouseEvent.getPoint())) {
            return false;
        }
        return super.editCellAt(n2, n3, eventObject);
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        CellSpan cellSpan;
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel != null && headerTableModel.isRowHeader() && (cellSpan = this.getCellSpanAt(n2, n3)) != null && cellSpan.getColumnSpan() > 1) {
            PivotField[] pivotFieldArray;
            PivotField pivotField = headerTableModel.getFieldAt(cellSpan.getRow(), cellSpan.getColumn());
            for (PivotField pivotField2 : pivotFieldArray = this.getPivotTablePane().getHiddenRowFields()) {
                if (pivotField2 != pivotField) continue;
                return null;
            }
        }
        return super.getValueAt(n2, n3);
    }

    @Override
    public boolean needAdjustCellValueString(int n2, int n3) {
        return false;
    }

    @Override
    public String getValueAtInString(int n2, int n3, ValueConverter valueConverter) {
        Object object = this.getValueAt(n2, n3);
        if (valueConverter != null) {
            object = valueConverter.convert(this, object, n2, n3);
        }
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        Class<?> clazz = this.getCellClassAt(n2, n3);
        ConverterContext converterContext = this.getConverterContextAt(n2, n3);
        String string = ObjectConverterManager.toString(object, clazz, converterContext);
        if (headerTableModel == null) {
            return string;
        }
        Expandable expandable = headerTableModel.getExpandable(n2, n3);
        return this.\u0101(n2, n3, (Value)((Object)expandable), string);
    }

    private String \u0101(int n2, int n3, Value value, String string) {
        HeaderTableModel headerTableModel = this.getHeaderTableModel();
        if (headerTableModel == null) {
            return string;
        }
        if (value instanceof SummaryValue && !headerTableModel.isDataCell(n2, n3)) {
            int n4 = ((SummaryValue)value).getSummaryType();
            string = MessageFormat.format(this.\u1e3f.getResourceString("Renderer.totalPhrase"), string, n4 == -1 ? this.\u1e3f.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n4));
        } else if (value instanceof RunningSummaryValue && !headerTableModel.isDataCell(n2, n3)) {
            string = this.getRunningSummaryTitle((RunningSummaryValue)value, string);
        } else if (value instanceof GrandTotalValue && !headerTableModel.isDataCell(n2, n3)) {
            String string2;
            PivotField[] pivotFieldArray = headerTableModel.getPivotDataModel().getDataFields();
            int n5 = 0;
            boolean bl = false;
            if (pivotFieldArray != null) {
                for (int i2 = 0; i2 < pivotFieldArray.length; ++i2) {
                    if (i2 == 0) {
                        n5 = pivotFieldArray[i2].getGrandTotalSummaryType();
                        continue;
                    }
                    if (n5 == pivotFieldArray[i2].getGrandTotalSummaryType()) continue;
                    bl = true;
                }
            }
            if (headerTableModel.isRowHeader()) {
                try {
                    string2 = this.\u1e3f.getResourceString("Renderer.grandTotal.row");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            } else {
                try {
                    string2 = this.\u1e3f.getResourceString("Renderer.grandTotal.column");
                }
                catch (Exception exception) {
                    string2 = null;
                }
            }
            string = string2 != null ? string2 : (bl ? MessageFormat.format(this.\u1e3f.getResourceString("Renderer.grandTotalPhrase"), this.\u1e3f.getResourceString("Renderer.grandTotal"), this.\u1e3f.getResourceString("Renderer.mixed")) : (n5 == 0 ? this.\u1e3f.getResourceString("Renderer.grandTotal") : MessageFormat.format(this.\u1e3f.getResourceString("Renderer.grandTotalPhrase"), this.\u1e3f.getResourceString("Renderer.grandTotal"), n5 == -1 ? this.\u1e3f.getResourceString("Renderer.total") : headerTableModel.getPivotDataModel().getSummaryCalculator().getSummaryName(this.getLocale(), n5))));
        }
        return string;
    }

    protected String getRunningSummaryTitle(RunningSummaryValue runningSummaryValue, String string) {
        if (runningSummaryValue == null) {
            return string;
        }
        if (runningSummaryValue.getRunningType() == 3 || runningSummaryValue.getRunningType() == 4) {
            return MessageFormat.format(this.\u1e3f.getResourceString("Renderer.runningTotalPhrase"), string, this.\u1e3f.\u0132(runningSummaryValue.getRunningType()));
        }
        if (runningSummaryValue.getRunningType() == 1 || runningSummaryValue.getRunningType() == 2) {
            return MessageFormat.format(this.\u1e3f.getResourceString("Renderer.runningTotalPhrase"), string, this.\u1e3f.\u0132(runningSummaryValue.getRunningType()) + " " + ObjectConverterManager.toString(runningSummaryValue.getCompareTo(), RunningSummary.A.class, CompareToConverter.\u0130));
        }
        return MessageFormat.format(this.\u1e3f.getResourceString("Renderer.runningTotalPhrase2"), string, this.\u1e3f.\u0132(runningSummaryValue.getRunningType()), ObjectConverterManager.toString(runningSummaryValue.getCompareTo(), RunningSummary.A.class, CompareToConverter.\u0130));
    }

    private void \u0102(int n2, int n3, int n4) {
        CellSpan cellSpan;
        HeaderTableModel headerTableModel = (HeaderTableModel)this.getModel();
        PivotField pivotField = headerTableModel.getFieldAt((cellSpan = headerTableModel.getCellSpanAt(n2, n3)).getRow(), cellSpan.getColumn());
        if (pivotField != null) {
            pivotField.setSortOrder(n4);
        }
    }

    private Point \u02b0() {
        return this.\u1e46;
    }

    private void \u0103(Point point) {
        this.\u1e46 = point;
    }

    public boolean isShowContextMenu() {
        return this.\u1e47;
    }

    public void setShowContextMenu(boolean bl) {
        this.\u1e47 = bl;
    }

    public boolean isUseNativeRenderer() {
        return this.\u1e3e;
    }

    public void setUseNativeRenderer(boolean bl) {
        this.\u1e3e = bl;
    }

    static {
        \u1e44.setHorizontalAlignment(10);
        \u1e44.setVerticalAlignment(1);
        \u1e44.setPriority(-1);
    }

    protected class DelegateExpandMouseInputListener
    extends DelegateMouseInputListener {
        public DelegateExpandMouseInputListener(MouseInputListener mouseInputListener) {
            super(mouseInputListener);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            HeaderTable.this.handleMousePressedEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                HeaderTable.this.\u0105(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HeaderTable.this.\u0105(mouseEvent);
            if (HeaderTable.this.\u1e48 != null) {
                HeaderTable.this.\u1e48.mouseReleased(mouseEvent);
            }
            HeaderTable.this.\u0103(null);
            if (!mouseEvent.isConsumed()) {
                super.mouseReleased(mouseEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HeaderTable.this.handleMouseDraggedEvent(mouseEvent, HeaderTable.this.\u02b0());
            if (HeaderTable.this.\u1e48 != null) {
                HeaderTable.this.\u1e48.mouseDragged(mouseEvent);
            }
            if (!mouseEvent.isConsumed()) {
                super.mouseDragged(mouseEvent);
            }
        }
    }

    protected class ExpandMouseListener
    implements MouseMotionListener,
    MouseListener {
        protected ExpandMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            HeaderTable.this.\u0105(mouseEvent);
            if (HeaderTable.this.\u1e48 != null) {
                HeaderTable.this.\u1e48.mouseReleased(mouseEvent);
            }
            HeaderTable.this.\u0103(null);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            HeaderTable.this.handleMouseDraggedEvent(mouseEvent, HeaderTable.this.\u02b0());
            if (HeaderTable.this.\u1e48 != null) {
                HeaderTable.this.\u1e48.mouseDragged(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            HeaderTable.this.handleMousePressedEvent(mouseEvent);
            if (!mouseEvent.isConsumed()) {
                HeaderTable.this.\u0105(mouseEvent);
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

